/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.ext.Module;
import rasmus.interpreter.ext.ModuleFactory;
import rasmus.interpreter.midi.MidiPlayer;
import rasmus.interpreter.midi.MidiSwitch;
import rasmus.interpreter.midi.generators.MidiABCNotation;
import rasmus.interpreter.midi.generators.MidiLongMessage;
import rasmus.interpreter.midi.generators.MidiNote;
import rasmus.interpreter.midi.generators.MidiShortMessage;
import rasmus.interpreter.midi.generators.MidiTempo;
import rasmus.interpreter.midi.io.MidiFile;
import rasmus.interpreter.midi.io.MidiInput;
import rasmus.interpreter.midi.io.MidiOutput;
import rasmus.interpreter.midi.modifiers.MidiChannel;
import rasmus.interpreter.midi.modifiers.MidiChordTranspose;
import rasmus.interpreter.midi.modifiers.MidiDelay;
import rasmus.interpreter.midi.modifiers.MidiExtract;
import rasmus.interpreter.midi.modifiers.MidiFilterMessages;
import rasmus.interpreter.midi.modifiers.MidiFilterMetaMessages;
import rasmus.interpreter.midi.modifiers.MidiFilterNotes;
import rasmus.interpreter.midi.modifiers.MidiModifyMessages;
import rasmus.interpreter.midi.modifiers.MidiMonoNotes;
import rasmus.interpreter.midi.modifiers.MidiRemapNotes;
import rasmus.interpreter.midi.modifiers.MidiStretch;
import rasmus.interpreter.midi.modifiers.MidiTranspose;
import rasmus.interpreter.midi.modifiers.MidiTranspose2;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.unit.UnitInstancePart;

public class MidiModule
extends ModuleFactory {
    public UnitInstancePart newInstance(NameSpace namespace) {
        return new ModuleInstance(namespace);
    }

    class ModuleInstance
    extends Module {
        Interpreter interpreter;

        public ModuleInstance(NameSpace namespace) {
            this.setNameSpace(namespace);
            this.add(":", new MidiNote());
            this.add("ABC", new MidiABCNotation());
            this.add("Switch", new MidiSwitch());
            this.add("PlayMidi", new MidiPlayer());
            this.add("MidiInput", new MidiInput());
            this.add("MidiOutput", new MidiOutput());
            this.add("MidiFile", new MidiFile());
            this.add("MidiPlayer", new MidiPlayer());
            this.add("File", new MidiFile());
            this.add("Channel", new MidiChannel());
            this.add("FilterNotes", new MidiFilterNotes());
            this.add("Transpose", new MidiTranspose());
            this.add("Transpose2", new MidiTranspose2());
            this.add("ChordTranspose", new MidiChordTranspose(-1));
            this.add("ChordTranspose2", new MidiChordTranspose(9));
            this.add("RemapNotes", new MidiRemapNotes());
            this.add("Delay", new MidiDelay());
            this.add("Stretch", new MidiStretch());
            this.add("Extract", new MidiExtract());
            this.add("ShortMessage", new MidiShortMessage());
            this.add("LongMessage", new MidiLongMessage());
            this.add("Note", new MidiNote());
            this.add("Tempo", new MidiTempo());
            this.add("FilterMessages", new MidiFilterMessages());
            this.add("ModifyMessages", new MidiModifyMessages());
            this.add("FilterMetaMessages", new MidiFilterMetaMessages());
            this.add("MonoNotes", new MidiMonoNotes());
            int i = 0;
            while (i < 9) {
                int oct = i * 12;
                this.add("c" + i, oct + 0);
                this.add("c#" + i, oct + 1);
                this.add("d" + i, oct + 2);
                this.add("d#" + i, oct + 3);
                this.add("e" + i, oct + 4);
                this.add("f" + i, oct + 5);
                this.add("f#" + i, oct + 6);
                this.add("g" + i, oct + 7);
                this.add("g#" + i, oct + 8);
                this.add("a" + i, oct + 9);
                this.add("a#" + i, oct + 10);
                this.add("b" + i, oct + 11);
                ++i;
            }
            this.interpreter = new Interpreter(namespace);
            this.interpreter.setAutoCommit(false);
            try {
                this.interpreter.eval("group_midi_dev <- RegisterGroup(\"Input\") <- group_midi_dev_input;");
            }
            catch (ScriptParserException e1) {
                e1.printStackTrace();
            }
            try {
                this.interpreter.eval("group_midi_dev <- RegisterGroup(\"Output\") <- group_midi_dev_output;");
            }
            catch (ScriptParserException e1) {
                e1.printStackTrace();
            }
            MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
            int i2 = 0;
            while (i2 < devinfo.length) {
                try {
                    MidiDevice mididev = MidiSystem.getMidiDevice(devinfo[i2]);
                    try {
                        if (mididev.getReceiver() != null) {
                            this.interpreter.eval("group_midi_dev_output <- RegisterConstant(\"" + devinfo[i2].getName().replaceAll("\\\"", "\"+'\"'+\"") + "\", \"" + devinfo[i2].getDescription() + "\");");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (mididev.getTransmitter() != null) {
                            this.interpreter.eval("group_midi_dev_input <- RegisterConstant(\"" + devinfo[i2].getName().replaceAll("\\\"", "\"+'\"'+\"") + "\", \"" + devinfo[i2].getDescription() + "\");");
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }

        public void close() {
            this.interpreter.close();
            super.close();
        }
    }
}

