/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class MidiPlayerInstance
implements UnitInstancePart {
    static ShortMessage tickmessage = new ShortMessage();
    static ShortMessage stopmessage;
    static ShortMessage startmessage;
    Variable output;
    Variable input;
    Variable controlin;
    Variable controlout;
    Variable sync;
    Receiver syncout;
    Receiver recv = new Receiver(){

        public void send(MidiMessage arg0, long arg1) {
            if (arg0 instanceof ShortMessage) {
                ShortMessage sms = (ShortMessage)arg0;
                if (sms.getStatus() == 250) {
                    MidiPlayerInstance.this.start();
                }
                if (sms.getStatus() == 252) {
                    MidiPlayerInstance.this.stop();
                }
                if (sms.getStatus() == 248) {
                    MidiPlayerInstance.this.clock();
                }
            }
        }

        public void close() {
        }
    };
    boolean playing = false;
    Sequencer sequencer = null;
    boolean start_on_clock = false;

    static {
        try {
            tickmessage.setMessage(249);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        stopmessage = new ShortMessage();
        try {
            stopmessage.setMessage(252);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        startmessage = new ShortMessage();
        try {
            startmessage.setMessage(250);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public Sequencer getSequencer() throws Exception {
        String midiseqname = "Real Time Sequencer";
        MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < devinfo.length) {
            if (devinfo[i].getName().equals(midiseqname)) {
                try {
                    MidiDevice mdev = MidiSystem.getMidiDevice(devinfo[i]);
                    if (mdev instanceof Sequencer) {
                        return (Sequencer)mdev;
                    }
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return MidiSystem.getSequencer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MidiPlayerInstance midiPlayerInstance = this;
        synchronized (midiPlayerInstance) {
            if (!this.playing) {
                int i_sync = (int)DoublePart.asDouble(this.sync);
                if (i_sync == 0) {
                    this.startPlayBack();
                }
                if (i_sync == 1) {
                    this.start_on_clock = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlayBack() {
        this.stop();
        MidiPlayerInstance midiPlayerInstance = this;
        synchronized (midiPlayerInstance) {
            if (!this.playing) {
                this.start_on_clock = false;
                this.playing = true;
                try {
                    this.sequencer = this.getSequencer();
                    this.sequencer.getTransmitter().setReceiver(MidiSequence.getInstance(this.output));
                    this.sequencer.setSequence(MidiSequence.asSequence(this.input));
                    this.sequencer.open();
                }
                catch (Exception e) {
                    if (this.sequencer != null) {
                        this.sequencer.close();
                        this.sequencer = null;
                    }
                    e.printStackTrace();
                }
                if (this.sequencer != null) {
                    this.sequencer.start();
                    if (this.syncout != null) {
                        this.syncout.send(startmessage, -1L);
                    }
                    new Thread(new SeqWatcher(this.sequencer)).start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MidiPlayerInstance midiPlayerInstance = this;
        synchronized (midiPlayerInstance) {
            this.start_on_clock = false;
            if (this.playing) {
                if (this.sequencer != null) {
                    this.sequencer.stop();
                    this.sequencer.close();
                    this.sequencer = null;
                }
                this.playing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clock() {
        boolean start_on_clock;
        MidiPlayerInstance midiPlayerInstance = this;
        synchronized (midiPlayerInstance) {
            start_on_clock = this.start_on_clock;
        }
        if (start_on_clock) {
            this.startPlayBack();
        }
    }

    public MidiPlayerInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.controlin = parameters.getParameterWithDefault(1, "controlin");
        this.controlout = parameters.getParameterWithDefault(2, "controlout");
        this.sync = parameters.getParameterWithDefault(3, "sync");
        Variable syncout = parameters.getParameter("syncout");
        if (syncout != null) {
            this.syncout = MidiSequence.getInstance(syncout);
        }
        MidiSequence.getInstance(this.controlin).addReceiver(this.recv);
    }

    public void close() {
        this.stop();
        MidiSequence.getInstance(this.controlin).removeReceiver(this.recv);
    }

    private class SeqWatcher
    implements Runnable {
        Sequencer sequencer;

        public SeqWatcher(Sequencer sequencer) {
            this.sequencer = sequencer;
        }

        public void run() {
            if (MidiPlayerInstance.this.syncout != null) {
                MidiPlayerInstance.this.syncout.send(tickmessage, -1L);
            }
            long lastms = 0L;
            while (this.sequencer.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
                long ms = this.sequencer.getMicrosecondPosition();
                while (ms - lastms >= 10000L) {
                    lastms += 10000L;
                    MidiPlayerInstance.this.syncout.send(tickmessage, -1L);
                }
            }
            if (MidiPlayerInstance.this.syncout != null) {
                MidiPlayerInstance.this.syncout.send(stopmessage, -1L);
            }
        }
    }
}

