/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;

public class MidiSequence
extends ListPart
implements Receiver,
Transmitter {
    public static int DEFAULT_RES = 480;
    private Sequence sequence;
    private Track track;
    ListPartListener listlistener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            if (resetMode) {
                return;
            }
            if (MidiSequence.this.track != null && object instanceof MidiEvent) {
                MidiSequence.this.track.add((MidiEvent)object);
            }
        }

        public void objectRemoved(ListPart source, Object object) {
            if (resetMode) {
                return;
            }
            if (MidiSequence.this.track != null && object instanceof MidiEvent) {
                MidiSequence.this.track.remove((MidiEvent)object);
            }
        }

        public void objectsAdded(ListPart source, List list) {
            if (resetMode) {
                return;
            }
            if (MidiSequence.this.track != null) {
                for (Object object : list) {
                    if (!(object instanceof MidiEvent)) continue;
                    MidiSequence.this.track.add((MidiEvent)object);
                }
            }
        }

        public void objectsRemoved(ListPart source, List list) {
            if (resetMode) {
                return;
            }
            if (MidiSequence.this.track != null) {
                for (Object object : list) {
                    if (!(object instanceof MidiEvent)) continue;
                    MidiSequence.this.track.remove((MidiEvent)object);
                }
            }
        }
    };
    private ArrayList childvars = new ArrayList();
    public ArrayList receivers = new ArrayList();
    public volatile Receiver[] receiverlist = null;
    Receiver singlereceiver = null;
    static /* synthetic */ Class class$0;

    public static MidiSequence getInstance(Variable variable) {
        return (MidiSequence)variable.get(MidiSequence.class);
    }

    public static MetaMessage getTempoMessage(float tempo) throws Exception {
        long tempoInMPQ = (long)(6.0E7 / (double)tempo);
        byte[] data = new byte[]{(byte)(tempoInMPQ >> 16 & 0xFFL), (byte)(tempoInMPQ >> 8 & 0xFFL), (byte)(tempoInMPQ & 0xFFL)};
        MetaMessage msg = new MetaMessage();
        msg.setMessage(81, data, data.length);
        return msg;
    }

    public static void addEvent(Variable variable, MidiEvent event) {
        ((MidiSequence)variable.get(MidiSequence.class)).addObject(event);
    }

    public static Sequence asSequence(Variable variable) {
        return ((MidiSequence)variable.get(MidiSequence.class)).asSequence();
    }

    public static Variable asVariable(Sequence seq) {
        Variable answer = new Variable();
        LinkedList<MidiEvent> events = new LinkedList<MidiEvent>();
        int sourceres = seq.getResolution();
        int targetres = DEFAULT_RES;
        double resconv = (double)targetres / (double)sourceres;
        Track[] tracks = seq.getTracks();
        int i = 0;
        while (i < tracks.length) {
            Track track = tracks[i];
            int len = track.size();
            int j = 0;
            while (j < len) {
                MidiEvent event = track.get(j);
                events.add(new MidiEvent(event.getMessage(), (long)((double)event.getTick() * resconv)));
                ++j;
            }
            ++i;
        }
        MidiSequence.getInstance(answer).addObjects(events);
        MidiSequence.getInstance(answer).setImmutable(true);
        return answer;
    }

    public MidiSequence() {
        this.forceAddListener(this.listlistener);
    }

    public Sequence asSequence() {
        if (!this.isImmutable() && this.childvars.size() == 1) {
            return MidiSequence.asSequence((Variable)this.childvars.get(0));
        }
        if (this.sequence != null) {
            return this.sequence;
        }
        try {
            this.sequence = new Sequence(0.0f, DEFAULT_RES);
            this.track = this.sequence.createTrack();
            for (Object object : this.getObjects()) {
                if (!(object instanceof MidiEvent)) continue;
                this.track.add((MidiEvent)object);
            }
            return this.sequence;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void add(Variable variable) {
        this.childvars.add(variable);
        MidiSequence.getInstance(variable).addReceiver(this);
        super.add(variable);
    }

    public void remove(Variable variable) {
        this.childvars.add(variable);
        MidiSequence.getInstance(variable).removeReceiver(this);
        super.remove(variable);
    }

    public void addListener(ListPartListener listener) {
        if (listener instanceof Receiver) {
            this.addReceiver((Receiver)((Object)listener));
        }
        super.addListener(listener);
    }

    public void removeListener(ListPartListener listener) {
        if (listener instanceof Receiver) {
            this.removeReceiver((Receiver)((Object)listener));
        }
        super.removeListener(listener);
    }

    public void send(MidiMessage message, long timeStamp) {
        Receiver[] receiverlist = this.receiverlist;
        if (receiverlist != null) {
            int i = 0;
            while (i < receiverlist.length) {
                receiverlist[i].send(message, timeStamp);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(Receiver receiver) {
        ArrayList arrayList = this.receivers;
        synchronized (arrayList) {
            this.receivers.add(receiver);
            Receiver[] receiverlist = new Receiver[this.receivers.size()];
            this.receivers.toArray(receiverlist);
            this.receiverlist = receiverlist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiver(Receiver receiver) {
        ArrayList arrayList = this.receivers;
        synchronized (arrayList) {
            this.receivers.remove(receiver);
            Receiver[] receiverlist = new Receiver[this.receivers.size()];
            this.receivers.toArray(receiverlist);
            this.receiverlist = receiverlist;
        }
    }

    public void close() {
    }

    public void setReceiver(Receiver receiver) {
        if (this.singlereceiver != null) {
            this.removeReceiver(this.singlereceiver);
        }
        this.singlereceiver = receiver;
        if (this.singlereceiver != null) {
            this.addReceiver(this.singlereceiver);
        }
    }

    public Receiver getReceiver() {
        return this.singlereceiver;
    }
}

