/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.generators;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.SysexMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiLongMessageInstance
extends UnitInstanceAdapter {
    Variable output;
    Variable answer = null;
    Variable[] data;
    Variable pos;

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        this.clear();
        this.answer = new Variable();
        MidiSequence midiseq = MidiSequence.getInstance(this.answer);
        midiseq.setImmutable(true);
        byte[] b_data = new byte[this.data.length];
        int i = 0;
        while (i < b_data.length) {
            int i_data = (int)DoublePart.asDouble(this.data[i]);
            b_data[i] = (byte)i_data;
            ++i;
        }
        SysexMessage smsg = new SysexMessage();
        try {
            smsg.setMessage(b_data, b_data.length);
        }
        catch (InvalidMidiDataException e) {
            System.out.println(e);
        }
        long tick = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.pos));
        MidiEvent midievent = new MidiEvent(smsg, tick);
        midiseq.addObject(midievent);
        this.output.add(this.answer);
    }

    public MidiLongMessageInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        ArrayList<Variable> datalist = new ArrayList<Variable>();
        Variable dataitem = parameters.getParameter(1);
        int pi = 2;
        while (dataitem != null) {
            datalist.add(dataitem);
            dataitem = parameters.getParameter(pi);
            ++pi;
        }
        this.data = new Variable[datalist.size()];
        int j = 0;
        while (j < this.data.length) {
            this.data[j] = (Variable)datalist.get(j);
            ++j;
        }
        this.pos = parameters.getParameterWithDefault("pos");
        int i = 0;
        while (i < this.data.length) {
            DoublePart.getInstance(this.data[i]).addListener(this);
            ++i;
        }
        DoublePart.getInstance(this.pos).addListener(this);
        this.calc();
    }

    public void close() {
        int i = 0;
        while (i < this.data.length) {
            DoublePart.getInstance(this.data[i]).removeListener(this);
            ++i;
        }
        DoublePart.getInstance(this.pos).removeListener(this);
        this.clear();
    }
}

