/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.generators;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiShortMessageInstance
extends UnitInstanceAdapter {
    Variable output;
    Variable answer = null;
    Variable command;
    Variable data1;
    Variable data2;
    Variable ch;
    Variable pos;
    Variable todata1;
    Variable todata2;
    Variable len;
    Variable res;

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        int i_len;
        this.clear();
        this.answer = new Variable();
        MidiSequence midiseq = MidiSequence.getInstance(this.answer);
        midiseq.setImmutable(true);
        int i_ch = (int)DoublePart.asDouble(this.ch);
        int i_command = (int)DoublePart.asDouble(this.command);
        double f_data1 = DoublePart.asDouble(this.data1);
        double f_data2 = DoublePart.asDouble(this.data2);
        int i_data1 = (int)DoublePart.asDouble(this.data1);
        int i_data2 = (int)DoublePart.asDouble(this.data2);
        if (i_ch != 0) {
            --i_ch;
        }
        if ((i_len = (int)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.len))) != 0) {
            int i_res = (int)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.res));
            if (i_res == 0) {
                i_res = MidiSequence.DEFAULT_RES / 10;
            }
            long tick = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.pos));
            int count = i_len / i_res;
            double fcount = count;
            double i_to_data1 = (DoublePart.asDouble(this.todata1) - f_data1) / fcount;
            double i_to_data2 = (DoublePart.asDouble(this.todata2) - f_data2) / fcount;
            int i = 0;
            while (i <= count) {
                i_data1 = (int)(f_data1 += i_to_data1);
                i_data2 = (int)(f_data2 += i_to_data2);
                ShortMessage smsg = new ShortMessage();
                try {
                    if (i_command >= 240) {
                        smsg.setMessage(i_command);
                    } else {
                        smsg.setMessage(i_command, i_ch, i_data1, i_data2);
                    }
                }
                catch (InvalidMidiDataException e) {
                    System.out.println(e);
                }
                MidiEvent midievent = new MidiEvent(smsg, tick);
                midiseq.addObject(midievent);
                tick += (long)i_res;
                ++i;
            }
        } else {
            ShortMessage smsg = new ShortMessage();
            try {
                if (i_command >= 240) {
                    smsg.setMessage(i_command);
                } else {
                    smsg.setMessage(i_command, i_ch, i_data1, i_data2);
                }
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e);
            }
            long tick = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.pos));
            MidiEvent midievent = new MidiEvent(smsg, tick);
            midiseq.addObject(midievent);
        }
        this.output.add(this.answer);
    }

    public MidiShortMessageInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.command = parameters.getParameterWithDefault(1, "command");
        this.ch = parameters.getParameterWithDefault(2, "channel");
        this.data1 = parameters.getParameterWithDefault(3, "data1");
        this.data2 = parameters.getParameterWithDefault(4, "data2");
        this.todata1 = parameters.getParameterWithDefault(5, "todata1");
        this.todata2 = parameters.getParameterWithDefault(6, "todata2");
        this.len = parameters.getParameterWithDefault(7, "len");
        this.res = parameters.getParameterWithDefault(8, "res");
        this.pos = parameters.getParameterWithDefault(9, "pos");
        DoublePart.getInstance(this.command).addListener(this);
        DoublePart.getInstance(this.data1).addListener(this);
        DoublePart.getInstance(this.data2).addListener(this);
        DoublePart.getInstance(this.ch).addListener(this);
        DoublePart.getInstance(this.pos).addListener(this);
        DoublePart.getInstance(this.todata1).addListener(this);
        DoublePart.getInstance(this.todata2).addListener(this);
        DoublePart.getInstance(this.len).addListener(this);
        DoublePart.getInstance(this.res).addListener(this);
        this.calc();
    }

    public void close() {
        DoublePart.getInstance(this.command).removeListener(this);
        DoublePart.getInstance(this.data1).removeListener(this);
        DoublePart.getInstance(this.data2).removeListener(this);
        DoublePart.getInstance(this.ch).removeListener(this);
        DoublePart.getInstance(this.pos).removeListener(this);
        DoublePart.getInstance(this.todata1).removeListener(this);
        DoublePart.getInstance(this.todata2).removeListener(this);
        DoublePart.getInstance(this.len).removeListener(this);
        DoublePart.getInstance(this.res).removeListener(this);
        this.clear();
    }
}

