/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.generators;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiTempoInstance
extends UnitInstanceAdapter {
    Variable output;
    Variable answer = null;
    Variable bpm;
    Variable pos;

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        this.clear();
        double bpm_val = DoublePart.asDouble(this.bpm);
        if (bpm_val < 1.0E-7) {
            return;
        }
        long tick = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.pos));
        this.answer = new Variable();
        MidiSequence midiseq = MidiSequence.getInstance(this.answer);
        midiseq.setImmutable(true);
        try {
            MetaMessage mmsg = new MetaMessage();
            int tempoInMPQ = (int)(6.0E7 / bpm_val);
            byte[] data = new byte[]{(byte)(tempoInMPQ >> 16 & 0xFF), (byte)(tempoInMPQ >> 8 & 0xFF), (byte)(tempoInMPQ & 0xFF)};
            mmsg.setMessage(81, data, data.length);
            MidiEvent midievent = new MidiEvent(mmsg, tick);
            midiseq.addObject(midievent);
            this.output.add(this.answer);
        }
        catch (InvalidMidiDataException e) {
            System.out.println(e);
        }
    }

    public MidiTempoInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.bpm = parameters.getParameterWithDefault(1, "bpm");
        this.pos = parameters.getParameterWithDefault(2, "pos");
        DoublePart.getInstance(this.bpm).addListener(this);
        DoublePart.getInstance(this.pos).addListener(this);
        this.calc();
    }

    public void close() {
        DoublePart.getInstance(this.bpm).removeListener(this);
        DoublePart.getInstance(this.pos).removeListener(this);
        this.clear();
    }
}

