/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.io;

import java.io.File;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiFileInstance
extends UnitInstanceAdapter {
    Variable returnvar;
    Variable filename;
    Variable wrkdir;
    Variable answer = null;
    Resource resource = null;
    NameSpace namespace;
    ResourceManager manager;

    public void clear() {
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
            this.answer = null;
        }
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = null;
    }

    public String expandPath(String path) {
        if ((path = path.trim()).length() == 0) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            return path;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == File.separatorChar) {
            return path;
        }
        String wrkdir = ObjectsPart.toString(this.wrkdir);
        if (wrkdir.trim().length() == 0) {
            return path;
        }
        if (wrkdir.endsWith(File.separator)) {
            return String.valueOf(wrkdir) + path;
        }
        return String.valueOf(wrkdir) + File.separator + path;
    }

    public void calc() {
        this.clear();
        String filename = ObjectsPart.toString(this.filename);
        if (!filename.toLowerCase().endsWith(".mid")) {
            return;
        }
        this.resource = this.manager.getResource(filename);
        if (this.resource == null) {
            return;
        }
        File file = this.resource.getFile();
        try {
            Sequence seq = MidiSystem.getSequence(file);
            this.answer = MidiSequence.asVariable(seq);
            this.returnvar.add(this.answer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MidiFileInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.manager = ResourceManager.getInstance(this.namespace);
        this.returnvar = parameters.getParameterWithDefault(0, "output");
        this.filename = parameters.getParameterWithDefault(1, "filename");
        this.wrkdir = parameters.get("wrkdir");
        ObjectsPart.getInstance(this.filename).addListener(this);
        ObjectsPart.getInstance(this.wrkdir).addListener(this);
        this.calc();
    }

    public void close() {
        ObjectsPart.getInstance(this.filename).removeListener(this);
        ObjectsPart.getInstance(this.wrkdir).removeListener(this);
        this.clear();
    }
}

