/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.io;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiOutputInstance
extends UnitInstanceAdapter
implements Receiver {
    Variable input;
    Variable devname;
    MidiDevice mididev = null;
    Receiver recv = null;

    public void clear() {
        if (this.recv != null) {
            this.recv.close();
            this.recv = null;
        }
        if (this.mididev != null) {
            this.mididev.close();
            this.mididev = null;
        }
    }

    public void calc() {
        this.clear();
        String s_devname = ObjectsPart.toString(this.devname);
        if (s_devname.length() != 0) {
            MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
            MidiDevice.Info midimapdev = null;
            int i = 0;
            while (i < devinfo.length) {
                if (devinfo[i].getName().equals(s_devname)) {
                    midimapdev = devinfo[i];
                    try {
                        this.mididev = MidiSystem.getMidiDevice(midimapdev);
                        this.mididev.open();
                        this.recv = this.mididev.getReceiver();
                        return;
                    }
                    catch (MidiUnavailableException e) {
                        e.printStackTrace();
                        try {
                            this.mididev.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
    }

    public MidiOutputInstance(Parameters parameters) {
        this.input = parameters.getParameterWithDefault("input");
        this.devname = parameters.getParameterWithDefault(1, "devname");
        MidiSequence.getInstance(this.input).addReceiver(this);
        ObjectsPart.getInstance(this.devname).addListener(this);
        this.calc();
    }

    public void close() {
        ObjectsPart.getInstance(this.devname).removeListener(this);
        MidiSequence.getInstance(this.input).removeReceiver(this);
        this.clear();
    }

    public void send(MidiMessage arg0, long arg1) {
        if (this.recv != null) {
            this.recv.send(arg0, arg1);
        }
    }
}

