/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiChannelInstance
extends MidiFilterAdapter {
    Variable channel;
    int midichannel = 0;

    public MidiEvent processEvent(MidiEvent midievent) {
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage) {
            ShortMessage omsg = (ShortMessage)msg;
            ShortMessage smsg = new ShortMessage();
            try {
                smsg.setMessage(omsg.getCommand(), this.midichannel, omsg.getData1(), omsg.getData2());
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e.toString());
            }
            msg = smsg;
        }
        long tick = midievent.getTick();
        MidiEvent rmidievent = new MidiEvent(msg, tick);
        return rmidievent;
    }

    public void calc() {
        this.midichannel = (int)DoublePart.asDouble(this.channel);
        if (this.midichannel != 0) {
            --this.midichannel;
        }
        super.calc();
    }

    public MidiChannelInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.channel = parameters.getParameterWithDefault(1, "channel");
        this.input = parameters.getParameterWithDefault(2, "input");
        DoublePart.getInstance(this.channel).addListener(this);
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        DoublePart.getInstance(this.channel).removeListener(this);
        this.clear();
    }
}

