/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;
import rasmus.util.Chord;

class MidiChordTransposeInstance
extends MidiFilterAdapter {
    Variable from;
    Variable to;
    int miditranspose = 0;
    int[] revchordpattern;
    int[] chordpattern;
    int source;
    int target;
    int type;
    int transpose;

    public MidiEvent processEvent(MidiEvent midievent) {
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage) {
            ShortMessage omsg = (ShortMessage)msg;
            int cmd = omsg.getCommand();
            if (omsg.getChannel() != this.type && (cmd == 144 || cmd == 128)) {
                ShortMessage smsg = new ShortMessage();
                try {
                    int data1 = omsg.getData1() - this.source;
                    int note = data1 % 12;
                    while (note < 0) {
                        note += 12;
                    }
                    data1 -= note;
                    note = this.chordpattern[this.revchordpattern[note]];
                    data1 += note;
                    if ((data1 = data1 + this.source + this.transpose) < 0) {
                        return null;
                    }
                    if (data1 > 128) {
                        return null;
                    }
                    smsg.setMessage(cmd, omsg.getChannel(), data1, omsg.getData2());
                }
                catch (InvalidMidiDataException e) {
                    System.out.println(e.toString());
                }
                msg = smsg;
            }
        }
        long tick = midievent.getTick();
        MidiEvent rmidievent = new MidiEvent(msg, tick);
        return rmidievent;
    }

    public void calc() {
        Chord schord = new Chord(ObjectsPart.toString(this.from));
        Chord tchord = new Chord(ObjectsPart.toString(this.to));
        this.source = schord.root;
        this.target = tchord.root;
        this.transpose = (this.target - this.source) % 12;
        if (this.transpose > 6) {
            this.transpose -= 12;
        }
        this.revchordpattern = schord.getTransform(true);
        this.chordpattern = tchord.getTransform(false);
        super.calc();
    }

    public MidiChordTransposeInstance(int type, Parameters parameters) {
        super(parameters.getNameSpace());
        this.type = type;
        this.output = parameters.getParameterWithDefault("output");
        this.from = parameters.getParameterWithDefault(1, "from");
        this.to = parameters.getParameterWithDefault(2, "to");
        this.input = parameters.getParameterWithDefault(3, "input");
        ObjectsPart.getInstance(this.from).addListener(this);
        ObjectsPart.getInstance(this.to).addListener(this);
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        ObjectsPart.getInstance(this.from).removeListener(this);
        ObjectsPart.getInstance(this.to).removeListener(this);
        this.clear();
    }
}

