/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiDelayInstance
extends MidiFilterAdapter {
    Variable transpose;
    long mididpos = 0L;

    public MidiEvent processEvent(MidiEvent midievent) {
        MidiMessage msg = midievent.getMessage();
        long tick = midievent.getTick() + this.mididpos;
        MidiEvent rmidievent = new MidiEvent(msg, tick);
        return rmidievent;
    }

    public void calc() {
        this.mididpos = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.transpose));
        super.calc();
    }

    public MidiDelayInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.transpose = parameters.getParameterWithDefault(1, "pos");
        this.input = parameters.getParameterWithDefault(2, "input");
        DoublePart.getInstance(this.transpose).addListener(this);
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        DoublePart.getInstance(this.transpose).removeListener(this);
        this.clear();
    }
}

