/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.UnitInstanceAdapter;

public abstract class MidiFilterAdapter
extends UnitInstanceAdapter
implements Commitable {
    public NameSpace namespace;
    public Variable output;
    public Variable input;
    public Receiver recv = null;
    public Variable answer = null;
    public Map pevents = new HashMap();
    MidiSequence midiseq;
    ArrayList<CommitEvent> events = new ArrayList();
    boolean in_commit_need = false;
    boolean answer_added = true;
    ArrayList addobjects = new ArrayList();
    ArrayList removeobjects = new ArrayList();
    RListListenerAndRecv midilistener = new RListListenerAndRecv();
    private MidiSequence input_midiseq;

    public MidiFilterAdapter(NameSpace namespace) {
        this.namespace = namespace;
    }

    public void clear() {
        this.in_commit_need = false;
        this.events.clear();
        if (this.answer != null) {
            if (this.answer_added) {
                this.output.remove(this.answer);
            }
            this.pevents.clear();
        }
    }

    public abstract MidiEvent processEvent(MidiEvent var1);

    public void calc() {
        this.clear();
        this.answer = new Variable();
        this.midiseq = MidiSequence.getInstance(this.answer);
        List events = MidiSequence.getInstance(this.input).getObjects();
        for (MidiEvent element : events) {
            MidiEvent pelement = this.processEvent(element);
            if (pelement == null) continue;
            this.pevents.put(element, pelement);
            this.midiseq.addObject(pelement);
        }
        this.output.add(this.answer);
        this.answer_added = true;
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        if (!this.in_commit_need) {
            return;
        }
        this.in_commit_need = false;
        if (this.input_midiseq.getObjects().size() == 0) {
            if (this.answer_added) {
                this.output.remove(this.answer);
                this.answer = new Variable();
                this.midiseq = MidiSequence.getInstance(this.answer);
                this.answer_added = false;
            }
            this.events.clear();
            return;
        }
        if (this.answer == null) {
            this.answer = new Variable();
            this.midiseq = MidiSequence.getInstance(this.answer);
            this.answer_added = false;
        }
        this.addobjects.clear();
        this.removeobjects.clear();
        for (CommitEvent event : this.events) {
            MidiEvent element;
            MidiEvent pelement;
            Object object = event.object;
            if (event.eventtype == 0 && (pelement = this.processEvent(element = (MidiEvent)object)) != null) {
                this.pevents.put(element, pelement);
                this.addobjects.add(pelement);
            }
            if (event.eventtype == 2) {
                for (MidiEvent element2 : (List)object) {
                    MidiEvent pelement2 = this.processEvent(element2);
                    if (pelement2 == null) continue;
                    this.pevents.put(element2, pelement2);
                    this.addobjects.add(pelement2);
                }
                continue;
            }
            if (event.eventtype == 1) {
                Object pelement3 = this.pevents.get(object);
                if (pelement3 == null) continue;
                this.removeobjects.add(pelement3);
                continue;
            }
            if (event.eventtype != 3) continue;
            Iterator iter = ((List)object).iterator();
            while (iter.hasNext()) {
                pelement = this.pevents.get(iter.next());
                if (pelement == null) continue;
                this.removeobjects.add(pelement);
            }
        }
        this.events.clear();
        MidiSequence midiseq = MidiSequence.getInstance(this.answer);
        midiseq.removeObjects(this.removeobjects);
        midiseq.addObjects(this.addobjects);
        this.addobjects.clear();
        this.removeobjects.clear();
        if (!this.answer_added) {
            this.output.add(this.answer);
            this.answer_added = true;
        }
    }

    public void addCommitEvent(int type, ListPart source, Object object) {
        if (!this.in_commit_need) {
            this.in_commit_need = true;
            this.namespace.addToCommitStack(this);
        }
        CommitEvent event = new CommitEvent();
        event.eventtype = type;
        event.source = source;
        event.object = object;
        this.events.add(event);
    }

    public void registerInput(Variable input) {
        this.input_midiseq = MidiSequence.getInstance(input);
        this.input_midiseq.addListener(this.midilistener);
    }

    public void close() {
        if (this.input_midiseq != null) {
            this.input_midiseq.removeListener(this.midilistener);
        }
    }

    class CommitEvent {
        static final int type_objectAdded = 0;
        static final int type_objectRemoved = 1;
        static final int type_objectsAdded = 2;
        static final int type_objectsRemoved = 3;
        int eventtype;
        ListPart source;
        Object object;

        CommitEvent() {
        }
    }

    class RListListenerAndRecv
    implements ListPartListener,
    Receiver {
        RListListenerAndRecv() {
        }

        public void objectAdded(ListPart source, Object object) {
            MidiFilterAdapter.this.addCommitEvent(0, source, object);
        }

        public void objectRemoved(ListPart source, Object object) {
            MidiFilterAdapter.this.addCommitEvent(1, source, object);
        }

        public void objectsAdded(ListPart source, List objects) {
            MidiFilterAdapter.this.addCommitEvent(2, source, objects);
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                this.objectAdded(source, iterator.next());
            }
        }

        public void objectsRemoved(ListPart source, List objects) {
            MidiFilterAdapter.this.addCommitEvent(3, source, objects);
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                this.objectRemoved(source, iterator.next());
            }
        }

        public void send(MidiMessage message, long timeStamp) {
            MidiEvent event;
            MidiEvent pevent;
            if (MidiFilterAdapter.this.recv == null) {
                MidiFilterAdapter.this.recv = MidiSequence.getInstance(MidiFilterAdapter.this.output);
            }
            if ((pevent = MidiFilterAdapter.this.processEvent(event = new MidiEvent(message, 0L))) != null && (message = pevent.getMessage()) != null) {
                MidiFilterAdapter.this.recv.send(message, timeStamp);
            }
        }

        public void close() {
        }
    }
}

