/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiFilterMessagesInstance
extends MidiFilterAdapter {
    long mididpos = 0L;
    Variable command = null;
    Variable commandfrom = null;
    Variable commandto = null;
    Variable commandnot = null;
    Variable channel = null;
    Variable channelfrom = null;
    Variable channelto = null;
    Variable channelnot = null;
    Variable data1 = null;
    Variable data1from = null;
    Variable data1to = null;
    Variable data1not = null;
    Variable data2 = null;
    Variable data2from = null;
    Variable data2to = null;
    Variable data2not = null;
    Variable pos2 = null;
    Variable pos2from = null;
    Variable pos2to = null;
    Variable pos2not = null;
    double f_command = 0.0;
    double f_commandfrom = 0.0;
    double f_commandto = 0.0;
    double f_commandnot = 0.0;
    double f_channel = 0.0;
    double f_channelfrom = 0.0;
    double f_channelto = 0.0;
    double f_channelnot = 0.0;
    double f_data1 = 0.0;
    double f_data1from = 0.0;
    double f_data1to = 0.0;
    double f_data1not = 0.0;
    double f_data2 = 0.0;
    double f_data2from = 0.0;
    double f_data2to = 0.0;
    double f_data2not = 0.0;
    double f_pos2 = 0.0;
    double f_pos2from = 0.0;
    double f_pos2to = 0.0;
    double f_pos2not = 0.0;

    public MidiEvent processEvent(MidiEvent midievent) {
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage) {
            ShortMessage ssmg = (ShortMessage)msg;
            int val = ssmg.getCommand();
            if (this.command != null && !(Math.abs((double)val - this.f_command) < 0.2)) {
                return null;
            }
            if (this.commandnot != null && Math.abs((double)val - this.f_commandnot) < 0.2) {
                return null;
            }
            if (this.commandfrom != null && !((double)val >= this.f_commandfrom)) {
                return null;
            }
            if (this.commandto != null && !((double)val <= this.f_commandto)) {
                return null;
            }
            val = ssmg.getChannel();
            if (this.channel != null && !(Math.abs((double)val - this.f_channel) < 0.2)) {
                return null;
            }
            if (this.channelnot != null && Math.abs((double)val - this.f_channelnot) < 0.2) {
                return null;
            }
            if (this.channelfrom != null && !((double)val >= this.f_channelfrom)) {
                return null;
            }
            if (this.channelto != null && !((double)val <= this.f_channelto)) {
                return null;
            }
            val = ssmg.getData1();
            if (this.data1 != null && !(Math.abs((double)val - this.f_data1) < 0.2)) {
                return null;
            }
            if (this.data1not != null && Math.abs((double)val - this.f_data1not) < 0.2) {
                return null;
            }
            if (this.data1from != null && !((double)val >= this.f_data1from)) {
                return null;
            }
            if (this.data1to != null && !((double)val <= this.f_data1to)) {
                return null;
            }
            val = ssmg.getData2();
            if (this.data2 != null && !(Math.abs((double)val - this.f_data2) < 0.2)) {
                return null;
            }
            if (this.data2not != null && Math.abs((double)val - this.f_data2not) < 0.2) {
                return null;
            }
            if (this.data2from != null && !((double)val >= this.f_data2from)) {
                return null;
            }
            if (this.data2to != null && !((double)val <= this.f_data2to)) {
                return null;
            }
        }
        long tick = midievent.getTick();
        if (this.pos2 != null && !(Math.abs((double)tick - this.f_pos2) < 0.2)) {
            return null;
        }
        if (this.pos2not != null && Math.abs((double)tick - this.f_pos2not) < 0.2) {
            return null;
        }
        if (this.pos2from != null && !((double)tick >= this.f_pos2from)) {
            return null;
        }
        if (this.pos2to != null && !((double)tick <= this.f_pos2to)) {
            return null;
        }
        return midievent;
    }

    public double ToMidiChannel(double in) {
        if (in == 0.0) {
            return 0.0;
        }
        return in - 1.0;
    }

    public void calc() {
        if (this.command != null) {
            this.f_command = DoublePart.asDouble(this.command);
        }
        if (this.commandfrom != null) {
            this.f_commandfrom = DoublePart.asDouble(this.commandfrom);
        }
        if (this.commandto != null) {
            this.f_commandto = DoublePart.asDouble(this.commandto);
        }
        if (this.commandnot != null) {
            this.f_commandnot = DoublePart.asDouble(this.commandnot);
        }
        if (this.channel != null) {
            this.f_channel = this.ToMidiChannel(DoublePart.asDouble(this.channel));
        }
        if (this.channelfrom != null) {
            this.f_channelfrom = this.ToMidiChannel(DoublePart.asDouble(this.channelfrom));
        }
        if (this.channelto != null) {
            this.f_channelto = this.ToMidiChannel(DoublePart.asDouble(this.channelto));
        }
        if (this.channelnot != null) {
            this.f_channelnot = this.ToMidiChannel(DoublePart.asDouble(this.channelnot));
        }
        if (this.data1 != null) {
            this.f_data1 = DoublePart.asDouble(this.data1);
        }
        if (this.data1from != null) {
            this.f_data1from = DoublePart.asDouble(this.data1from);
        }
        if (this.data1to != null) {
            this.f_data1to = DoublePart.asDouble(this.data1to);
        }
        if (this.data1not != null) {
            this.f_data1not = DoublePart.asDouble(this.data1not);
        }
        if (this.data2 != null) {
            this.f_data2 = DoublePart.asDouble(this.data2);
        }
        if (this.data2from != null) {
            this.f_data2from = DoublePart.asDouble(this.data2from);
        }
        if (this.data2to != null) {
            this.f_data2to = DoublePart.asDouble(this.data2to);
        }
        if (this.data2not != null) {
            this.f_data2not = DoublePart.asDouble(this.data2not);
        }
        if (this.pos2 != null) {
            this.f_pos2 = DoublePart.asDouble(this.pos2) * (double)MidiSequence.DEFAULT_RES;
        }
        if (this.pos2from != null) {
            this.f_pos2from = DoublePart.asDouble(this.pos2from) * (double)MidiSequence.DEFAULT_RES;
        }
        if (this.pos2to != null) {
            this.f_pos2to = DoublePart.asDouble(this.pos2to) * (double)MidiSequence.DEFAULT_RES;
        }
        if (this.pos2not != null) {
            this.f_pos2not = DoublePart.asDouble(this.pos2not) * (double)MidiSequence.DEFAULT_RES;
        }
        super.calc();
    }

    public MidiFilterMessagesInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.command = parameters.getParameter("command");
        this.commandfrom = parameters.getParameter("commandfrom");
        this.commandto = parameters.getParameter("commandto");
        this.commandnot = parameters.getParameter("commandnot");
        this.channel = parameters.getParameter("channel");
        this.channelfrom = parameters.getParameter("channelfrom");
        this.channelto = parameters.getParameter("channelto");
        this.channelnot = parameters.getParameter("channelnot");
        this.data1 = parameters.getParameter("data1");
        this.data1from = parameters.getParameter("data1from");
        this.data1to = parameters.getParameter("data1to");
        this.data1not = parameters.getParameter("data1not");
        this.data2 = parameters.getParameter("data2");
        this.data2from = parameters.getParameter("data2from");
        this.data2to = parameters.getParameter("data2to");
        this.data2not = parameters.getParameter("data2not");
        this.pos2 = parameters.getParameter("pos");
        this.pos2from = parameters.getParameter("posfrom");
        this.pos2to = parameters.getParameter("posto");
        this.pos2not = parameters.getParameter("posnot");
        if (this.command != null) {
            DoublePart.getInstance(this.command).addListener(this);
        }
        if (this.commandfrom != null) {
            DoublePart.getInstance(this.commandfrom).addListener(this);
        }
        if (this.commandto != null) {
            DoublePart.getInstance(this.commandto).addListener(this);
        }
        if (this.commandnot != null) {
            DoublePart.getInstance(this.commandnot).addListener(this);
        }
        if (this.channel != null) {
            DoublePart.getInstance(this.channel).addListener(this);
        }
        if (this.channelfrom != null) {
            DoublePart.getInstance(this.channelfrom).addListener(this);
        }
        if (this.channelto != null) {
            DoublePart.getInstance(this.channelto).addListener(this);
        }
        if (this.channelnot != null) {
            DoublePart.getInstance(this.channelnot).addListener(this);
        }
        if (this.data1 != null) {
            DoublePart.getInstance(this.data1).addListener(this);
        }
        if (this.data1from != null) {
            DoublePart.getInstance(this.data1from).addListener(this);
        }
        if (this.data1to != null) {
            DoublePart.getInstance(this.data1to).addListener(this);
        }
        if (this.data1not != null) {
            DoublePart.getInstance(this.data1not).addListener(this);
        }
        if (this.data2 != null) {
            DoublePart.getInstance(this.data2).addListener(this);
        }
        if (this.data2from != null) {
            DoublePart.getInstance(this.data2from).addListener(this);
        }
        if (this.data2to != null) {
            DoublePart.getInstance(this.data2to).addListener(this);
        }
        if (this.data2not != null) {
            DoublePart.getInstance(this.data2not).addListener(this);
        }
        if (this.pos2 != null) {
            DoublePart.getInstance(this.pos2).addListener(this);
        }
        if (this.pos2from != null) {
            DoublePart.getInstance(this.pos2from).addListener(this);
        }
        if (this.pos2to != null) {
            DoublePart.getInstance(this.pos2to).addListener(this);
        }
        if (this.pos2not != null) {
            DoublePart.getInstance(this.pos2not).addListener(this);
        }
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        if (this.command != null) {
            DoublePart.getInstance(this.command).removeListener(this);
        }
        if (this.commandfrom != null) {
            DoublePart.getInstance(this.commandfrom).removeListener(this);
        }
        if (this.commandto != null) {
            DoublePart.getInstance(this.commandto).removeListener(this);
        }
        if (this.commandnot != null) {
            DoublePart.getInstance(this.commandnot).removeListener(this);
        }
        if (this.channel != null) {
            DoublePart.getInstance(this.channel).removeListener(this);
        }
        if (this.channelfrom != null) {
            DoublePart.getInstance(this.channelfrom).removeListener(this);
        }
        if (this.channelto != null) {
            DoublePart.getInstance(this.channelto).removeListener(this);
        }
        if (this.channelnot != null) {
            DoublePart.getInstance(this.channelnot).removeListener(this);
        }
        if (this.data1 != null) {
            DoublePart.getInstance(this.data1).removeListener(this);
        }
        if (this.data1from != null) {
            DoublePart.getInstance(this.data1from).removeListener(this);
        }
        if (this.data1to != null) {
            DoublePart.getInstance(this.data1to).removeListener(this);
        }
        if (this.data1not != null) {
            DoublePart.getInstance(this.data1not).removeListener(this);
        }
        if (this.data2 != null) {
            DoublePart.getInstance(this.data2).removeListener(this);
        }
        if (this.data2from != null) {
            DoublePart.getInstance(this.data2from).removeListener(this);
        }
        if (this.data2to != null) {
            DoublePart.getInstance(this.data2to).removeListener(this);
        }
        if (this.data2not != null) {
            DoublePart.getInstance(this.data2not).removeListener(this);
        }
        if (this.pos2 != null) {
            DoublePart.getInstance(this.pos2).removeListener(this);
        }
        if (this.pos2from != null) {
            DoublePart.getInstance(this.pos2from).removeListener(this);
        }
        if (this.pos2to != null) {
            DoublePart.getInstance(this.pos2to).removeListener(this);
        }
        if (this.pos2not != null) {
            DoublePart.getInstance(this.pos2not).removeListener(this);
        }
        this.clear();
    }
}

