/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiRemapNotesInstance
extends MidiFilterAdapter {
    Variable[] transpose = new Variable[12];
    int[] miditranspose = new int[12];

    public MidiEvent processEvent(MidiEvent midievent) {
        ShortMessage omsg;
        int cmd;
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage && ((cmd = (omsg = (ShortMessage)msg).getCommand()) == 144 || cmd == 128)) {
            ShortMessage smsg = new ShortMessage();
            try {
                int t;
                int data1 = omsg.getData1();
                data1 = t = this.miditranspose[data1 % 12];
                if (data1 > 128) {
                    return null;
                }
                smsg.setMessage(cmd, omsg.getChannel(), data1, omsg.getData2());
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e.toString());
            }
            msg = smsg;
        }
        long tick = midievent.getTick();
        MidiEvent rmidievent = new MidiEvent(msg, tick);
        return rmidievent;
    }

    public void calc() {
        int i = 0;
        while (i < 12) {
            this.miditranspose[i] = (int)DoublePart.asDouble(this.transpose[i]);
            ++i;
        }
        super.calc();
    }

    public MidiRemapNotesInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.transpose[0] = parameters.getParameterWithDefault(1, "c");
        this.transpose[1] = parameters.getParameterWithDefault(2, "c#");
        this.transpose[2] = parameters.getParameterWithDefault(3, "d");
        this.transpose[3] = parameters.getParameterWithDefault(4, "d#");
        this.transpose[4] = parameters.getParameterWithDefault(5, "e");
        this.transpose[5] = parameters.getParameterWithDefault(6, "f");
        this.transpose[6] = parameters.getParameterWithDefault(7, "f#");
        this.transpose[7] = parameters.getParameterWithDefault(8, "g");
        this.transpose[8] = parameters.getParameterWithDefault(9, "g#");
        this.transpose[9] = parameters.getParameterWithDefault(10, "a");
        this.transpose[10] = parameters.getParameterWithDefault(11, "a#");
        this.transpose[11] = parameters.getParameterWithDefault(12, "b");
        int i = 0;
        while (i < this.transpose.length) {
            if (this.transpose[i] != null) {
                DoublePart.getInstance(this.transpose[i]).addListener(this);
            }
            ++i;
        }
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        int i = 0;
        while (i < 12) {
            if (this.transpose[i] != null) {
                DoublePart.getInstance(this.transpose[i]).removeListener(this);
            }
            ++i;
        }
        this.clear();
    }
}

