/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiStretchInstance
extends MidiFilterAdapter {
    Variable amount;
    double f_amount = 1.0;

    public MidiEvent processEvent(MidiEvent midievent) {
        MidiMessage msg = midievent.getMessage();
        long tick = (long)((double)midievent.getTick() * this.f_amount);
        MidiEvent rmidievent = new MidiEvent(msg, tick);
        return rmidievent;
    }

    public void calc() {
        this.f_amount = DoublePart.asDouble(this.amount);
        super.calc();
    }

    public MidiStretchInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.amount = parameters.getParameterWithDefault(1, "amount");
        this.input = parameters.getParameterWithDefault("input");
        DoublePart.getInstance(this.amount).addListener(this);
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        DoublePart.getInstance(this.amount).removeListener(this);
        this.clear();
    }
}

