/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.namespace;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import rasmus.interpreter.Commitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitSystem {
    private TreeMap<Integer, LinkedList<Commitable>> runlevels = new TreeMap();
    private Commitable[] commitables;
    private int commitables_len = 0;
    private int commit_count = 0;
    private boolean iscommiting = false;

    private LinkedList<Commitable> getRunLevelList(int runlevel) {
        LinkedList<Commitable> list = this.runlevels.get(runlevel);
        if (list == null) {
            list = new LinkedList();
            this.runlevels.put(runlevel, list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        CommitSystem commitSystem;
        CommitSystem commitSystem2 = this;
        synchronized (commitSystem2) {
            if (this.commit_count == 0) {
                return;
            }
            if (this.iscommiting) {
                return;
            }
            this.iscommiting = true;
        }
        block9: while (true) {
            commitSystem = this;
            synchronized (commitSystem) {
                Iterator<Map.Entry<Integer, LinkedList<Commitable>>> iter = this.runlevels.entrySet().iterator();
                this.commitables_len = 0;
                while (iter.hasNext()) {
                    Map.Entry<Integer, LinkedList<Commitable>> entry = iter.next();
                    if (entry.getValue().isEmpty()) continue;
                    LinkedList<Commitable> commitstack = entry.getValue();
                    if (this.commitables == null || this.commitables.length < commitstack.size()) {
                        this.commitables = new Commitable[commitstack.size()];
                    }
                    this.commitables_len = commitstack.size();
                    commitstack.toArray(this.commitables);
                    this.commit_count -= this.commitables_len;
                    commitstack.clear();
                    break;
                }
                if (this.commitables_len == 0) {
                    break;
                }
            }
            int i = 0;
            while (true) {
                if (i >= this.commitables_len) continue block9;
                this.commitables[i].commit();
                ++i;
            }
            break;
        }
        commitSystem = this;
        synchronized (commitSystem) {
            this.iscommiting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Commitable commitable) {
        CommitSystem commitSystem = this;
        synchronized (commitSystem) {
            LinkedList<Commitable> commitstack = this.getRunLevelList(commitable.getRunLevel());
            if (commitstack.remove(commitable)) {
                --this.commit_count;
            }
            commitstack.offer(commitable);
            ++this.commit_count;
        }
    }
}

