/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rasmus.interpreter.parser.ScriptElement;

public class ScriptOptimizer {
    private static List binaryOperators = new ArrayList();
    private static List unaryOperators = new ArrayList();

    static {
        binaryOperators.add("+");
        binaryOperators.add("-");
        binaryOperators.add("*");
        binaryOperators.add("/");
        binaryOperators.add("^");
        binaryOperators.add("pow");
        binaryOperators.add("min");
        binaryOperators.add("max");
        unaryOperators.add("-");
        unaryOperators.add("round");
        unaryOperators.add("floor");
        unaryOperators.add("rint");
        unaryOperators.add("abs");
        unaryOperators.add("exp");
        unaryOperators.add("log");
        unaryOperators.add("sin");
        unaryOperators.add("cos");
        unaryOperators.add("tan");
        unaryOperators.add("asin");
        unaryOperators.add("acos");
        unaryOperators.add("atan");
    }

    public static ScriptElement optimize(ScriptElement element) {
        return ScriptOptimizer.foldConstants(ScriptOptimizer.expandPlusMinus(ScriptOptimizer.expandMinus(element)));
    }

    public static ScriptElement foldConstants(ScriptElement element) {
        List<ScriptElement> elements = element.getElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.size()) {
                elements.set(i, ScriptOptimizer.foldConstants(elements.get(i)));
                ++i;
            }
        }
        element = ScriptOptimizer.foldNumberConstants(element);
        element = ScriptOptimizer.foldStringConstants(element);
        return element;
    }

    public static ScriptElement foldNumberConstants(ScriptElement element) {
        if (element.getType() != 2) {
            return element;
        }
        List<ScriptElement> elements = element.getElements();
        if (elements == null) {
            return element;
        }
        if (element.getValue() == null) {
            return element;
        }
        String callname = ((String)element.getValue()).toLowerCase();
        if (callname.equals("+")) {
            Double number = null;
            ArrayList<ScriptElement> extraparameters = null;
            int i = 0;
            while (i < elements.size()) {
                ScriptElement param;
                if (elements.get(i).getType() == 3 && (param = elements.get(i)).getElements() != null && param.getElements().size() == 1) {
                    ScriptElement paramvalue = param.getElements().get(0);
                    if (paramvalue.getType() == 5) {
                        number = number == null ? (Double)paramvalue.getValue() : Double.valueOf(number + (Double)paramvalue.getValue());
                    } else {
                        if (extraparameters == null) {
                            extraparameters = new ArrayList<ScriptElement>();
                        }
                        extraparameters.add(paramvalue);
                    }
                }
                ++i;
            }
            if (number == null) {
                return element;
            }
            if (extraparameters == null) {
                return new ScriptElement(5, number);
            }
            if (number != null) {
                extraparameters.add(new ScriptElement(5, number));
            }
            element = new ScriptElement(2, "+");
            int paramno = 1;
            for (ScriptElement scriptelement : extraparameters) {
                ScriptElement param = new ScriptElement(3, Integer.toString(paramno));
                param.add(scriptelement);
                element.add(param);
                ++paramno;
            }
            return element;
        }
        ScriptElement param1 = null;
        ScriptElement param2 = null;
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i).getType() == 3) {
                ScriptElement param = elements.get(i);
                if (param.getValue() == null) {
                    return element;
                }
                if (param.getElements() == null) {
                    return element;
                }
                if (param.getElements().size() != 1) {
                    return element;
                }
                String paramname = (String)param.getValue();
                ScriptElement paramvalue = param.getElements().get(0);
                if (paramvalue.getType() != 5) {
                    return element;
                }
                if (paramname.equals("1")) {
                    param1 = paramvalue;
                } else if (paramname.equals("2")) {
                    param2 = paramvalue;
                }
            }
            ++i;
        }
        Double ret = null;
        if (unaryOperators.contains(callname) && param1 != null && param2 == null) {
            double p1 = (Double)param1.getValue();
            if (callname.equals("-")) {
                ret = -p1;
            } else if (callname.equals("round")) {
                ret = Math.round(p1);
            } else if (callname.equals("floor")) {
                ret = Math.floor(p1);
            } else if (callname.equals("rint")) {
                ret = Math.rint(p1);
            } else if (callname.equals("abs")) {
                ret = Math.abs(p1);
            } else if (callname.equals("exp")) {
                ret = Math.exp(p1);
            } else if (callname.equals("log")) {
                ret = Math.log(p1);
            } else if (callname.equals("sin")) {
                ret = Math.sin(p1);
            } else if (callname.equals("cos")) {
                ret = Math.cos(p1);
            } else if (callname.equals("tan")) {
                ret = Math.tan(p1);
            } else if (callname.equals("asin")) {
                ret = Math.asin(p1);
            } else if (callname.equals("acos")) {
                ret = Math.acos(p1);
            } else if (callname.equals("atan")) {
                ret = Math.atan(p1);
            }
        } else if (binaryOperators.contains(callname) && param1 != null && param2 != null) {
            double p1 = (Double)param1.getValue();
            double p2 = (Double)param2.getValue();
            if (callname.equals("+")) {
                ret = p1 + p2;
            } else if (callname.equals("-")) {
                ret = p1 - p2;
            } else if (callname.equals("*")) {
                ret = p1 * p2;
            } else if (callname.equals("/")) {
                ret = p1 / p2;
            } else if (callname.equals("^") || callname.equals("pow")) {
                ret = Math.pow(p1, p2);
            } else if (callname.equals("min")) {
                ret = Math.min(p1, p2);
            } else if (callname.equals("max")) {
                ret = Math.max(p1, p2);
            }
        }
        if (ret == null) {
            return element;
        }
        return new ScriptElement(5, ret);
    }

    public static ScriptElement foldStringConstants(ScriptElement element) {
        if (element.getType() != 2) {
            return element;
        }
        List<ScriptElement> elements = element.getElements();
        if (elements == null) {
            return element;
        }
        if (element.getValue() == null) {
            return element;
        }
        String callname = ((String)element.getValue()).toLowerCase();
        if (!callname.equals("&")) {
            return element;
        }
        ScriptElement param1 = null;
        ScriptElement param2 = null;
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i).getType() == 3) {
                ScriptElement param = elements.get(i);
                if (param.getValue() == null) {
                    return element;
                }
                if (param.getElements() == null) {
                    return element;
                }
                if (param.getElements().size() != 1) {
                    return element;
                }
                String paramname = (String)param.getValue();
                ScriptElement paramvalue = param.getElements().get(0);
                if (paramvalue.getType() != 4) {
                    return element;
                }
                if (paramname.equals("1")) {
                    param1 = paramvalue;
                } else if (paramname.equals("2")) {
                    param2 = paramvalue;
                }
            }
            ++i;
        }
        if (callname.equals("&")) {
            String ret = String.valueOf((String)param1.getValue()) + (String)param2.getValue();
            return new ScriptElement(4, ret);
        }
        return element;
    }

    public static ScriptElement expandPlusMinus(ScriptElement element) {
        int i;
        List<ScriptElement> elements = element.getElements();
        if (elements != null) {
            i = 0;
            while (i < elements.size()) {
                elements.set(i, ScriptOptimizer.expandPlusMinus(elements.get(i)));
                ++i;
            }
        }
        if (element.getType() == 2) {
            List<ScriptElement> subelements;
            if (element.getValue().equals("-") && elements.size() > 1) {
                i = 0;
                while (i < elements.size()) {
                    ScriptElement param;
                    String paramname;
                    if (elements.get(i).getType() == 3 && !(paramname = (String)(param = elements.get(i)).getValue()).equals("1") && (subelements = param.getElements()) != null) {
                        int j = 0;
                        while (j < subelements.size()) {
                            ScriptElement subelement = new ScriptElement(2, "-");
                            ScriptElement subparam = new ScriptElement(3, "1");
                            subparam.add(subelements.get(j));
                            subelement.add(subparam);
                            subelements.set(j, subelement);
                            ++j;
                        }
                    }
                    ++i;
                }
                element = new ScriptElement(2, "+");
                if (elements != null) {
                    i = 0;
                    while (i < elements.size()) {
                        element.add(elements.get(i));
                        ++i;
                    }
                }
            }
            if (element.getValue().equals("+")) {
                elements = element.getElements();
                ArrayList<ScriptElement> newelements = new ArrayList<ScriptElement>();
                int i2 = 0;
                while (i2 < elements.size()) {
                    ScriptElement param;
                    if (elements.get(i2).getType() == 3 && (subelements = (param = elements.get(i2)).getElements()) != null && subelements.size() == 1) {
                        ScriptElement subelement = subelements.get(0);
                        if (subelement.getType() == 2 && subelement.getValue().equals("+")) {
                            List<ScriptElement> subsubelements = subelement.getElements();
                            int j = 0;
                            while (j < subsubelements.size()) {
                                ScriptElement subsubelement = subsubelements.get(j);
                                if (subsubelement.getElements() != null && subsubelement.getElements().size() == 1) {
                                    newelements.add(subsubelement.getElements().get(0));
                                }
                                ++j;
                            }
                        } else {
                            newelements.add(subelement);
                        }
                    }
                    ++i2;
                }
                elements.clear();
                Iterator iterator = newelements.iterator();
                int paramno = 1;
                while (iterator.hasNext()) {
                    ScriptElement scriptelement = (ScriptElement)iterator.next();
                    ScriptElement param = new ScriptElement(3, Integer.toString(paramno));
                    param.add(scriptelement);
                    element.add(param);
                    ++paramno;
                }
            }
        }
        return element;
    }

    public static ScriptElement expandMinus(ScriptElement element) {
        List<ScriptElement> elements = element.getElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.size()) {
                elements.set(i, ScriptOptimizer.expandMinus(elements.get(i)));
                ++i;
            }
        }
        if (element.getType() == 2 && element.getValue().equals("-") && elements.size() > 1) {
            elements = element.getElements();
            ArrayList<ScriptElement> newelements = new ArrayList<ScriptElement>();
            int i = 0;
            while (i < elements.size()) {
                if (elements.get(i).getType() == 3) {
                    ScriptElement param = elements.get(i);
                    String paramname = (String)param.getValue();
                    List<ScriptElement> subelements = param.getElements();
                    if (subelements != null && subelements.size() == 1) {
                        ScriptElement subelement = subelements.get(0);
                        if (paramname.equals("1")) {
                            if (subelement.getType() == 2 && subelement.getValue().equals("-") && subelement.getElements() != null && subelement.getElements().size() != 1) {
                                List<ScriptElement> subsubelements = subelement.getElements();
                                int j = 0;
                                while (j < subsubelements.size()) {
                                    ScriptElement subsubelement = subsubelements.get(j);
                                    if (subsubelement.getElements() != null && subsubelement.getElements().size() == 1) {
                                        newelements.add(subsubelement.getElements().get(0));
                                    }
                                    ++j;
                                }
                            } else {
                                newelements.add(subelement);
                            }
                        } else {
                            newelements.add(subelement);
                        }
                    }
                }
                ++i;
            }
            elements.clear();
            Iterator iterator = newelements.iterator();
            int paramno = 1;
            while (iterator.hasNext()) {
                ScriptElement scriptelement = (ScriptElement)iterator.next();
                ScriptElement param = new ScriptElement(3, Integer.toString(paramno));
                param.add(scriptelement);
                element.add(param);
                ++paramno;
            }
        }
        return element;
    }
}

