/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled;

import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.ext.Module;
import rasmus.interpreter.ext.ModuleFactory;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.AudioPlayer;
import rasmus.interpreter.sampled.generators.AudioAdsr;
import rasmus.interpreter.sampled.generators.AudioAhdsr;
import rasmus.interpreter.sampled.generators.AudioClock;
import rasmus.interpreter.sampled.generators.AudioCounter;
import rasmus.interpreter.sampled.generators.AudioDSF;
import rasmus.interpreter.sampled.generators.AudioExpSeg;
import rasmus.interpreter.sampled.generators.AudioLinSeg;
import rasmus.interpreter.sampled.generators.AudioOne;
import rasmus.interpreter.sampled.generators.AudioRandom;
import rasmus.interpreter.sampled.generators.AudioRelease;
import rasmus.interpreter.sampled.generators.AudioSampleRate;
import rasmus.interpreter.sampled.generators.AudioSignal;
import rasmus.interpreter.sampled.generators.AudioTable;
import rasmus.interpreter.sampled.generators.AudioXAdsr;
import rasmus.interpreter.sampled.generators.AudioXRelease;
import rasmus.interpreter.sampled.io.AudioFile;
import rasmus.interpreter.sampled.io.AudioInput;
import rasmus.interpreter.sampled.io.AudioMonitor;
import rasmus.interpreter.sampled.io.AudioOutput;
import rasmus.interpreter.sampled.math.AudioOperator;
import rasmus.interpreter.sampled.math.AudioOperator2;
import rasmus.interpreter.sampled.midi.AudioMidiTrap;
import rasmus.interpreter.sampled.midi.AudioRegisterInstrument;
import rasmus.interpreter.sampled.midi.AudioRegisterVoice;
import rasmus.interpreter.sampled.midi.AudioRenderControl;
import rasmus.interpreter.sampled.midi.AudioRenderGain;
import rasmus.interpreter.sampled.midi.AudioRenderNotes;
import rasmus.interpreter.sampled.midi.AudioRenderPitch;
import rasmus.interpreter.sampled.midi.AudioRenderPitchBend;
import rasmus.interpreter.sampled.midi.AudioSynthesizer;
import rasmus.interpreter.sampled.midi.AudioVoiceFactory;
import rasmus.interpreter.sampled.modifiers.AudioAGC;
import rasmus.interpreter.sampled.modifiers.AudioBiquad;
import rasmus.interpreter.sampled.modifiers.AudioChannelGain;
import rasmus.interpreter.sampled.modifiers.AudioChannelMixer;
import rasmus.interpreter.sampled.modifiers.AudioChannelMux;
import rasmus.interpreter.sampled.modifiers.AudioDeHiss;
import rasmus.interpreter.sampled.modifiers.AudioDeReverb;
import rasmus.interpreter.sampled.modifiers.AudioDelay;
import rasmus.interpreter.sampled.modifiers.AudioDelay1;
import rasmus.interpreter.sampled.modifiers.AudioDelayLine;
import rasmus.interpreter.sampled.modifiers.AudioDiff;
import rasmus.interpreter.sampled.modifiers.AudioDownMix;
import rasmus.interpreter.sampled.modifiers.AudioEnvelopeFollower;
import rasmus.interpreter.sampled.modifiers.AudioEnvelopeFollower2;
import rasmus.interpreter.sampled.modifiers.AudioFFT;
import rasmus.interpreter.sampled.modifiers.AudioFFTConvolution;
import rasmus.interpreter.sampled.modifiers.AudioFormatMapping;
import rasmus.interpreter.sampled.modifiers.AudioHarmonicsBooster;
import rasmus.interpreter.sampled.modifiers.AudioIFFT;
import rasmus.interpreter.sampled.modifiers.AudioInteg;
import rasmus.interpreter.sampled.modifiers.AudioPitchShift;
import rasmus.interpreter.sampled.modifiers.AudioResample;
import rasmus.interpreter.sampled.modifiers.AudioResampleC;
import rasmus.interpreter.sampled.modifiers.AudioResampleH;
import rasmus.interpreter.sampled.modifiers.AudioResampleI;
import rasmus.interpreter.sampled.modifiers.AudioReverb;
import rasmus.interpreter.sampled.modifiers.AudioTimeStretch;
import rasmus.interpreter.sampled.modifiers.AudioVocoder;
import rasmus.interpreter.unit.UnitInstancePart;

public class AudioModule
extends ModuleFactory {
    public UnitInstancePart newInstance(NameSpace namespace) {
        return new ModuleInstance(namespace);
    }

    class ModuleInstance
    extends Module {
        Interpreter interpreter;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public ModuleInstance(NameSpace namespace) {
            this.setNameSpace(namespace);
            this.add("buzz", new AudioDSF());
            this.add("File", new AudioFile(false));
            this.add("PlayAudio", new AudioPlayer());
            this.add("AudioInput", new AudioInput());
            this.add("AudioOutput", new AudioOutput());
            this.add("AudioMonitor", new AudioMonitor());
            this.add("AudioFile", new AudioFile(false));
            this.add("AudioPlayer", new AudioPlayer());
            this.add("AudioMidiTrap", new AudioMidiTrap());
            this.add("Delay", new AudioDelay());
            this.add("Stretch", new AudioTimeStretch());
            this.add("TimeStretch", new AudioTimeStretch());
            this.add("Sample", new AudioFile(true));
            this.add("Synthesizer", new AudioSynthesizer());
            this.add("Instrument", new AudioRegisterInstrument());
            this.add("Voice", new AudioRegisterVoice());
            this.add("RegisterVoice", new AudioRegisterVoice());
            this.add("AudioVoiceFactory", new AudioVoiceFactory());
            this.add("RenderNotes", new AudioRenderNotes());
            this.add("RenderControl", new AudioRenderControl());
            this.add("RenderPitchBend", new AudioRenderPitchBend());
            this.add("RenderPitch", new AudioRenderPitch());
            this.add("RenderGain", new AudioRenderGain());
            this.add("Biquad", new AudioBiquad());
            this.add("follow", new AudioEnvelopeFollower());
            this.add("follow2", new AudioEnvelopeFollower2());
            this.add("Reverb", new AudioReverb());
            this.add("Delay1", new AudioDelay1());
            this.add("DelayLine", new AudioDelayLine());
            this.add("FFTConvolution", new AudioFFTConvolution());
            this.add("PitchShift", new AudioPitchShift());
            this.add("Vocoder", new AudioVocoder());
            this.add("DeReverb", new AudioDeReverb());
            this.add("DeHiss", new AudioDeHiss());
            this.add("FormatMapper", new AudioFormatMapping());
            this.add("HarmonicsBooster", new AudioHarmonicsBooster());
            this.add("IFFT", new AudioIFFT());
            this.add("FFT", new AudioFFT());
            this.add("Resample", new AudioResample());
            this.add("ResampleI", new AudioResampleI());
            this.add("ResampleC", new AudioResampleC());
            this.add("ResampleH", new AudioResampleH());
            this.add("table", new AudioTable());
            this.add("LinSeg", new AudioLinSeg());
            this.add("Line", new AudioLinSeg());
            this.add("ExpSeg", new AudioExpSeg());
            this.add("Expon", new AudioExpSeg());
            this.add("Adsr", new AudioAdsr());
            this.add("XAdsr", new AudioXAdsr());
            this.add("Release", new AudioRelease());
            this.add("XRelease", new AudioXRelease());
            this.add("Ahdsr", new AudioAhdsr());
            this.add("Envelope", new AudioAdsr());
            this.add("Agc", new AudioAGC());
            this.add("diff", new AudioDiff());
            this.add("integ", new AudioInteg());
            this.add("ChannelGain", new AudioChannelGain());
            this.add("ChannelMux", new AudioChannelMux());
            this.add("ChannelMixer", new AudioChannelMixer());
            this.add("Downmix", new AudioDownMix());
            this.add("Gain", new AudioOperator(0));
            this.add("*", new AudioOperator(0));
            this.add("/", new AudioOperator(1));
            this.add("-", new AudioOperator(2));
            this.add("asum", new AudioOperator(3));
            this.add("%", new AudioOperator(4));
            this.add(">", new AudioOperator(5));
            this.add("<", new AudioOperator(6));
            this.add(">=", new AudioOperator(7));
            this.add("<=", new AudioOperator(8));
            this.add("!=", new AudioOperator(9));
            this.add("=", new AudioOperator(10));
            this.add("?", new AudioOperator2(0));
            this.add("if", new AudioOperator2(0));
            this.add("clip", new AudioOperator2(1));
            this.add("srate", new AudioSampleRate());
            this.add("one", new AudioOne());
            this.add("signal", new AudioSignal());
            this.add("noise", new AudioRandom());
            this.add("clock", new AudioClock());
            this.add("counter", new AudioCounter());
            this.add("abs", new AudioOperator(100));
            this.add("acos", new AudioOperator(101));
            this.add("asin", new AudioOperator(102));
            this.add("atan", new AudioOperator(103));
            this.add("ceil", new AudioOperator(104));
            this.add("fastcos", new AudioOperator(152));
            this.add("cos", new AudioOperator(105));
            this.add("exp", new AudioOperator(106));
            this.add("floor", new AudioOperator(107));
            this.add("log", new AudioOperator(108));
            this.add("rint", new AudioOperator(109));
            this.add("round", new AudioOperator(110));
            this.add("fastsin", new AudioOperator(151));
            this.add("sin", new AudioOperator(111));
            this.add("sqrt", new AudioOperator(112));
            this.add("fasttan", new AudioOperator(153));
            this.add("tan", new AudioOperator(113));
            this.add("toDegrees", new AudioOperator(114));
            this.add("toRadians", new AudioOperator(115));
            this.add("sgn", new AudioOperator(116));
            this.add("IEEEremainder", new AudioOperator(200));
            this.add("atan2", new AudioOperator(201));
            this.add("max", new AudioOperator(202));
            this.add("min", new AudioOperator(203));
            this.add("pow", new AudioOperator(204));
            this.add("^", new AudioOperator(204));
            this.interpreter = new Interpreter(namespace);
            this.interpreter.setAutoCommit(false);
            try {
                this.interpreter.eval("group_audio_dev <- RegisterGroup(\"Input\") <- group_audio_dev_input;");
            }
            catch (ScriptParserException e1) {
                e1.printStackTrace();
            }
            try {
                this.interpreter.eval("group_audio_dev <- RegisterGroup(\"Output\") <- group_audio_dev_output;");
            }
            catch (ScriptParserException e) {
                e.printStackTrace();
            }
            Mixer.Info[] mixers = AudioSystem.getMixerInfo();
            int i = 0;
            while (i < mixers.length) {
                Mixer.Info mixerinfo = mixers[i];
                Mixer audmixer = AudioSystem.getMixer(mixerinfo);
                boolean ok = false;
                boolean ok2 = false;
                Line.Info[] lineinfos = audmixer.getSourceLineInfo();
                int j = 0;
                while (j < lineinfos.length) {
                    if (lineinfos[j] instanceof DataLine.Info && lineinfos[j].getLineClass() == SourceDataLine.class) {
                        ok = true;
                    }
                    ++j;
                }
                lineinfos = audmixer.getTargetLineInfo();
                j = 0;
                while (j < lineinfos.length) {
                    if (lineinfos[j] instanceof DataLine.Info && lineinfos[j].getLineClass() == TargetDataLine.class) {
                        ok2 = true;
                    }
                    ++j;
                }
                if (ok) {
                    try {
                        this.interpreter.eval("group_audio_dev_output <- RegisterConstant(\"" + mixerinfo.getName().replaceAll("\\\"", "\"+'\"'+\"") + "\", \"" + mixerinfo.getDescription() + "\");");
                    }
                    catch (ScriptParserException e) {
                        e.printStackTrace();
                    }
                }
                if (ok2) {
                    try {
                        this.interpreter.eval("group_audio_dev_input  <- RegisterConstant(\"" + mixerinfo.getName().replaceAll("\\\"", "\"+'\"'+\"") + "\", \"" + mixerinfo.getDescription() + "\");");
                    }
                    catch (ScriptParserException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }

        public void close() {
            this.interpreter.close();
            super.close();
        }
    }
}

