/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.AudioVoiceManager;
import rasmus.interpreter.sampled.BeatToTimeMapper;
import rasmus.interpreter.sampled.util.AudioInputStreamConverter;
import rasmus.interpreter.sampled.util.DoubleByteStream;
import rasmus.interpreter.sampled.util.FloatByteStream;
import rasmus.wavefloat.FloatEncoding;

public class AudioSession {
    private double rate;
    private int channels;
    private boolean realtime = false;
    private static AudioCache audiocache = new AudioCache();
    private BeatToTimeMapper bmap = null;
    private AudioSession session = this;
    private AudioSession monosession = null;
    private AudioSession root = this;
    private Hashtable audionstreamablesession = new Hashtable();
    private boolean commitcompleted = false;
    private ArrayList commits = new ArrayList();
    private Commitable initcommit = new Commitable(){

        public int getRunLevel() {
            return 100;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            ArrayList arrayList = AudioSession.this.commits;
            synchronized (arrayList) {
                AudioSession.this.commitcompleted = true;
            }
        }
    };
    AudioVoiceManager voicemanager;
    NameSpace namespace = null;
    Interpreter interpreter = null;

    public NameSpace getNameSpace() {
        if (this.root != this) {
            return this.root.getNameSpace();
        }
        if (this.namespace == null) {
            if (this.interpreter == null) {
                this.interpreter = new Interpreter();
            }
            this.namespace = this.interpreter;
        }
        return this.namespace;
    }

    public void setNameSpace(NameSpace namespace) {
        this.namespace = namespace;
    }

    public AudioVoiceManager getVoiceManager() {
        if (this.voicemanager != null) {
            return this.voicemanager;
        }
        if (this == this.root) {
            return null;
        }
        return this.root.getVoiceManager();
    }

    public void setMaxPolyphony(int maxpoly) {
        this.voicemanager = maxpoly > 0 ? new AudioVoiceManager(maxpoly) : null;
    }

    public int getMaxPolyphony() {
        AudioVoiceManager vm = this.getVoiceManager();
        if (vm == null) {
            return -1;
        }
        return vm.getMaxPolyphony();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Runnable[] commitlist;
        if (this != this.root) {
            this.root.commit();
            return;
        }
        ArrayList arrayList = this.commits;
        synchronized (arrayList) {
            if (!this.commitcompleted) {
                return;
            }
            commitlist = new Runnable[this.commits.size()];
            this.commits.toArray(commitlist);
            this.commits.clear();
            this.commitcompleted = false;
        }
        int i = 0;
        while (i < commitlist.length) {
            commitlist[i].run();
            ++i;
        }
    }

    public int getChannels() {
        return this.channels;
    }

    public double getRate() {
        return this.rate;
    }

    public AudioCache getAudioCache() {
        return audiocache;
    }

    public BeatToTimeMapper getBeatToTimeMap() {
        return this.bmap;
    }

    public void setBeatToTimeMap(BeatToTimeMapper bmap) {
        this.bmap = bmap;
    }

    public boolean isRealTime() {
        return this.realtime;
    }

    public void setRealTime(boolean value) {
        this.realtime = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBatch(Runnable runnable) {
        ArrayList arrayList = this.root.commits;
        synchronized (arrayList) {
            this.root.commits.add(runnable);
            this.getNameSpace().addToCommitStack(this.initcommit);
        }
    }

    public AudioSession(double rate, int channels) {
        this.rate = rate;
        this.channels = channels;
    }

    public AudioSession newSession(double rate, int channels) {
        AudioSession audiosession = new AudioSession(rate, channels);
        audiosession.bmap = this.bmap;
        audiosession.realtime = this.realtime;
        audiosession.root = this.root;
        return audiosession;
    }

    public AudioSession newSession() {
        return this.newSession(this.getRate(), this.getChannels());
    }

    public AudioSession getMonoSession() {
        if (this.monosession != null) {
            return this.monosession;
        }
        this.monosession = this.newSession(this.getRate(), 1);
        return this.monosession;
    }

    public AudioStream openStream(NameSpace namespace) {
        return this.openStream(namespace.get("output"));
    }

    public AudioStream openStream(Variable variable) {
        return AudioEvents.openStream(variable, this);
    }

    public AudioStream openStream(AudioStreamable streamable) {
        AudioStreamableSession streamablesession = (AudioStreamableSession)this.audionstreamablesession.get(streamable);
        if (streamablesession == null) {
            streamablesession = new AudioStreamableSession(streamable);
            this.audionstreamablesession.put(streamable, streamablesession);
        }
        return streamablesession.openStream();
    }

    public double[] asDoubleArray(NameSpace namespace) {
        return this.asDoubleArray(namespace.get("output"));
    }

    public double[] asDoubleArray(Variable variable) {
        AudioStream audiostream = this.openStream(variable);
        double[] ret = this.asDoubleArray(audiostream);
        audiostream.close();
        return ret;
    }

    public double[] asDoubleArray(AudioStreamable streamable) {
        AudioStream audiostream = this.openStream(streamable);
        double[] ret = this.asDoubleArray(audiostream);
        audiostream.close();
        return ret;
    }

    public double[] asDoubleArray(AudioStream stream) {
        int ret;
        ArrayList<double[]> buffers = new ArrayList<double[]>();
        int totalsize = 0;
        do {
            double[] buffer;
            if ((ret = stream.replace(buffer = new double[500], 0, buffer.length)) != -1) {
                totalsize += ret;
            }
            buffers.add(buffer);
        } while (ret != -1);
        double[] retbuffer = new double[totalsize];
        Iterator iterator = buffers.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            double[] buffer = (double[])iterator.next();
            int end = pos + buffer.length;
            if (end > totalsize) {
                end = totalsize;
            }
            int j = 0;
            int i = pos;
            while (i < end) {
                retbuffer[i] = buffer[j];
                ++j;
                ++i;
            }
            pos = end;
        }
        return retbuffer;
    }

    public AudioInputStream asByteStream(AudioStream stream, AudioFormat format) {
        if (!(format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || format.getEncoding().equals(FloatEncoding.PCM_FLOAT))) {
            throw new IllegalArgumentException("Only PCM_SIGNED, PCM_UNSIGNED, PCM_FLOAT encoding supported!");
        }
        if (format.getEncoding().equals(FloatEncoding.PCM_FLOAT)) {
            ByteOrder order = format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            if (format.getSampleSizeInBits() == 64) {
                return new AudioInputStream(new DoubleByteStream(stream, order), format, -1L);
            }
            if (format.getSampleSizeInBits() == 32) {
                return new AudioInputStream(new FloatByteStream(stream, order), format, -1L);
            }
            throw new IllegalArgumentException("Only 32 or 64 bit float supported!");
        }
        int sampleSizeInBits = format.getSampleSizeInBits();
        boolean signed = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean bigEndian = format.isBigEndian();
        return new AudioInputStream(new AudioInputStreamConverter(stream, sampleSizeInBits, signed, bigEndian), format, -1L);
    }

    public AudioInputStream asByteStream(AudioStreamable streamable, AudioFormat format) {
        return this.asByteStream(this.openStream(streamable), format);
    }

    public AudioInputStream asByteStream(Variable variable, AudioFormat format) {
        return this.asByteStream(this.openStream(variable), format);
    }

    public AudioInputStream asByteStream(NameSpace namespace, AudioFormat format) {
        return this.asByteStream(this.openStream(namespace), format);
    }

    public void close() {
        this.monosession = null;
        this.bmap = null;
        this.root = null;
    }

    private class AudioStreamableSession {
        AudioStreamableSession streamablesession = this;
        AudioStream audiostream;
        AudioStreamable streamable;
        LinkedList streamsessions = new LinkedList();
        int frame = -1;
        double[] framebuffer = null;
        double[] staticbuffer = new double[1];
        int framebufferret = 0;
        boolean isstaticbuffer = false;
        boolean isinskipmode = false;
        int fcount = 0;

        boolean readNextBufferStaticValue(int len) {
            ++this.frame;
            this.framebufferret = this.audiostream == null ? -1 : this.audiostream.isStatic(this.staticbuffer, len);
            if (this.framebufferret == -1) {
                --this.frame;
                return false;
            }
            if (this.framebuffer != null) {
                AudioSession.this.getAudioCache().returnBuffer(this.framebuffer);
                this.framebuffer = null;
            }
            this.isstaticbuffer = true;
            this.isinskipmode = false;
            return true;
        }

        void skipNextBuffer(int len) {
            if (this.frame == 1 && this.readNextBufferStaticValue(len)) {
                return;
            }
            this.isstaticbuffer = false;
            this.isinskipmode = true;
            ++this.frame;
            if (this.framebuffer != null) {
                AudioSession.this.getAudioCache().returnBuffer(this.framebuffer);
                this.framebuffer = null;
            }
            this.framebufferret = this.audiostream == null ? -1 : this.audiostream.skip(len);
        }

        void readNextBuffer(int start, int end) {
            if (this.frame == 1 && this.readNextBufferStaticValue(end - start)) {
                return;
            }
            this.isstaticbuffer = false;
            this.isinskipmode = false;
            ++this.frame;
            if (this.framebuffer != null) {
                AudioSession.this.getAudioCache().returnBuffer(this.framebuffer);
                this.framebuffer = null;
            }
            this.framebuffer = AudioSession.this.getAudioCache().getBuffer(end);
            this.framebufferret = this.audiostream == null ? -1 : this.audiostream.replace(this.framebuffer, start, end);
        }

        AudioStreamableSession(AudioStreamable streamable) {
            this.streamable = streamable;
            this.audiostream = streamable.openStream(AudioSession.this.session);
        }

        public AudioStream openStream() {
            if (this.audiostream == null) {
                return null;
            }
            AudioStreamSession streamsession = new AudioStreamSession();
            ++this.fcount;
            this.streamsessions.add(streamsession);
            return streamsession;
        }

        class AudioStreamSession
        implements AudioStream {
            int cframe = -1;

            AudioStreamSession() {
            }

            public int mix(double[] buffer, int start, int end) {
                if (AudioStreamableSession.this.fcount == 1 && AudioStreamableSession.this.frame != -1) {
                    return AudioStreamableSession.this.audiostream.mix(buffer, start, end);
                }
                ++this.cframe;
                if (AudioStreamableSession.this.frame != this.cframe) {
                    AudioStreamableSession.this.readNextBuffer(start, end);
                }
                if (AudioStreamableSession.this.isinskipmode) {
                    System.out.println("Skip error read");
                    return end - start;
                }
                if (AudioStreamableSession.this.framebufferret == -1) {
                    return -1;
                }
                if (AudioStreamableSession.this.isstaticbuffer) {
                    double s = AudioStreamableSession.this.staticbuffer[0];
                    if (s != 0.0) {
                        int i = start;
                        while (i < start + AudioStreamableSession.this.framebufferret) {
                            int n = i++;
                            buffer[n] = buffer[n] + s;
                        }
                    }
                } else {
                    int i = start;
                    while (i < start + AudioStreamableSession.this.framebufferret) {
                        int n = i;
                        buffer[n] = buffer[n] + AudioStreamableSession.this.framebuffer[i];
                        ++i;
                    }
                }
                if (AudioStreamableSession.this.framebufferret > end - start) {
                    System.out.println("read error");
                }
                return AudioStreamableSession.this.framebufferret;
            }

            public int replace(double[] buffer, int start, int end) {
                if (AudioStreamableSession.this.fcount == 1 && AudioStreamableSession.this.frame != -1) {
                    return AudioStreamableSession.this.audiostream.replace(buffer, start, end);
                }
                ++this.cframe;
                if (AudioStreamableSession.this.frame != this.cframe) {
                    AudioStreamableSession.this.readNextBuffer(start, end);
                }
                if (AudioStreamableSession.this.isinskipmode) {
                    System.out.println("Skip error read");
                    Arrays.fill(buffer, start, end, 0.0);
                    return end - start;
                }
                if (AudioStreamableSession.this.framebufferret == -1) {
                    return -1;
                }
                if (AudioStreamableSession.this.isstaticbuffer) {
                    Arrays.fill(buffer, start, start + AudioStreamableSession.this.framebufferret, AudioStreamableSession.this.staticbuffer[0]);
                } else {
                    int i = start;
                    while (i < start + AudioStreamableSession.this.framebufferret) {
                        buffer[i] = AudioStreamableSession.this.framebuffer[i];
                        ++i;
                    }
                }
                if (AudioStreamableSession.this.framebufferret > end - start) {
                    System.out.println("read error");
                    AudioStreamableSession.this.framebufferret = end - start;
                }
                return AudioStreamableSession.this.framebufferret;
            }

            public int skip(int len) {
                if (AudioStreamableSession.this.fcount == 1 && AudioStreamableSession.this.frame != -1) {
                    return AudioStreamableSession.this.audiostream.skip(len);
                }
                ++this.cframe;
                if (AudioStreamableSession.this.frame != this.cframe) {
                    AudioStreamableSession.this.skipNextBuffer(len);
                }
                if (AudioStreamableSession.this.framebufferret == -1) {
                    return -1;
                }
                if (AudioStreamableSession.this.framebufferret > len) {
                    System.out.println("read error");
                    AudioStreamableSession.this.framebufferret = len;
                }
                return AudioStreamableSession.this.framebufferret;
            }

            public int isStatic(double[] buffer, int len) {
                if (AudioStreamableSession.this.fcount == 1 && AudioStreamableSession.this.frame != -1) {
                    return AudioStreamableSession.this.audiostream.isStatic(buffer, len);
                }
                ++this.cframe;
                if (AudioStreamableSession.this.frame != this.cframe && !AudioStreamableSession.this.readNextBufferStaticValue(len)) {
                    --this.cframe;
                    return -1;
                }
                if (!AudioStreamableSession.this.isstaticbuffer) {
                    --this.cframe;
                    return -1;
                }
                buffer[0] = AudioStreamableSession.this.staticbuffer[0];
                return AudioStreamableSession.this.framebufferret;
            }

            public void close() {
                AudioStreamableSession.this.streamsessions.remove(this);
                if (AudioStreamableSession.this.streamsessions.size() == 0) {
                    if (AudioStreamableSession.this.audiostream != null) {
                        AudioStreamableSession.this.audiostream.close();
                    }
                    AudioStreamableSession.this.audiostream = null;
                    AudioSession.this.audionstreamablesession.remove(AudioStreamableSession.this.streamable);
                    AudioStreamableSession.this.streamable = null;
                    if (AudioStreamableSession.this.framebuffer != null) {
                        AudioSession.this.getAudioCache().returnBuffer(AudioStreamableSession.this.framebuffer);
                        AudioStreamableSession.this.framebuffer = null;
                    }
                }
            }
        }
    }
}

