/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioDSFInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();
    Variable value;
    Variable in_F;
    Variable in_A;
    Variable in_N;
    Variable in_FI;

    public void calc() {
    }

    public AudioDSFInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
        this.in_F = parameters.getParameterWithDefault(1, "f");
        this.in_A = parameters.getParameterWithDefault(2, "a");
        this.in_N = parameters.getParameterWithDefault(3, "n");
        this.in_FI = parameters.getParameter(4, "fi");
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioSession session;
        AudioCache audiocache;
        double x_counter = 0.0;
        double[] stockbuffer2 = null;
        double[] stockbuffer3 = null;
        double[] stockbuffer4 = null;
        boolean inputstream2_eof = false;
        AudioFallBackStream inputstream2 = null;
        boolean inputstream3_eof = false;
        AudioFallBackStream inputstream3 = null;
        boolean inputstream4_eof = false;
        AudioFallBackStream inputstream4 = null;

        public FilterStreamInstance(AudioSession session) {
            this.session = session;
            this.audiocache = session.getAudioCache();
            if (AudioEvents.getInstance((Variable)AudioDSFInstance.this.in_F).track.size() == 0) {
                this.inputstream2_eof = true;
            } else {
                this.inputstream2 = new AudioFallBackStream(AudioEvents.openStream(AudioDSFInstance.this.in_F, session.getMonoSession()));
            }
            if (AudioEvents.getInstance((Variable)AudioDSFInstance.this.in_A).track.size() == 0) {
                this.inputstream3_eof = true;
            } else {
                this.inputstream3 = new AudioFallBackStream(AudioEvents.openStream(AudioDSFInstance.this.in_A, session.getMonoSession()));
            }
            if (AudioEvents.getInstance((Variable)AudioDSFInstance.this.in_N).track.size() == 0) {
                this.inputstream4_eof = true;
            } else {
                this.inputstream4 = new AudioFallBackStream(AudioEvents.openStream(AudioDSFInstance.this.in_N, session.getMonoSession()));
            }
        }

        public int mix(double[] buffer, int start, int end) {
            double f = DoublePart.asDouble(AudioDSFInstance.this.in_F);
            double f0 = Math.PI * 2 * f / this.session.getRate();
            double a = DoublePart.asDouble(AudioDSFInstance.this.in_A);
            double N = DoublePart.asDouble(AudioDSFInstance.this.in_N);
            double fi = AudioDSFInstance.this.in_FI == null ? 1.5707963267948966 : DoublePart.asDouble(AudioDSFInstance.this.in_FI);
            if (a > 0.999) {
                a = 0.999;
            }
            boolean variable_data = !this.inputstream2_eof || !this.inputstream3_eof || !this.inputstream4_eof;
            int channels = this.session.getChannels();
            int cstart = start / channels;
            int cend = end / channels;
            if (variable_data) {
                int ret;
                variable_data = false;
                boolean static_2 = false;
                boolean static_3 = false;
                boolean static_4 = false;
                double[] cbuffer = new double[1];
                if (!this.inputstream2_eof) {
                    ret = this.inputstream2.isStatic(cbuffer, cend - cstart);
                    if (ret != -1) {
                        f0 = Math.PI * 2 * cbuffer[0] / this.session.getRate();
                        static_2 = true;
                    } else {
                        variable_data = true;
                    }
                }
                if (!this.inputstream3_eof) {
                    ret = this.inputstream3.isStatic(cbuffer, cend - cstart);
                    if (ret != -1) {
                        a = cbuffer[0];
                        static_2 = true;
                    } else {
                        variable_data = true;
                    }
                }
                if (!this.inputstream4_eof) {
                    ret = this.inputstream4.isStatic(cbuffer, cend - cstart);
                    if (ret != -1) {
                        N = cbuffer[0];
                        static_2 = true;
                    } else {
                        variable_data = true;
                    }
                }
                if (variable_data) {
                    if (static_2) {
                        this.inputstream2.fallBack();
                    }
                    if (static_3) {
                        this.inputstream2.fallBack();
                    }
                    if (static_4) {
                        this.inputstream2.fallBack();
                    }
                }
            }
            if (variable_data) {
                int ret;
                if (!this.inputstream2_eof) {
                    if (this.stockbuffer2 == null) {
                        this.stockbuffer2 = this.audiocache.getBuffer(cend);
                    }
                    if (this.stockbuffer2.length < cend) {
                        this.audiocache.returnBuffer(this.stockbuffer2);
                        this.stockbuffer2 = this.audiocache.getBuffer(cend);
                    }
                    if ((ret = this.inputstream2.replace(this.stockbuffer2, cstart, cend)) == -1) {
                        Arrays.fill(this.stockbuffer2, f0);
                        this.inputstream2_eof = true;
                    } else {
                        double factor = Math.PI * 2 / this.session.getRate();
                        int i = cstart;
                        while (i < cstart + ret) {
                            int n = i++;
                            this.stockbuffer2[n] = this.stockbuffer2[n] * factor;
                        }
                        Arrays.fill(this.stockbuffer2, cstart + ret, cend, f0);
                    }
                } else if (this.stockbuffer2 == null || this.stockbuffer2.length < cend) {
                    if (this.stockbuffer2 != null) {
                        this.audiocache.returnBuffer(this.stockbuffer2);
                    }
                    this.stockbuffer2 = this.audiocache.getBuffer(cend);
                    Arrays.fill(this.stockbuffer2, f0);
                }
                if (!this.inputstream3_eof) {
                    if (this.stockbuffer3 == null) {
                        this.stockbuffer3 = this.audiocache.getBuffer(cend);
                    }
                    if (this.stockbuffer3.length < cend) {
                        this.audiocache.returnBuffer(this.stockbuffer3);
                        this.stockbuffer3 = this.audiocache.getBuffer(cend);
                    }
                    if ((ret = this.inputstream3.replace(this.stockbuffer3, cstart, cend)) == -1) {
                        this.inputstream3_eof = true;
                        Arrays.fill(this.stockbuffer3, a);
                    } else {
                        Arrays.fill(this.stockbuffer3, cstart + ret, cend, a);
                    }
                } else if (this.stockbuffer3 == null || this.stockbuffer3.length < cend) {
                    if (this.stockbuffer3 != null) {
                        this.audiocache.returnBuffer(this.stockbuffer3);
                    }
                    this.stockbuffer3 = this.audiocache.getBuffer(cend);
                    Arrays.fill(this.stockbuffer3, a);
                }
                if (!this.inputstream4_eof) {
                    if (this.stockbuffer4 == null) {
                        this.stockbuffer4 = this.audiocache.getBuffer(cend);
                    }
                    if (this.stockbuffer4.length < cend) {
                        this.audiocache.returnBuffer(this.stockbuffer4);
                        this.stockbuffer4 = this.audiocache.getBuffer(cend);
                    }
                    if ((ret = this.inputstream4.replace(this.stockbuffer4, cstart, cend)) == -1) {
                        Arrays.fill(this.stockbuffer4, N);
                        this.inputstream4_eof = true;
                    } else {
                        Arrays.fill(this.stockbuffer4, cstart + ret, cend, N);
                    }
                } else if (this.stockbuffer4 == null || this.stockbuffer4.length < cend) {
                    if (this.stockbuffer4 != null) {
                        this.audiocache.returnBuffer(this.stockbuffer4);
                    }
                    this.stockbuffer4 = this.audiocache.getBuffer(cend);
                    Arrays.fill(this.stockbuffer4, N);
                }
            }
            double calc_fi = Math.sin(fi);
            double x = 0.0;
            double aa = Math.pow(a, N);
            int c = 0;
            while (c < channels) {
                x = this.x_counter;
                if (variable_data) {
                    int ix = cstart;
                    if (AudioDSFInstance.this.in_FI == null) {
                        int i = start + c;
                        while (i < end) {
                            f0 = this.stockbuffer2[ix];
                            a = this.stockbuffer3[ix];
                            N = this.stockbuffer4[ix];
                            aa = Math.pow(a, N);
                            double cosx = Math.cos(x);
                            double s1 = aa * a * Math.cos((N - 1.0) * x);
                            double s2 = aa * Math.cos(N * x);
                            double s3 = a * cosx;
                            double s4 = 1.0 - 2.0 * a * cosx + a * a;
                            int n = i;
                            buffer[n] = buffer[n] + (s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4);
                            x += f0;
                            ++ix;
                            i += channels;
                        }
                    } else {
                        int i = start + c;
                        while (i < end) {
                            f0 = this.stockbuffer2[ix];
                            a = this.stockbuffer3[ix];
                            N = this.stockbuffer4[ix];
                            double s1 = aa * a * Math.sin((N - 1.0) * x + fi);
                            double s2 = aa * Math.sin(N * x + fi);
                            double s3 = a * Math.sin(x + fi);
                            double s4 = 1.0 - 2.0 * a * Math.cos(x) + a * a;
                            int n = i;
                            buffer[n] = buffer[n] + (s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4);
                            x += f0;
                            ++ix;
                            i += channels;
                        }
                    }
                } else if (AudioDSFInstance.this.in_FI == null) {
                    double s1_m_cos = Math.cos((N - 1.0) * f0);
                    double s1_m_sin = Math.sin((N - 1.0) * f0);
                    double s2_m_cos = Math.cos(N * f0);
                    double s2_m_sin = Math.sin(N * f0);
                    double s3_m_cos = Math.cos(f0);
                    double s3_m_sin = Math.sin(f0);
                    double s1_sin = Math.sin((N - 1.0) * x);
                    double s2_sin = Math.sin(N * x);
                    double s3_sin = Math.sin(x);
                    double s1_cos = Math.cos((N - 1.0) * x);
                    double s2_cos = Math.cos(N * x);
                    double s3_cos = Math.cos(x);
                    int i = start + c;
                    while (i < end) {
                        double s1 = aa * a * s1_cos;
                        double s2 = aa * s2_cos;
                        double s3 = a * s3_cos;
                        double s4 = 1.0 - 2.0 * a * s3_cos + a * a;
                        int n = i;
                        buffer[n] = buffer[n] + (s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4);
                        double ss1_sin = s1_sin;
                        s1_sin = ss1_sin * s1_m_cos + s1_cos * s1_m_sin;
                        s1_cos = s1_cos * s1_m_cos - ss1_sin * s1_m_sin;
                        double ss2_sin = s2_sin;
                        s2_sin = ss2_sin * s2_m_cos + s2_cos * s2_m_sin;
                        s2_cos = s2_cos * s2_m_cos - ss2_sin * s2_m_sin;
                        double ss3_sin = s3_sin;
                        s3_sin = ss3_sin * s3_m_cos + s3_cos * s3_m_sin;
                        s3_cos = s3_cos * s3_m_cos - ss3_sin * s3_m_sin;
                        x += f0;
                        i += channels;
                    }
                } else {
                    int i = start + c;
                    while (i < end) {
                        double s1 = aa * a * Math.sin((N - 1.0) * x + fi);
                        double s2 = aa * Math.sin(N * x + fi);
                        double s3 = a * Math.sin(x + fi);
                        double s4 = 1.0 - 2.0 * a * Math.cos(x) + a * a;
                        int n = i;
                        buffer[n] = buffer[n] + (s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4);
                        x += f0;
                        i += channels;
                    }
                }
                ++c;
            }
            this.x_counter = x % (Math.PI * 2);
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            double f = DoublePart.asDouble(AudioDSFInstance.this.in_F);
            double f0 = Math.PI * 2 * f / this.session.getRate();
            double a = DoublePart.asDouble(AudioDSFInstance.this.in_A);
            double N = DoublePart.asDouble(AudioDSFInstance.this.in_N);
            double fi = AudioDSFInstance.this.in_FI == null ? 1.5707963267948966 : DoublePart.asDouble(AudioDSFInstance.this.in_FI);
            if (a > 0.999) {
                a = 0.999;
            }
            boolean variable_data = !this.inputstream2_eof || !this.inputstream3_eof || !this.inputstream4_eof;
            int channels = this.session.getChannels();
            int cstart = start / channels;
            int cend = end / channels;
            if (variable_data) {
                int ret;
                variable_data = false;
                boolean static_2 = false;
                boolean static_3 = false;
                boolean static_4 = false;
                double[] cbuffer = new double[1];
                if (!this.inputstream2_eof) {
                    ret = this.inputstream2.isStatic(cbuffer, cend - cstart);
                    if (ret != -1) {
                        f0 = Math.PI * 2 * cbuffer[0] / this.session.getRate();
                        static_2 = true;
                    } else {
                        variable_data = true;
                    }
                }
                if (!this.inputstream3_eof) {
                    ret = this.inputstream3.isStatic(cbuffer, cend - cstart);
                    if (ret != -1) {
                        a = cbuffer[0];
                        static_2 = true;
                    } else {
                        variable_data = true;
                    }
                }
                if (!this.inputstream4_eof) {
                    ret = this.inputstream4.isStatic(cbuffer, cend - cstart);
                    if (ret != -1) {
                        N = cbuffer[0];
                        static_2 = true;
                    } else {
                        variable_data = true;
                    }
                }
                if (variable_data) {
                    if (static_2) {
                        this.inputstream2.fallBack();
                    }
                    if (static_3) {
                        this.inputstream2.fallBack();
                    }
                    if (static_4) {
                        this.inputstream2.fallBack();
                    }
                }
            }
            if (variable_data) {
                int ret;
                if (!this.inputstream2_eof) {
                    if (this.stockbuffer2 == null) {
                        this.stockbuffer2 = this.audiocache.getBuffer(cend);
                    }
                    if (this.stockbuffer2.length < cend) {
                        this.audiocache.returnBuffer(this.stockbuffer2);
                        this.stockbuffer2 = this.audiocache.getBuffer(cend);
                    }
                    if ((ret = this.inputstream2.replace(this.stockbuffer2, cstart, cend)) == -1) {
                        Arrays.fill(this.stockbuffer2, f0);
                        this.inputstream2_eof = true;
                    } else {
                        double factor = Math.PI * 2 / this.session.getRate();
                        int i = cstart;
                        while (i < cstart + ret) {
                            int n = i++;
                            this.stockbuffer2[n] = this.stockbuffer2[n] * factor;
                        }
                        Arrays.fill(this.stockbuffer2, cstart + ret, cend, f0);
                    }
                } else if (this.stockbuffer2 == null || this.stockbuffer2.length < cend) {
                    if (this.stockbuffer2 != null) {
                        this.audiocache.returnBuffer(this.stockbuffer2);
                    }
                    this.stockbuffer2 = this.audiocache.getBuffer(cend);
                    Arrays.fill(this.stockbuffer2, f0);
                }
                if (!this.inputstream3_eof) {
                    if (this.stockbuffer3 == null) {
                        this.stockbuffer3 = this.audiocache.getBuffer(cend);
                    }
                    if (this.stockbuffer3.length < cend) {
                        this.audiocache.returnBuffer(this.stockbuffer3);
                        this.stockbuffer3 = this.audiocache.getBuffer(cend);
                    }
                    if ((ret = this.inputstream3.replace(this.stockbuffer3, cstart, cend)) == -1) {
                        this.inputstream3_eof = true;
                        Arrays.fill(this.stockbuffer3, a);
                    } else {
                        Arrays.fill(this.stockbuffer3, cstart + ret, cend, a);
                    }
                } else if (this.stockbuffer3 == null || this.stockbuffer3.length < cend) {
                    if (this.stockbuffer3 != null) {
                        this.audiocache.returnBuffer(this.stockbuffer3);
                    }
                    this.stockbuffer3 = this.audiocache.getBuffer(cend);
                    Arrays.fill(this.stockbuffer3, a);
                }
                if (!this.inputstream4_eof) {
                    if (this.stockbuffer4 == null) {
                        this.stockbuffer4 = this.audiocache.getBuffer(cend);
                    }
                    if (this.stockbuffer4.length < cend) {
                        this.audiocache.returnBuffer(this.stockbuffer4);
                        this.stockbuffer4 = this.audiocache.getBuffer(cend);
                    }
                    if ((ret = this.inputstream4.replace(this.stockbuffer4, cstart, cend)) == -1) {
                        Arrays.fill(this.stockbuffer4, N);
                        this.inputstream4_eof = true;
                    } else {
                        Arrays.fill(this.stockbuffer4, cstart + ret, cend, N);
                    }
                } else if (this.stockbuffer4 == null || this.stockbuffer4.length < cend) {
                    if (this.stockbuffer4 != null) {
                        this.audiocache.returnBuffer(this.stockbuffer4);
                    }
                    this.stockbuffer4 = this.audiocache.getBuffer(cend);
                    Arrays.fill(this.stockbuffer4, N);
                }
            }
            double calc_fi = Math.sin(fi);
            double x = 0.0;
            double aa = Math.pow(a, N);
            int c = 0;
            while (c < channels) {
                x = this.x_counter;
                if (variable_data) {
                    int ix = cstart;
                    if (AudioDSFInstance.this.in_FI == null) {
                        int i = start + c;
                        while (i < end) {
                            f0 = this.stockbuffer2[ix];
                            a = this.stockbuffer3[ix];
                            N = this.stockbuffer4[ix];
                            aa = Math.pow(a, N);
                            double cosx = Math.cos(x);
                            double s1 = aa * a * Math.cos((N - 1.0) * x);
                            double s2 = aa * Math.cos(N * x);
                            double s3 = a * cosx;
                            double s4 = 1.0 - 2.0 * a * cosx + a * a;
                            buffer[i] = s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4;
                            x += f0;
                            ++ix;
                            i += channels;
                        }
                    } else {
                        int i = start + c;
                        while (i < end) {
                            f0 = this.stockbuffer2[ix];
                            a = this.stockbuffer3[ix];
                            N = this.stockbuffer4[ix];
                            double s1 = aa * a * Math.sin((N - 1.0) * x + fi);
                            double s2 = aa * Math.sin(N * x + fi);
                            double s3 = a * Math.sin(x + fi);
                            double s4 = 1.0 - 2.0 * a * Math.cos(x) + a * a;
                            buffer[i] = s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4;
                            x += f0;
                            ++ix;
                            i += channels;
                        }
                    }
                } else if (AudioDSFInstance.this.in_FI == null) {
                    double s1_m_cos = Math.cos((N - 1.0) * f0);
                    double s1_m_sin = Math.sin((N - 1.0) * f0);
                    double s2_m_cos = Math.cos(N * f0);
                    double s2_m_sin = Math.sin(N * f0);
                    double s3_m_cos = Math.cos(f0);
                    double s3_m_sin = Math.sin(f0);
                    double s1_sin = Math.sin((N - 1.0) * x);
                    double s2_sin = Math.sin(N * x);
                    double s3_sin = Math.sin(x);
                    double s1_cos = Math.cos((N - 1.0) * x);
                    double s2_cos = Math.cos(N * x);
                    double s3_cos = Math.cos(x);
                    int i = start + c;
                    while (i < end) {
                        double s1 = aa * a * s1_cos;
                        double s2 = aa * s2_cos;
                        double s3 = a * s3_cos;
                        double s4 = 1.0 - 2.0 * a * s3_cos + a * a;
                        buffer[i] = s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4;
                        double ss1_sin = s1_sin;
                        s1_sin = ss1_sin * s1_m_cos + s1_cos * s1_m_sin;
                        s1_cos = s1_cos * s1_m_cos - ss1_sin * s1_m_sin;
                        double ss2_sin = s2_sin;
                        s2_sin = ss2_sin * s2_m_cos + s2_cos * s2_m_sin;
                        s2_cos = s2_cos * s2_m_cos - ss2_sin * s2_m_sin;
                        double ss3_sin = s3_sin;
                        s3_sin = ss3_sin * s3_m_cos + s3_cos * s3_m_sin;
                        s3_cos = s3_cos * s3_m_cos - ss3_sin * s3_m_sin;
                        x += f0;
                        i += channels;
                    }
                } else {
                    int i = start + c;
                    while (i < end) {
                        double s1 = aa * a * Math.sin((N - 1.0) * x + fi);
                        double s2 = aa * Math.sin(N * x + fi);
                        double s3 = a * Math.sin(x + fi);
                        double s4 = 1.0 - 2.0 * a * Math.cos(x) + a * a;
                        buffer[i] = s4 == 0.0 ? 0.0 : (calc_fi - s3 - s2 + s1) / s4;
                        x += f0;
                        i += channels;
                    }
                }
                ++c;
            }
            this.x_counter = x % (Math.PI * 2);
            return end - start;
        }

        public int skip(int len) {
            return len;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            if (this.inputstream2 != null) {
                this.inputstream2.close();
            }
            if (this.inputstream3 != null) {
                this.inputstream3.close();
            }
            if (this.inputstream4 != null) {
                this.inputstream4.close();
            }
            if (this.stockbuffer2 != null) {
                this.audiocache.returnBuffer(this.stockbuffer2);
                this.stockbuffer2 = null;
            }
            if (this.stockbuffer3 != null) {
                this.audiocache.returnBuffer(this.stockbuffer3);
                this.stockbuffer3 = null;
            }
            if (this.stockbuffer4 != null) {
                this.audiocache.returnBuffer(this.stockbuffer4);
                this.stockbuffer4 = null;
            }
        }
    }
}

