/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class AudioReleaseInstance
implements AudioStreamable,
UnitInstancePart {
    public Variable output;
    Variable answer = new Variable();
    Variable active;
    Variable release;

    public AudioReleaseInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.active = parameters.getParameterWithDefault(1, "gate");
        this.release = parameters.getParameterWithDefault(2, "release");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioStream inputstream;
        double l_release_step;
        double f_value = 1.0;
        int channels;
        double rate;
        int mode = 2;
        AudioStream activestream = null;
        boolean activestream_eof = false;
        AudioCache audiocache;
        double[] sbuff = new double[1];
        int fallback = -1;

        public FilterStreamInstance(AudioSession session) {
            this.activestream = AudioEvents.openStream(AudioReleaseInstance.this.active, session.getMonoSession());
            this.audiocache = session.getAudioCache();
            long l_release = (long)(DoublePart.asDouble(AudioReleaseInstance.this.release) * this.rate);
            this.l_release_step = l_release == 0L ? 1.0 : 1.0 / (double)l_release;
            this.channels = session.getChannels();
            this.rate = session.getRate();
        }

        public int isStatic(double[] buffer, int len) {
            if (this.mode == 2) {
                int a = this.readActiveStream(len);
                if (a == len) {
                    buffer[0] = 1.0;
                    return len;
                }
                this.fallback = a;
            }
            return -1;
        }

        public int readActiveStream(int len) {
            if (this.fallback != -1) {
                int r = this.fallback;
                this.fallback = -1;
                return r;
            }
            return this.readActiveStream2(len);
        }

        public int readActiveStream2(int len) {
            if (this.activestream_eof) {
                return 0;
            }
            int clen = len / this.channels;
            int ret = this.activestream.isStatic(this.sbuff, clen);
            if (ret != -1) {
                if (this.sbuff[0] < 0.5) {
                    this.activestream_eof = true;
                    return 0;
                }
                if (ret != clen) {
                    this.activestream_eof = true;
                }
                return ret * this.channels;
            }
            double[] cbuffer = this.audiocache.getBuffer(clen);
            ret = this.activestream.replace(cbuffer, 0, clen);
            if (ret == -1) {
                this.audiocache.returnBuffer(cbuffer);
                this.activestream_eof = true;
                return 0;
            }
            int i = 0;
            while (i < clen) {
                if (cbuffer[i] < 0.5) {
                    this.audiocache.returnBuffer(cbuffer);
                    this.activestream_eof = true;
                    return i * this.channels;
                }
                ++i;
            }
            this.audiocache.returnBuffer(cbuffer);
            if (ret != clen) {
                this.activestream_eof = true;
            }
            return ret * this.channels;
        }

        public int mix(double[] buffer, int start, int end) {
            int activelen = this.readActiveStream(end - start);
            if (activelen == 0) {
                return this.mix(buffer, start, end, false);
            }
            if (activelen == end - start) {
                return this.mix(buffer, start, end, true);
            }
            int bend = start + activelen;
            int ret = this.mix(buffer, start, bend, true);
            if (ret < bend - start) {
                return ret;
            }
            int ret2 = this.mix(buffer, bend, end, false);
            if (ret == -1) {
                return ret;
            }
            return ret + ret2;
        }

        public int replace(double[] buffer, int start, int end) {
            int activelen = this.readActiveStream(end - start);
            if (activelen == 0) {
                return this.replace(buffer, start, end, false);
            }
            if (activelen == end - start) {
                return this.replace(buffer, start, end, true);
            }
            int bend = start + activelen;
            int ret = this.replace(buffer, start, bend, true);
            if (ret < bend - start) {
                return ret;
            }
            int ret2 = this.replace(buffer, bend, end, false);
            if (ret == -1) {
                return ret;
            }
            return ret + ret2;
        }

        public int skip(int len) {
            int activelen = this.readActiveStream(len);
            if (activelen == 0) {
                return this.skip(len, false);
            }
            if (activelen == len) {
                return this.skip(len, true);
            }
            int bend = activelen;
            int ret = this.skip(bend, true);
            if (ret < bend) {
                return ret;
            }
            int ret2 = this.skip(len - bend, false);
            if (ret == -1) {
                return ret;
            }
            return ret + ret2;
        }

        /*
         * Unable to fully structure code
         */
        public int mix(double[] buffer, int start, int end, boolean active) {
            block7: {
                if (this.mode == 0 && !active) {
                    this.mode = 5;
                }
                if (this.mode == 5) {
                    return -1;
                }
                ff_value = this.f_value;
                fchannels = this.channels;
                ix = start;
                if (this.mode != 2) break block7;
                if (active) ** GOTO lbl18
                this.mode = 4;
                break block7;
lbl-1000:
                // 1 sources

                {
                    c = 0;
                    while (c < fchannels) {
                        v0 = ix++;
                        buffer[v0] = buffer[v0] + 1.0;
                        ++c;
                    }
lbl18:
                    // 2 sources

                    ** while (ix < end)
                }
            }
            while (ix < end) {
                if ((ff_value -= this.l_release_step) <= 0.0) {
                    ff_value = 0.0;
                    this.mode = 5;
                    break;
                }
                c = 0;
                while (c < fchannels) {
                    v1 = ix++;
                    buffer[v1] = buffer[v1] + ff_value;
                    ++c;
                }
            }
            this.f_value = ff_value;
            return end - start;
        }

        public int replace(double[] buffer, int start, int end, boolean active) {
            if (this.mode == 0 && !active) {
                this.mode = 5;
            }
            if (this.mode == 5) {
                return -1;
            }
            double ff_value = this.f_value;
            int fchannels = this.channels;
            int ix = start;
            if (this.mode == 2) {
                if (!active) {
                    this.mode = 4;
                } else {
                    Arrays.fill(buffer, ix, end, 1.0);
                    ix = end;
                }
            }
            while (ix < end) {
                if ((ff_value -= this.l_release_step) <= 0.0) {
                    ff_value = 0.0;
                    this.mode = 5;
                    break;
                }
                int c = 0;
                while (c < fchannels) {
                    buffer[ix] = ff_value;
                    ++ix;
                    ++c;
                }
            }
            Arrays.fill(buffer, ix, end, 0.0);
            this.f_value = ff_value;
            return end - start;
        }

        public int skip(int len, boolean active) {
            if (this.mode == 0 && !active) {
                this.mode = 5;
            }
            if (this.mode == 5) {
                return -1;
            }
            double ff_value = this.f_value;
            int fchannels = this.channels;
            int ix = 0;
            if (this.mode == 2) {
                if (!active) {
                    this.mode = 4;
                } else {
                    ix = len;
                }
            }
            if (ix < len && (ff_value -= this.l_release_step * (double)(len - ix) / (double)fchannels) <= 0.0) {
                this.mode = 5;
                ff_value = 0.0;
            }
            this.f_value = ff_value;
            return len;
        }

        public void close() {
            this.activestream.close();
        }
    }
}

