/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.generators.AudioTableUnitInstance;
import rasmus.interpreter.sampled.generators.TableData;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstanceAdapter;
import rasmus.interpreter.unit.UnitInstancePart;

class AudioTableInstance
extends UnitInstanceAdapter
implements UnitFactory,
Commitable {
    public Variable output;
    Variable answer = new Variable();
    Variable input;
    Variable from;
    Variable to;
    Variable rate;
    Variable channels;
    TableData tabledata = null;
    NameSpace namespace;

    public TableData getTableData() {
        if (this.tabledata == null) {
            this.tabledata = new TableData(this);
        }
        return this.tabledata;
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public AudioTableInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.from = parameters.getParameterWithDefault(1, "from");
        this.to = parameters.getParameterWithDefault(2, "to");
        this.rate = parameters.getParameterWithDefault(3, "rate");
        this.channels = parameters.getParameterWithDefault(4, "channels");
        AudioEvents.getInstance(this.input).addListener(this);
        DoublePart.getInstance(this.from).addListener(this);
        DoublePart.getInstance(this.to).addListener(this);
        DoublePart.getInstance(this.rate).addListener(this);
        DoublePart.getInstance(this.channels).addListener(this);
        this.answer = Unit.asVariable(this);
        this.output.add(this.answer);
    }

    public void close() {
        AudioEvents.getInstance(this.input).removeListener(this);
        DoublePart.getInstance(this.from).removeListener(this);
        DoublePart.getInstance(this.to).removeListener(this);
        DoublePart.getInstance(this.rate).removeListener(this);
        DoublePart.getInstance(this.channels).removeListener(this);
        this.output.remove(this.answer);
    }

    public UnitInstancePart newInstance(Parameters parameters) {
        return new AudioTableUnitInstance(this, parameters);
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        this.tabledata = null;
    }
}

