/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.generators;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.generators.AudioTableInstance;
import rasmus.interpreter.sampled.generators.TableData;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioTableUnitInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable answer = new Variable();
    Variable input;
    AudioTableInstance ati;

    public void calc() {
    }

    public AudioTableUnitInstance(AudioTableInstance ati, Parameters parameters) {
        this.ati = ati;
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioCache audiocache;
        TableData tabledata;
        int channels;
        AudioStream inputstream = null;
        boolean inputstream_eof = false;
        int staticfallback = -1;
        double staticfallbackvalue = 0.0;

        public FilterStreamInstance(AudioSession session) {
            this.channels = session.getChannels();
            this.audiocache = session.getAudioCache();
            this.tabledata = AudioTableUnitInstance.this.ati.getTableData();
            if (AudioEvents.getInstance((Variable)AudioTableUnitInstance.this.input).track.size() == 0) {
                this.inputstream_eof = true;
            } else {
                this.inputstream = AudioEvents.openStream(AudioTableUnitInstance.this.input, session.getMonoSession());
            }
        }

        public int isStatic(double[] buffer, int len) {
            if (this.staticfallback != -1) {
                return -1;
            }
            if (this.inputstream_eof) {
                return -1;
            }
            double[] table = this.tabledata.table;
            int tchannels = this.tabledata.channels;
            double trate = this.tabledata.rate;
            int tablelenc = this.tabledata.table_length / tchannels;
            double[] freqbuffer = new double[1];
            int clen = len / this.channels;
            int ret = this.inputstream.isStatic(freqbuffer, clen);
            if (ret == -1) {
                this.audiocache.returnBuffer(freqbuffer);
                return -1;
            }
            int ti = (int)(freqbuffer[0] * trate) % tablelenc;
            if (ti < 0) {
                ti += tablelenc;
            }
            buffer[0] = table[ti * tchannels];
            int c = 0;
            while (c < this.channels) {
                int rc;
                if ((rc = c++) >= tchannels) {
                    return ret;
                }
                if (buffer[0] == table[ti * tchannels + rc]) continue;
                this.staticfallback = ret;
                this.staticfallbackvalue = freqbuffer[0];
                this.audiocache.returnBuffer(freqbuffer);
                return -1;
            }
            this.audiocache.returnBuffer(freqbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret;
            if (this.inputstream_eof) {
                return -1;
            }
            if (this.staticfallback != -1) {
                ret = this.staticfallback;
                this.staticfallback = -1;
            } else {
                ret = this.inputstream.skip(len);
            }
            if (ret == -1) {
                this.inputstream_eof = true;
                return -1;
            }
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            int ret;
            if (this.inputstream_eof) {
                return -1;
            }
            double[] table = this.tabledata.table;
            int tchannels = this.tabledata.channels;
            double trate = this.tabledata.rate;
            int tablelenc = this.tabledata.table_length / tchannels;
            int cend = end / this.channels;
            int cstart = start / this.channels;
            double[] freqbuffer = this.audiocache.getBuffer(cend);
            if (this.staticfallback != -1) {
                ret = this.staticfallback;
                Arrays.fill(freqbuffer, cstart, cend, this.staticfallbackvalue);
                this.staticfallback = -1;
            } else {
                ret = this.inputstream.replace(freqbuffer, cstart, cend);
            }
            if (ret == -1) {
                this.audiocache.returnBuffer(freqbuffer);
                this.inputstream_eof = true;
                return -1;
            }
            int chs = this.channels;
            int cendret = cstart + ret;
            int c = 0;
            while (c < chs) {
                int rc = c;
                if (rc >= tchannels) {
                    rc = tchannels - 1;
                }
                int ix = start + c;
                int i = cstart;
                while (i < cendret) {
                    double loc = freqbuffer[i] * trate;
                    long iloc = (long)loc;
                    int ti = (int)(iloc % (long)tablelenc);
                    double interp = loc - (double)iloc;
                    if (ti < 0) {
                        ti += tablelenc;
                    }
                    int n = ix;
                    buffer[n] = buffer[n] + (table[ti * tchannels + rc] * (1.0 - interp) + table[(ti + 1) * tchannels + rc] * interp);
                    ix += chs;
                    ++i;
                }
                ++c;
            }
            this.audiocache.returnBuffer(freqbuffer);
            return ret * this.channels;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret;
            if (this.inputstream_eof) {
                return -1;
            }
            double[] table = this.tabledata.table;
            int tchannels = this.tabledata.channels;
            double trate = this.tabledata.rate;
            int tablelenc = this.tabledata.table_length / tchannels;
            int cend = end / this.channels;
            int cstart = start / this.channels;
            double[] freqbuffer = this.audiocache.getBuffer(cend);
            if (this.staticfallback != -1) {
                ret = this.staticfallback;
                Arrays.fill(freqbuffer, cstart, cend, this.staticfallbackvalue);
                this.staticfallback = -1;
            } else {
                ret = this.inputstream.replace(freqbuffer, cstart, cend);
            }
            if (ret == -1) {
                this.inputstream_eof = true;
                this.audiocache.returnBuffer(freqbuffer);
                return -1;
            }
            int chs = this.channels;
            int cendret = cstart + ret;
            int c = 0;
            while (c < chs) {
                int rc = c;
                if (rc >= tchannels) {
                    rc = tchannels - 1;
                }
                int ix = start + c;
                int i = cstart;
                while (i < cendret) {
                    double loc = freqbuffer[i] * trate;
                    long iloc = (long)loc;
                    int ti = (int)(iloc % (long)tablelenc);
                    double interp = loc - (double)iloc;
                    if (ti < 0) {
                        ti += tablelenc;
                    }
                    buffer[ix] = table[ti * tchannels + rc] * (1.0 - interp) + table[(ti + 1) * tchannels + rc] * interp;
                    ix += chs;
                    ++i;
                }
                ++c;
            }
            this.audiocache.returnBuffer(freqbuffer);
            return ret * this.channels;
        }

        public void close() {
            if (this.inputstream != null) {
                this.inputstream.close();
                this.inputstream = null;
            }
        }
    }
}

