/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.io;

import java.util.Arrays;
import java.util.Hashtable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioInputInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    Variable devname;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioInputInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.devname = parameters.getParameterWithDefault(1, "devname");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioCache audiocache;
        AudioSession session;
        TargetDataLine targatDataLine;
        Mixer input_mixer;
        byte[] byte_buffer;
        int preread;
        int overread;
        int buffersize;
        int readbuffersize = 3200;
        byte[] circbuffer;
        int recordpos = 0;
        int readpos = 0;
        boolean session_realtime;
        int readdiff = 0;
        boolean readstarted = false;
        static /* synthetic */ Class class$0;

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.session = session;
            this.session_realtime = session.isRealTime();
            this.byte_buffer = new byte[2 * session.getChannels() * (int)session.getRate()];
            this.circbuffer = new byte[8 * session.getChannels() * (int)session.getRate()];
            this.buffersize = 2 * session.getChannels() * (int)(session.getRate() * 0.1);
            this.preread = 2 * session.getChannels() * (int)(session.getRate() * 0.01);
            this.overread = 2 * session.getChannels() * (int)(session.getRate() * 0.1);
            try {
                String audioinputname = ObjectsPart.toString(AudioInputInstance.this.devname);
                if (audioinputname != null && audioinputname.trim().length() == 0) {
                    audioinputname = null;
                }
                AudioFormat format = new AudioFormat((float)session.getRate(), 16, session.getChannels(), true, false);
                DataLine.Info input_dataLineInfo = new DataLine.Info(TargetDataLine.class, format);
                Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                Hashtable<String, Mixer> capture_mixerinfotable = new Hashtable<String, Mixer>();
                int i = 0;
                while (i < mixers.length) {
                    Mixer.Info mixerinfo = mixers[i];
                    Mixer audmixer = AudioSystem.getMixer(mixerinfo);
                    boolean okrecord = false;
                    Line.Info[] lineinfos = audmixer.getTargetLineInfo();
                    int j = 0;
                    while (j < lineinfos.length) {
                        if (lineinfos[j] instanceof DataLine.Info && lineinfos[j].getLineClass() == TargetDataLine.class) {
                            okrecord = true;
                        }
                        ++j;
                    }
                    if (okrecord) {
                        capture_mixerinfotable.put(mixerinfo.getName(), audmixer);
                    }
                    ++i;
                }
                if (audioinputname == null) {
                    this.targatDataLine = (TargetDataLine)AudioSystem.getLine(input_dataLineInfo);
                } else {
                    this.input_mixer = (Mixer)capture_mixerinfotable.get(audioinputname);
                    if (this.input_mixer == null) {
                        return;
                    }
                    this.input_mixer.open();
                    this.targatDataLine = (TargetDataLine)this.input_mixer.getLine(input_dataLineInfo);
                }
                this.targatDataLine.open(format, this.readbuffersize);
                this.targatDataLine.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int mix(double[] buffer, int start, int end) {
            int buffersize = (end - start) * 2;
            if (this.byte_buffer.length < buffersize) {
                this.byte_buffer = new byte[buffersize];
            }
            int aval = this.targatDataLine.available();
            if (!this.readstarted) {
                if (buffersize + this.preread < aval) {
                    this.readstarted = true;
                }
            } else if (buffersize > aval) {
                this.readstarted = false;
            }
            if (!this.session_realtime) {
                this.readstarted = true;
            }
            if (this.readstarted) {
                if (aval == this.readbuffersize && aval - (buffersize + this.preread) > 0) {
                    this.targatDataLine.read(this.byte_buffer, 0, aval - (buffersize + this.preread));
                }
                this.targatDataLine.read(this.byte_buffer, 0, buffersize);
                int z = 0;
                int k = start;
                while (k < end) {
                    int n = k++;
                    buffer[n] = buffer[n] + (double)((float)((short)((this.byte_buffer[z + 1] << 8) + (this.byte_buffer[z] & 0xFF))) / 32768.0f);
                    z += 2;
                }
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int skip(int len) {
            double[] buffer = this.audiocache.getBuffer(len);
            int ret = this.replace(new double[len], 0, len);
            this.audiocache.returnBuffer(buffer);
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            if (this.targatDataLine != null) {
                this.targatDataLine.close();
            }
            if (this.input_mixer != null) {
                this.input_mixer.close();
            }
        }
    }
}

