/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.io;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.AudioStreamConverter;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioMonitorInstance
extends UnitInstanceAdapter {
    public Variable outputvar_anwer;
    public Variable monitorvar_anwer;
    public Variable outputvar;
    public Variable inputvar;
    public Variable monitorvar;
    AudioMonitorStreamInstance amsi = null;

    public AudioMonitorInstance(Parameters parameters) {
        this.outputvar = parameters.getParameterWithDefault("output");
        this.inputvar = parameters.getParameterWithDefault("input");
        this.monitorvar = parameters.getParameterWithDefault(1, "monitor");
        this.outputvar_anwer = AudioEvents.asVariable(new AudioEvent(0.0, new AudioMonitorStreamable_output()));
        this.outputvar.add(this.outputvar_anwer);
        this.monitorvar_anwer = AudioEvents.asVariable(new AudioEvent(0.0, new AudioMonitorStreamable_monitor()));
        this.monitorvar.add(this.monitorvar_anwer);
    }

    public void close() {
        if (this.outputvar_anwer != null) {
            this.outputvar.remove(this.outputvar_anwer);
            this.outputvar_anwer = null;
        }
        if (this.monitorvar_anwer != null) {
            this.monitorvar.remove(this.monitorvar_anwer);
            this.monitorvar_anwer = null;
        }
    }

    public void calc() {
    }

    class AudioMonitorStreamInstance
    implements AudioStream {
        AudioStream peerstream;
        AudioCache audiocache;
        AudioSession session;
        final double[] monitorbuffer = new double[32000];
        int bufferpos = 0;
        long monitorreadpos = 0L;

        public AudioMonitorStreamInstance(AudioSession session) {
            this.peerstream = session.openStream(AudioMonitorInstance.this.inputvar);
            this.audiocache = session.getAudioCache();
            this.session = session;
        }

        public int mix(double[] buffer, int start, int end) {
            double[] readbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(readbuffer, start, end);
            if (ret == -1) {
                this.audiocache.returnBuffer(readbuffer);
                return -1;
            }
            end = start + ret;
            int i = start;
            while (i < end) {
                int n = i;
                buffer[n] = buffer[n] + readbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(readbuffer);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret = this.peerstream.replace(buffer, start, end);
            if (ret == -1) {
                return -1;
            }
            end = start + ret;
            this.monitorreadpos += (long)ret;
            int monitorbuffer_len = this.monitorbuffer.length;
            int i = start;
            while (i < end) {
                double data;
                this.monitorbuffer[this.bufferpos] = data = buffer[i];
                this.bufferpos = (this.bufferpos + 1) % monitorbuffer_len;
                ++i;
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public int skip(int len) {
            return this.peerstream.skip(len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            AudioMonitorInstance audioMonitorInstance = AudioMonitorInstance.this;
            synchronized (audioMonitorInstance) {
                AudioMonitorInstance.this.amsi = null;
                this.peerstream.close();
            }
        }
    }

    class AudioMonitorStreamable_output
    implements AudioStreamable {
        AudioMonitorStreamable_output() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioStream openStream(AudioSession session) {
            AudioMonitorInstance audioMonitorInstance = AudioMonitorInstance.this;
            synchronized (audioMonitorInstance) {
                if (AudioMonitorInstance.this.amsi != null) {
                    return session.openStream(AudioMonitorInstance.this.inputvar);
                }
                AudioMonitorInstance.this.amsi = new AudioMonitorStreamInstance(session);
                return AudioMonitorInstance.this.amsi;
            }
        }
    }

    class AudioMonitorStream_MonitorInstance
    implements AudioStream {
        AudioMonitorStreamInstance amsi = null;
        boolean session_realtime;
        int bufferpos = 0;
        long monitorreadpos = 0L;
        AudioSession session;
        AudioStreamConverter asc = null;

        public AudioMonitorStream_MonitorInstance(AudioSession session) {
            this.session_realtime = session.isRealTime();
            this.session = session;
        }

        public AudioMonitorStreamInstance getAMSI() {
            AudioMonitorStreamInstance current_amsi = AudioMonitorInstance.this.amsi;
            if (current_amsi == null) {
                return null;
            }
            if (current_amsi != this.amsi) {
                this.amsi = current_amsi;
                this.bufferpos = this.amsi.bufferpos;
                this.monitorreadpos = this.amsi.monitorreadpos;
            }
            return this.amsi;
        }

        public int mix(double[] buffer, int start, int end) {
            int len = end - start;
            boolean ok = true;
            while (ok) {
                ok = false;
                AudioMonitorStreamInstance amsi = this.getAMSI();
                if (amsi == null) {
                    if (!this.session_realtime) {
                        double slen = (double)len / ((double)this.session.getChannels() * this.session.getRate());
                        try {
                            Thread.sleep((int)(slen * 1000.0));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return 0;
                        }
                    }
                    return len;
                }
                if (this.session.getChannels() != amsi.session.getChannels() || this.session.getRate() != amsi.session.getRate()) {
                    if (this.asc == null) {
                        this.asc = new AudioStreamConverter(this.session);
                    }
                    this.asc.setSource(amsi.session, this);
                    AudioSession baksession = this.session;
                    this.session = this.asc.getSession();
                    int ret = this.asc.mix(buffer, start, end);
                    this.session = baksession;
                    return ret;
                }
                int curbufferpos = amsi.bufferpos;
                long curmonitorreadpos = amsi.monitorreadpos;
                int avail = (int)(curmonitorreadpos - this.monitorreadpos);
                double[] monitorbuffer = amsi.monitorbuffer;
                int monitorbuffer_len = monitorbuffer.length;
                if (avail > monitorbuffer_len) {
                    this.monitorreadpos = curmonitorreadpos - (long)len;
                    this.bufferpos = (curbufferpos - len + monitorbuffer_len) % monitorbuffer_len;
                    avail = len;
                }
                if (avail < len) {
                    if (!this.session_realtime) {
                        double slen = (double)(len - avail) / ((double)this.session.getChannels() * this.session.getRate());
                        try {
                            Thread.sleep((int)(slen * 1000.0));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return 0;
                        }
                        ok = true;
                        continue;
                    }
                } else {
                    avail = len;
                }
                int r_bufferpos = this.bufferpos;
                int s_pos = start;
                int i = 0;
                while (i < avail) {
                    int n = s_pos++;
                    buffer[n] = buffer[n] + monitorbuffer[r_bufferpos];
                    r_bufferpos = (r_bufferpos + 1) % monitorbuffer_len;
                    ++i;
                }
                this.monitorreadpos += (long)avail;
                this.bufferpos = r_bufferpos;
            }
            return len;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public int skip(int len) {
            return this.mix(new double[len], 0, len);
        }

        public void close() {
        }
    }

    class AudioMonitorStreamable_monitor
    implements AudioStreamable {
        AudioMonitorStreamable_monitor() {
        }

        public AudioStream openStream(AudioSession session) {
            return new AudioMonitorStream_MonitorInstance(session);
        }
    }
}

