/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.io;

import java.io.InputStream;
import java.util.Hashtable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class AudioOutputInstance
implements UnitInstancePart,
Commitable {
    WaveFeeder wf = null;
    Variable input;
    Variable devname;
    Variable maxpolyphony;
    Variable bits;
    Variable rate;
    Variable channels;
    Variable priority;
    Variable bufferlen;
    Variable blocking;
    private NameSpace namespace;

    public AudioFormat getOutputFormat() {
        double samplerate = 44100.0;
        if (this.rate != null) {
            samplerate = DoublePart.asDouble(this.rate);
        }
        if (samplerate < 1.0) {
            samplerate = 44100.0;
        }
        int nrofchannels = 2;
        if (this.channels != null) {
            nrofchannels = (int)DoublePart.asDouble(this.channels);
        }
        if (nrofchannels == 0) {
            nrofchannels = 2;
        }
        int i_bits = 16;
        if (this.bits != null) {
            i_bits = (int)DoublePart.asDouble(this.bits);
        }
        return new AudioFormat((float)samplerate, i_bits, nrofchannels, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AudioOutputInstance audioOutputInstance = this;
        synchronized (audioOutputInstance) {
            if (this.wf != null) {
                this.stop();
            }
            this.wf = new WaveFeeder(this.input);
            this.wf.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AudioOutputInstance audioOutputInstance = this;
        synchronized (audioOutputInstance) {
            if (this.wf != null) {
                this.wf.wisplaying = false;
                try {
                    this.wf.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.wf = null;
            }
        }
    }

    public AudioOutputInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.input = parameters.getParameterWithDefault("input");
        this.devname = parameters.getParameterWithDefault(1, "devname");
        this.rate = parameters.getParameter(2, "rate");
        this.channels = parameters.getParameter(3, "channels");
        this.bits = parameters.getParameter(4, "bits");
        this.priority = parameters.getParameter(5, "priority");
        this.bufferlen = parameters.getParameter(6, "bufferlen");
        this.blocking = parameters.getParameter(7, "blocking");
        this.maxpolyphony = parameters.getParameter(8, "maxpolyphony");
        this.namespace.addToCommitStack(this);
    }

    public void close() {
        this.namespace.addToCommitStack(new Commitable(){

            public int getRunLevel() {
                return 100;
            }

            public void commit() {
                AudioOutputInstance.this.stop();
            }
        });
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        this.start();
    }

    class WaveFeeder
    extends Thread {
        InputStream audiostream = null;
        Mixer mixer = null;
        SourceDataLine sourceDataLine = null;
        volatile boolean wisplaying = false;
        boolean useblocking = true;
        double samplerate = 44100.0;
        int channels = 2;
        int bits = 16;
        int framesize = 4;
        int buffersize;
        int buffersize_small;
        AudioSession audiosession = null;
        static /* synthetic */ Class class$0;

        public WaveFeeder(Variable output) {
            if (AudioOutputInstance.this.priority != null) {
                double pri = DoublePart.asDouble(AudioOutputInstance.this.priority);
                if (pri > 0.5) {
                    this.setPriority(10);
                } else if (pri < -0.5) {
                    this.setPriority(1);
                }
            } else {
                this.setPriority(10);
            }
            if (AudioOutputInstance.this.blocking != null) {
                this.useblocking = DoublePart.asDouble(AudioOutputInstance.this.blocking) > 0.5;
            }
            AudioFormat format = AudioOutputInstance.this.getOutputFormat();
            this.samplerate = format.getSampleRate();
            this.channels = format.getChannels();
            this.bits = format.getSampleSizeInBits();
            this.framesize = this.channels * (this.bits / 8);
            double s_buflen = AudioOutputInstance.this.bufferlen == null ? 0.1 : DoublePart.asDouble(AudioOutputInstance.this.bufferlen);
            this.buffersize = this.framesize * (int)(this.samplerate * s_buflen);
            this.buffersize_small = 500 * this.framesize;
            this.buffersize_small -= this.buffersize_small % this.framesize;
            try {
                String audiooutputname = ObjectsPart.toString(AudioOutputInstance.this.devname);
                if (audiooutputname != null && audiooutputname.trim().length() == 0) {
                    audiooutputname = null;
                }
                DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, format, (int)format.getSampleRate());
                Hashtable<String, Mixer> mixerinfotable = new Hashtable<String, Mixer>();
                if (audiooutputname != null) {
                    Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                    int i = 0;
                    while (i < mixers.length) {
                        Mixer.Info mixerinfo = mixers[i];
                        Mixer audmixer = AudioSystem.getMixer(mixerinfo);
                        if (audmixer.isLineSupported(dataLineInfo)) {
                            boolean ok = false;
                            Line.Info[] lineinfos = audmixer.getSourceLineInfo();
                            int j = 0;
                            while (j < lineinfos.length) {
                                if (lineinfos[j] instanceof DataLine.Info && lineinfos[j].getLineClass() == SourceDataLine.class) {
                                    ok = true;
                                }
                                ++j;
                            }
                            if (ok) {
                                mixerinfotable.put(mixerinfo.getName(), audmixer);
                            }
                        }
                        ++i;
                    }
                }
                this.audiosession = new AudioSession(format.getSampleRate(), format.getChannels());
                this.audiosession.setRealTime(true);
                if (AudioOutputInstance.this.maxpolyphony != null) {
                    int maxpoly = (int)DoublePart.asDouble(AudioOutputInstance.this.maxpolyphony);
                    if (maxpoly > 0) {
                        this.audiosession.setMaxPolyphony(maxpoly);
                    }
                } else {
                    this.audiosession.setMaxPolyphony(40);
                }
                this.audiostream = this.audiosession.asByteStream(output, format);
                if (this.audiostream == null) {
                    return;
                }
                byte[] buffer = new byte[this.bits * this.channels * 2];
                this.audiostream.read(buffer);
                this.mixer = audiooutputname != null ? (Mixer)mixerinfotable.get(audiooutputname) : AudioSystem.getMixer(null);
                if (this.mixer == null) {
                    throw new Exception("Invalid name for line mixer.");
                }
                this.mixer.open();
                this.sourceDataLine = (SourceDataLine)this.mixer.getLine(dataLineInfo);
                this.sourceDataLine.open(format, this.buffersize);
                this.sourceDataLine.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.wisplaying = true;
        }

        public void run() {
            if (this.buffersize > this.buffersize_small) {
                this.buffersize = this.buffersize_small;
                this.useblocking = true;
            }
            byte[] buffer = new byte[this.buffersize];
            long bufferNanoTime = (long)(1.0E9 * ((double)this.buffersize / (double)this.framesize) / this.samplerate);
            long expiredtime = 0L;
            try {
                while (true) {
                    this.audiosession.commit();
                    int ret = this.audiostream.read(buffer);
                    if (ret == -1) {
                        this.sourceDataLine.drain();
                        Thread.sleep(250L);
                        this.sourceDataLine.close();
                        break;
                    }
                    if (!this.wisplaying) {
                        this.sourceDataLine.close();
                        break;
                    }
                    this.sourceDataLine.write(buffer, 0, ret);
                    if (this.useblocking) continue;
                    expiredtime = expiredtime < System.nanoTime() ? System.nanoTime() + bufferNanoTime : (expiredtime += bufferNanoTime);
                    long sleepTime = expiredtime - bufferNanoTime - System.nanoTime();
                    if (sleepTime <= 0L) continue;
                    Thread.sleep(sleepTime / 1000000L, (int)(sleepTime % 1000000L));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.wisplaying = false;
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
            try {
                this.audiostream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.audiosession.close();
            this.audiosession = null;
        }
    }
}

