/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.math;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioGain2Instance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = null;
    Variable input2;
    Variable input3;
    int opr = 0;

    public void calc() {
        if (AudioEvents.getInstance((Variable)this.input).track.size() == 0) {
            if (this.answer != null) {
                this.output.remove(this.answer);
                this.answer = null;
            }
        } else if (this.answer == null) {
            this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
            this.output.add(this.answer);
        }
    }

    public AudioGain2Instance(Parameters parameters, int opr) {
        this.opr = opr;
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameter("input");
        if (this.input != null) {
            this.input2 = parameters.getParameterWithDefault(1, "input2");
            this.input3 = parameters.getParameterWithDefault(2, "input3");
        } else {
            this.input = parameters.getParameterWithDefault(1, "input");
            this.input2 = parameters.getParameterWithDefault(2, "input2");
            this.input3 = parameters.getParameterWithDefault(3, "input3");
        }
        AudioEvents.getInstance(this.input).addListener(this);
        this.calc();
    }

    public void close() {
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double ff_2;
        double ff_3;
        AudioFallBackStream inputstream;
        AudioFallBackStream inputstream2;
        AudioFallBackStream inputstream3;
        double[] stockbuffer;
        double[] stockbuffer2;
        double[] stockbuffer3;
        int lopr;
        boolean inputstream2_eof;
        boolean inputstream3_eof;

        public FilterStreamInstance(AudioSession session) {
            this.ff_2 = DoublePart.asDouble(AudioGain2Instance.this.input2);
            this.ff_3 = DoublePart.asDouble(AudioGain2Instance.this.input3);
            this.stockbuffer = null;
            this.stockbuffer2 = null;
            this.stockbuffer3 = null;
            this.lopr = AudioGain2Instance.this.opr;
            this.inputstream2_eof = false;
            this.inputstream3_eof = false;
            this.inputstream = new AudioFallBackStream(AudioEvents.openStream(AudioGain2Instance.this.input, session));
            this.inputstream2 = new AudioFallBackStream(AudioEvents.openStream(AudioGain2Instance.this.input2, session));
            this.inputstream3 = new AudioFallBackStream(AudioEvents.openStream(AudioGain2Instance.this.input3, session));
        }

        public int mix(double[] buffer, int start, int end) {
            int ret;
            block25: {
                int i;
                block24: {
                    double f_2 = this.ff_2;
                    double f_3 = this.ff_3;
                    if (this.stockbuffer == null) {
                        this.stockbuffer = new double[buffer.length];
                    } else if (this.stockbuffer.length < buffer.length) {
                        this.stockbuffer = new double[buffer.length];
                    }
                    ret = this.inputstream.replace(this.stockbuffer, start, end);
                    if (this.inputstream2 != null) {
                        if (this.stockbuffer2 == null) {
                            this.stockbuffer2 = new double[buffer.length];
                        } else if (this.stockbuffer2.length < buffer.length) {
                            this.stockbuffer2 = new double[buffer.length];
                            if (this.inputstream2_eof) {
                                Arrays.fill(this.stockbuffer2, f_2);
                            }
                        }
                        if (!this.inputstream2_eof) {
                            int ret2 = this.inputstream2.replace(this.stockbuffer2, start, end);
                            if (ret2 == -1) {
                                Arrays.fill(this.stockbuffer2, f_2);
                                this.inputstream2_eof = true;
                            } else {
                                Arrays.fill(this.stockbuffer2, start + ret2, end, f_2);
                            }
                        }
                    }
                    if (this.inputstream3 != null) {
                        if (this.stockbuffer3 == null) {
                            this.stockbuffer3 = new double[buffer.length];
                        } else if (this.stockbuffer3.length < buffer.length) {
                            this.stockbuffer3 = new double[buffer.length];
                            if (this.inputstream3_eof) {
                                Arrays.fill(this.stockbuffer3, f_3);
                            }
                        }
                        if (!this.inputstream3_eof) {
                            int ret3 = this.inputstream3.replace(this.stockbuffer3, start, end);
                            if (ret3 == -1) {
                                Arrays.fill(this.stockbuffer3, f_3);
                                this.inputstream3_eof = true;
                            } else {
                                Arrays.fill(this.stockbuffer3, start + ret3, end, f_3);
                            }
                        }
                    }
                    end = start + ret;
                    if (this.lopr != 0) break block24;
                    i = start;
                    while (i < end) {
                        int n = i;
                        buffer[n] = buffer[n] + (this.stockbuffer[i] > 0.5 ? this.stockbuffer2[i] : this.stockbuffer3[i]);
                        ++i;
                    }
                    break block25;
                }
                if (this.lopr != 1) break block25;
                i = start;
                while (i < end) {
                    double b = this.stockbuffer[i];
                    double min = this.stockbuffer2[i];
                    double max = this.stockbuffer3[i];
                    if (b > max) {
                        b = max;
                    } else if (b < min) {
                        b = min;
                    }
                    int n = i++;
                    buffer[n] = buffer[n] + b;
                }
            }
            return ret;
        }

        public int skip(int len) {
            int ret3;
            int ret2;
            int ret = this.inputstream.skip(len);
            if (this.inputstream2 != null && !this.inputstream2_eof && (ret2 = this.inputstream2.skip(len)) == -1) {
                this.inputstream2_eof = true;
            }
            if (this.inputstream3 != null && !this.inputstream3_eof && (ret3 = this.inputstream3.skip(len)) == -1) {
                this.inputstream3_eof = true;
            }
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret;
            block25: {
                int i;
                block24: {
                    double f_2 = this.ff_2;
                    double f_3 = this.ff_3;
                    if (this.stockbuffer == null) {
                        this.stockbuffer = new double[buffer.length];
                    } else if (this.stockbuffer.length < buffer.length) {
                        this.stockbuffer = new double[buffer.length];
                    }
                    ret = this.inputstream.replace(this.stockbuffer, start, end);
                    if (this.inputstream2 != null) {
                        if (this.stockbuffer2 == null) {
                            this.stockbuffer2 = new double[buffer.length];
                        } else if (this.stockbuffer2.length < buffer.length) {
                            this.stockbuffer2 = new double[buffer.length];
                            if (this.inputstream2_eof) {
                                Arrays.fill(this.stockbuffer2, f_2);
                            }
                        }
                        if (!this.inputstream2_eof) {
                            int ret2 = this.inputstream2.replace(this.stockbuffer2, start, end);
                            if (ret2 == -1) {
                                Arrays.fill(this.stockbuffer2, f_2);
                                this.inputstream2_eof = true;
                            } else {
                                Arrays.fill(this.stockbuffer2, start + ret2, end, f_2);
                            }
                        }
                    }
                    if (this.inputstream3 != null) {
                        if (this.stockbuffer3 == null) {
                            this.stockbuffer3 = new double[buffer.length];
                        } else if (this.stockbuffer3.length < buffer.length) {
                            this.stockbuffer3 = new double[buffer.length];
                            if (this.inputstream3_eof) {
                                Arrays.fill(this.stockbuffer3, f_3);
                            }
                        }
                        if (!this.inputstream3_eof) {
                            int ret3 = this.inputstream3.replace(this.stockbuffer3, start, end);
                            if (ret3 == -1) {
                                Arrays.fill(this.stockbuffer3, f_3);
                                this.inputstream3_eof = true;
                            } else {
                                Arrays.fill(this.stockbuffer3, start + ret3, end, f_3);
                            }
                        }
                    }
                    end = start + ret;
                    if (this.lopr != 0) break block24;
                    i = start;
                    while (i < end) {
                        buffer[i] = this.stockbuffer[i] > 0.5 ? this.stockbuffer2[i] : this.stockbuffer3[i];
                        ++i;
                    }
                    break block25;
                }
                if (this.lopr != 1) break block25;
                i = start;
                while (i < end) {
                    double b = this.stockbuffer[i];
                    double min = this.stockbuffer2[i];
                    double max = this.stockbuffer3[i];
                    if (b > max) {
                        b = max;
                    } else if (b < min) {
                        b = min;
                    }
                    buffer[i] = b;
                    ++i;
                }
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            if (this.lopr == 1) {
                double[] stockbuffer = new double[1];
                int ret = this.inputstream.isStatic(stockbuffer, len);
                if (ret == -1) {
                    return -1;
                }
                double[] stockbuffer2 = new double[1];
                int sret = this.inputstream2.isStatic(stockbuffer2, len);
                if (ret == -1) {
                    this.inputstream.fallBack();
                    return -1;
                }
                if (ret != sret) {
                    this.inputstream.fallBack();
                    this.inputstream2.fallBack();
                    return -1;
                }
                double[] stockbuffer3 = new double[1];
                sret = this.inputstream3.isStatic(stockbuffer3, len);
                if (ret == -1) {
                    this.inputstream.fallBack();
                    this.inputstream2.fallBack();
                    return -1;
                }
                if (ret != sret) {
                    this.inputstream.fallBack();
                    this.inputstream2.fallBack();
                    this.inputstream3.fallBack();
                    return -1;
                }
                double b = stockbuffer[0];
                double min = stockbuffer2[0];
                double max = stockbuffer3[0];
                if (b > max) {
                    b = max;
                } else if (b < min) {
                    b = min;
                }
                buffer[0] = b;
                return ret;
            }
            if (this.lopr == 0) {
                double[] stockbuffer = new double[1];
                int ret = this.inputstream.isStatic(stockbuffer, len);
                if (ret == -1) {
                    return -1;
                }
                if (stockbuffer[1] > 0.5) {
                    double[] stockbuffer2 = new double[1];
                    int sret = this.inputstream2.isStatic(stockbuffer2, len);
                    if (ret == -1) {
                        this.inputstream.fallBack();
                        return -1;
                    }
                    if (ret != sret) {
                        this.inputstream.fallBack();
                        this.inputstream2.fallBack();
                        return -1;
                    }
                    buffer[0] = stockbuffer2[0];
                } else {
                    double[] stockbuffer2 = new double[1];
                    int sret = this.inputstream3.isStatic(stockbuffer, len);
                    if (ret == -1) {
                        this.inputstream.fallBack();
                        return -1;
                    }
                    if (ret != sret) {
                        this.inputstream.fallBack();
                        this.inputstream3.fallBack();
                        return -1;
                    }
                    buffer[0] = stockbuffer2[0];
                }
                return ret;
            }
            return -1;
        }

        public void close() {
            this.inputstream.close();
            if (this.inputstream2 != null) {
                this.inputstream2.close();
            }
            if (this.inputstream3 != null) {
                this.inputstream3.close();
            }
            this.inputstream = null;
            this.inputstream2 = null;
            this.inputstream3 = null;
        }
    }
}

