/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.list.SynchronizedList;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioClosable;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.AudioVoiceManager;
import rasmus.interpreter.sampled.BeatToTimeMapper;
import rasmus.interpreter.sampled.midi.InstrumentRecord;
import rasmus.interpreter.sampled.midi.SynthesizerVoice;
import rasmus.interpreter.sampled.midi.VoiceRecord;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioRenderNotesInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Map ext_input_map = new HashMap();
    Variable answer = new Variable();
    Variable voice;
    SynchronizedList voicelist;

    public void calc() {
    }

    private boolean isNumber(String number) {
        int i = 0;
        while (i < number.length()) {
            if (!Character.isDigit(number.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public AudioRenderNotesInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.voice = parameters.getParameterWithDefault(1, "voices");
        this.voicelist = ObjectsPart.synchronizedList(this.voice);
        for (String key : parameters.getParameters().keySet()) {
            Variable v;
            if (this.isNumber(key) || key.equals("output") || key.equals("input") || key.equals("voice") || (v = parameters.getParameter(key)) == null) continue;
            this.ext_input_map.put(key, v);
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
        this.voicelist.close();
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FilterStreamInstance
    implements AudioStream,
    Receiver {
        Sequence iseq;
        long position = 0L;
        Track track;
        MidiEvent midievent = null;
        int trackpos = 0;
        double beatfactor = 1.0 / (double)MidiSequence.DEFAULT_RES;
        BeatToTimeMapper bmap;
        long nexttime = 0L;
        Hashtable actnotes = new Hashtable();
        List voices = new ArrayList();
        double rate;
        int channels;
        boolean realtime;
        Map<VoiceRecord, RegisterdVoice> registeredvoices = new HashMap<VoiceRecord, RegisterdVoice>();
        Map ext_input_streams = new HashMap();
        MidiSequence midiseq = null;
        AudioSession wsession;
        AudioVoiceManager voicemanager = null;
        AudioCache audiocache;
        AudioSession session;
        int selbank = -1;
        int selprogram = -1;
        int selchannel = -1;
        List<VoiceRecord> selvoices = null;
        int currentbank = 0;
        int currentprogram = 0;
        boolean[] keys_down = new boolean[128];
        int[] sustenuto_notes = null;
        boolean hold_active = false;
        int writepos = 0;
        ArrayList<MidiMessage> delayed_messages = new ArrayList();
        long processCounter = 0L;

        public FilterStreamInstance(AudioSession session) {
            this.session = session;
            this.audiocache = session.getAudioCache();
            for (String key : AudioRenderNotesInstance.this.ext_input_map.keySet()) {
                Variable variable = (Variable)AudioRenderNotesInstance.this.ext_input_map.get(key);
                if (AudioEvents.getInstance((Variable)variable).track.size() == 0) continue;
                ExtendedStreamReader esr = new ExtendedStreamReader();
                esr.audiocache = this.audiocache;
                esr.session = session;
                esr.audiostream = AudioEvents.openStream(variable, session.getMonoSession());
                this.ext_input_streams.put(key, esr);
            }
            this.wsession = session;
            this.voicemanager = session.getVoiceManager();
            this.bmap = session.getBeatToTimeMap();
            this.rate = session.getRate();
            this.channels = session.getChannels();
            this.realtime = session.isRealTime();
            if (this.realtime) {
                this.midiseq = MidiSequence.getInstance(AudioRenderNotesInstance.this.input);
                this.midiseq.addReceiver(this);
            } else {
                this.iseq = MidiSequence.asSequence(AudioRenderNotesInstance.this.input);
                this.track = this.iseq.getTracks()[0];
                if (this.track.size() != 0) {
                    this.midievent = this.track.get(0);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime < 0L) {
                        this.nexttime = 0L;
                    }
                }
                this.trackpos = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<VoiceRecord> getInstrumentVoices(int program, int bank, int channel) {
            ArrayList<VoiceRecord> voices = new ArrayList<VoiceRecord>();
            SynchronizedList synchronizedList = AudioRenderNotesInstance.this.voicelist;
            synchronized (synchronizedList) {
                for (Object element : AudioRenderNotesInstance.this.voicelist) {
                    if (element instanceof VoiceRecord) {
                        voices.add((VoiceRecord)element);
                    }
                    if (!(element instanceof InstrumentRecord)) continue;
                    InstrumentRecord ins = (InstrumentRecord)element;
                    if (ins.bank != bank || ins.program != program || !ins.channels[channel]) continue;
                    voices.addAll(ins.voices);
                }
            }
            if (voices.size() == 0) {
                VoiceRecord rvoice = new VoiceRecord();
                rvoice.voice = AudioRenderNotesInstance.this.voice;
                voices.add(rvoice);
            }
            return voices;
        }

        public List<VoiceRecord> getVoices(int channel) {
            if (this.selbank == this.currentbank && this.selprogram == this.currentprogram && this.selchannel == channel) {
                return this.selvoices;
            }
            this.selvoices = this.getInstrumentVoices(this.currentprogram, this.currentbank, channel);
            this.selprogram = this.currentprogram;
            this.selbank = this.currentbank;
            this.selchannel = channel;
            return this.selvoices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMidiMessage(MidiMessage mmsg) {
            List list = this.voices;
            synchronized (list) {
                if (mmsg instanceof ShortMessage) {
                    ShortMessage smmsg = (ShortMessage)mmsg;
                    if (smmsg.getCommand() == 144 || smmsg.getCommand() == 128) {
                        Integer i_note;
                        List newvoices;
                        int note = smmsg.getData1();
                        int vel = smmsg.getData2();
                        if (smmsg.getCommand() == 128) {
                            vel = 0;
                        }
                        boolean bl = this.keys_down[note] = vel != 0;
                        if (vel == 0) {
                            if (this.hold_active) {
                                return;
                            }
                            if (this.sustenuto_notes != null) {
                                int i = 0;
                                while (i < this.sustenuto_notes.length) {
                                    if (this.sustenuto_notes[i] == note) {
                                        return;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if ((newvoices = (List)this.actnotes.get(i_note = new Integer(note))) != null) {
                            for (SynthesizerVoice newvoice : newvoices) {
                                newvoice.setActive(false);
                            }
                            this.actnotes.remove(i_note);
                        }
                        if (vel != 0) {
                            ArrayList<SynthesizerVoice> voicegroup = null;
                            ArrayList<SynthesizerVoice> actvoicelist = null;
                            Iterator<VoiceRecord> iterator = this.getVoices(smmsg.getChannel()).iterator();
                            ArrayList<SynthesizerVoice> enotelist = null;
                            while (iterator.hasNext()) {
                                SynthesizerVoice newvoice;
                                VoiceRecord element = iterator.next();
                                if (element.keyfrom > note || element.keyto < note || element.velfrom > vel || element.velto < vel) continue;
                                RegisterdVoice regvoice = this.registeredvoices.get(element);
                                if (regvoice == null) {
                                    regvoice = new RegisterdVoice(element);
                                }
                                if ((newvoice = regvoice.getVoice()) == null) {
                                    newvoice = new SynthesizerVoice(this.session.getNameSpace(), regvoice.voice, this.ext_input_streams, AudioRenderNotesInstance.this.ext_input_map);
                                    newvoice.registerdvoice = regvoice;
                                }
                                if (regvoice.exclusiveClass != 0) {
                                    if (enotelist == null) {
                                        enotelist = new ArrayList<SynthesizerVoice>(4);
                                    }
                                    enotelist.add(newvoice);
                                    int exclusiveClass = regvoice.exclusiveClass;
                                    for (SynthesizerVoice voice : this.voices) {
                                        if (!(voice.registerdvoice instanceof RegisterdVoice)) continue;
                                        RegisterdVoice rvoice = (RegisterdVoice)voice.registerdvoice;
                                        if (rvoice.exclusiveClass != exclusiveClass || enotelist.contains(voice)) continue;
                                        voice.softKill();
                                    }
                                }
                                if (this.voicemanager != null) {
                                    if (voicegroup == null) {
                                        voicegroup = new ArrayList<SynthesizerVoice>();
                                    }
                                    voicegroup.add(newvoice);
                                    newvoice.group = voicegroup;
                                    newvoice.voicemanager = this.voicemanager;
                                    newvoice.ontime = this.voicemanager.getTime();
                                    newvoice.offtime = -1L;
                                    newvoice.voicemanager.addVoice(newvoice);
                                }
                                newvoice.session = this.wsession;
                                newvoice.setNote(note);
                                newvoice.setVelocity((double)vel / 127.0);
                                newvoice.setActive(true);
                                if (actvoicelist == null) {
                                    actvoicelist = new ArrayList<SynthesizerVoice>();
                                }
                                actvoicelist.add(newvoice);
                                this.voices.add(newvoice);
                            }
                            if (actvoicelist != null) {
                                this.actnotes.put(i_note, actvoicelist);
                            }
                        }
                    } else if (smmsg.getCommand() == 192) {
                        this.selbank = -1;
                        this.selprogram = -1;
                        this.currentprogram = smmsg.getData1();
                    } else if (smmsg.getCommand() == 176) {
                        switch (smmsg.getData1()) {
                            case 0: {
                                this.currentbank = smmsg.getData2() * 128 + this.currentbank % 128;
                                this.selbank = -1;
                                this.selprogram = -1;
                                break;
                            }
                            case 32: {
                                this.currentbank = this.currentbank - this.currentbank % 128 + smmsg.getData2();
                                this.selbank = -1;
                                this.selprogram = -1;
                                break;
                            }
                            case 64: {
                                boolean bl = this.hold_active = smmsg.getData2() >= 64;
                                if (this.hold_active) break;
                                ArrayList<Integer> delnotes = null;
                                for (Map.Entry entry : this.actnotes.entrySet()) {
                                    int i_note = (Integer)entry.getKey();
                                    if (this.keys_down[i_note]) continue;
                                    boolean ok = true;
                                    if (this.sustenuto_notes != null) {
                                        int i = 0;
                                        while (i < this.sustenuto_notes.length) {
                                            if (this.sustenuto_notes[i] == i_note) {
                                                ok = false;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (!ok) continue;
                                    if (delnotes == null) {
                                        delnotes = new ArrayList<Integer>();
                                    }
                                    delnotes.add(i_note);
                                }
                                if (delnotes == null) break;
                                Iterator iterator2 = delnotes.iterator();
                                while (iterator2.hasNext()) {
                                    int i_note = (Integer)iterator2.next();
                                    List newvoices = (List)this.actnotes.get(i_note);
                                    if (newvoices == null) continue;
                                    for (SynthesizerVoice newvoice : newvoices) {
                                        newvoice.setActive(false);
                                    }
                                    this.actnotes.remove(i_note);
                                }
                                break;
                            }
                            case 66: {
                                if (smmsg.getData2() >= 64) {
                                    this.sustenuto_notes = new int[this.actnotes.size()];
                                    Iterator iterator = this.actnotes.keySet().iterator();
                                    int i = 0;
                                    while (i < this.sustenuto_notes.length) {
                                        this.sustenuto_notes[i] = (Integer)iterator.next();
                                        ++i;
                                    }
                                    break;
                                }
                                int i = 0;
                                while (i < this.sustenuto_notes.length) {
                                    int i_note;
                                    List newvoices;
                                    if (!this.keys_down[this.sustenuto_notes[i]] && (newvoices = (List)this.actnotes.get(i_note = this.sustenuto_notes[i])) != null) {
                                        for (SynthesizerVoice newvoice : newvoices) {
                                            newvoice.setActive(false);
                                        }
                                        this.actnotes.remove(i_note);
                                    }
                                    ++i;
                                }
                                this.sustenuto_notes = null;
                                break;
                            }
                            case 120: {
                                for (SynthesizerVoice voice : this.voices) {
                                    voice.softKill();
                                }
                                break;
                            }
                            case 123: {
                                int i = 0;
                                while (i < this.keys_down.length) {
                                    if (this.keys_down[i]) {
                                        try {
                                            ShortMessage sm = new ShortMessage();
                                            sm.setMessage(128, 0, i, 0);
                                            this.send(sm, -1L);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    ++i;
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processSkip(int len) {
            List list = this.voices;
            synchronized (list) {
                Iterator iterator = this.voices.iterator();
                while (iterator.hasNext()) {
                    SynthesizerVoice voice = (SynthesizerVoice)iterator.next();
                    if (voice.skip(len) != -1) continue;
                    voice.reset();
                    ((RegisterdVoice)voice.registerdvoice).returnVoice(voice);
                    iterator.remove();
                }
            }
        }

        public void processAudio(double[] buffer, int start, int end) {
            Iterator iterator = this.voices.iterator();
            while (iterator.hasNext()) {
                SynthesizerVoice voice = (SynthesizerVoice)iterator.next();
                if (voice.processId == this.processCounter || voice.mix(buffer, start, end) != -1) continue;
                voice.reset();
                ((RegisterdVoice)voice.registerdvoice).returnVoice(voice);
                iterator.remove();
            }
        }

        public void processAudioFull(double[] buffer, int start, int end) {
            Iterator iterator = this.voices.iterator();
            while (iterator.hasNext()) {
                SynthesizerVoice voice = (SynthesizerVoice)iterator.next();
                if (voice.isActive()) continue;
                voice.processId = this.processCounter;
                if (voice.mix(buffer, start, end) != -1) continue;
                voice.reset();
                ((RegisterdVoice)voice.registerdvoice).returnVoice(voice);
                iterator.remove();
            }
        }

        @Override
        public int skip(int len) {
            long deltatime;
            this.killAllVoices();
            Iterator iterator = this.ext_input_streams.entrySet().iterator();
            while (iterator.hasNext()) {
                ExtendedStreamReader exr = (ExtendedStreamReader)iterator.next().getValue();
                exr.skip(len);
            }
            if (this.realtime) {
                return len;
            }
            if (this.voices.size() == 0 && this.midievent == null) {
                return -1;
            }
            long endposition = this.position + (long)len;
            this.writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                deltatime = this.nexttime - this.position;
                this.position = this.nexttime;
                this.writepos = (int)((long)this.writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            deltatime = endposition - this.position;
            this.position = endposition;
            return len;
        }

        private boolean isNoteOnMessage(MidiMessage mmsg) {
            if (!(mmsg instanceof ShortMessage)) {
                return false;
            }
            ShortMessage smmsg = (ShortMessage)mmsg;
            return smmsg.getCommand() == 144 && smmsg.getData2() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int mix(double[] buffer, int start, int end) {
            List list = this.voices;
            synchronized (list) {
                long deltatime;
                block16: {
                    ++this.processCounter;
                    Iterator iterator = this.ext_input_streams.entrySet().iterator();
                    while (iterator.hasNext()) {
                        ExtendedStreamReader exr = (ExtendedStreamReader)iterator.next().getValue();
                        exr.read(end - start);
                    }
                    if (this.realtime) {
                        this.processAudio(buffer, start, end);
                        return end - start;
                    }
                    if (this.voices.size() != 0 || this.midievent != null) break block16;
                    return -1;
                }
                this.processAudioFull(buffer, start, end);
                long endposition = this.position + (long)end - (long)start;
                this.writepos = 0;
                this.delayed_messages.clear();
                while (this.nexttime <= endposition && this.midievent != null) {
                    MidiMessage mmsg = this.midievent.getMessage();
                    if (this.isNoteOnMessage(mmsg)) {
                        this.delayed_messages.add(mmsg);
                    } else {
                        this.processMidiMessage(mmsg);
                    }
                    long deltatime2 = this.nexttime - this.position;
                    if (deltatime2 != 0L && !this.delayed_messages.isEmpty()) {
                        Iterator<MidiMessage> iter = this.delayed_messages.iterator();
                        while (iter.hasNext()) {
                            this.processMidiMessage(iter.next());
                        }
                        this.delayed_messages.clear();
                    }
                    if (deltatime2 != 0L) {
                        this.processAudio(buffer, this.writepos, (int)((long)this.writepos + deltatime2));
                    }
                    this.position = this.nexttime;
                    this.writepos = (int)((long)this.writepos + deltatime2);
                    ++this.trackpos;
                    if (this.trackpos < this.track.size()) {
                        this.midievent = this.track.get(this.trackpos);
                        this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                        if (this.nexttime >= 0L) continue;
                        this.nexttime = 0L;
                        continue;
                    }
                    this.midievent = null;
                }
                if (!this.delayed_messages.isEmpty()) {
                    Iterator<MidiMessage> iter = this.delayed_messages.iterator();
                    while (iter.hasNext()) {
                        this.processMidiMessage(iter.next());
                    }
                    this.delayed_messages.clear();
                }
                if ((deltatime = endposition - this.position) != 0L) {
                    this.processAudio(buffer, this.writepos, (int)((long)this.writepos + deltatime));
                }
                this.position = endposition;
                return end - start;
            }
        }

        @Override
        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int isStatic(double[] buffer, int len) {
            block10: {
                List list = this.voices;
                synchronized (list) {
                    long endposition;
                    block9: {
                        block8: {
                            block7: {
                                if (this.voices.size() == 0) break block7;
                                return -1;
                            }
                            if (this.realtime) break block10;
                            if (this.voices.size() != 0 || this.midievent != null) break block8;
                            return -1;
                        }
                        endposition = this.position + (long)len;
                        if (this.nexttime > endposition || this.midievent == null) break block9;
                        return -1;
                    }
                    this.position = endposition;
                }
            }
            Iterator iterator = this.ext_input_streams.entrySet().iterator();
            while (iterator.hasNext()) {
                ExtendedStreamReader exr = (ExtendedStreamReader)iterator.next().getValue();
                exr.read(len);
            }
            buffer[0] = 0.0;
            return len;
        }

        public void killAllVoices() {
            for (SynthesizerVoice voice : this.voices) {
                voice.reset();
                ((RegisterdVoice)voice.registerdvoice).returnVoice(voice);
            }
            this.voices.clear();
        }

        @Override
        public void close() {
            if (this.midiseq != null) {
                this.midiseq.removeReceiver(this);
            }
            for (SynthesizerVoice voice : this.voices) {
                voice.reset();
                ((RegisterdVoice)voice.registerdvoice).returnVoice(voice);
            }
            this.voices.clear();
            Iterator<Object> iterator = this.registeredvoices.values().iterator();
            while (iterator.hasNext()) {
                ((RegisterdVoice)iterator.next()).close();
            }
            this.registeredvoices.clear();
            iterator = this.ext_input_streams.entrySet().iterator();
            while (iterator.hasNext()) {
                ExtendedStreamReader exr = (ExtendedStreamReader)((Map.Entry)iterator.next()).getValue();
                exr.close();
            }
            this.ext_input_streams.clear();
        }

        @Override
        public void send(MidiMessage arg0, long arg1) {
            this.processMidiMessage(arg0);
        }

        public class ExtendedStreamReader
        implements AudioStreamable {
            public AudioStream audiostream;
            public boolean eof_audiostream = false;
            public AudioCache audiocache;
            public AudioSession session;
            public boolean isStatic = true;
            public int extbuffer_len = 0;
            public double[] staticbuffer = new double[1];
            public double[] extbuffer = null;
            public Variable variable = new Variable();
            public Variable tvariable;

            public AudioStream openStream(AudioSession session) {
                return new ExtendedAudioStream(session);
            }

            public ExtendedStreamReader() {
                AudioEvent audioevent = new AudioEvent(0.0, this);
                this.tvariable = AudioEvents.asVariable(audioevent);
                this.variable.add(this.tvariable);
            }

            public void close() {
                if (this.extbuffer != null) {
                    this.audiocache.returnBuffer(this.extbuffer);
                }
                this.extbuffer = null;
                this.audiostream.close();
                this.variable.remove(this.tvariable);
                this.variable = null;
                this.tvariable = null;
            }

            public void skip(int len) {
                len /= this.session.getChannels();
                if (this.eof_audiostream) {
                    this.staticbuffer[0] = 0.0;
                    this.isStatic = true;
                    return;
                }
                this.isStatic = false;
                int ret = this.audiostream.skip(len);
                if (ret == -1) {
                    this.eof_audiostream = true;
                    this.staticbuffer[0] = 0.0;
                    this.isStatic = true;
                    return;
                }
                this.extbuffer_len = len;
            }

            public void read(int len) {
                len /= this.session.getChannels();
                if (this.eof_audiostream) {
                    this.staticbuffer[0] = 0.0;
                    this.isStatic = true;
                    return;
                }
                int ret = this.audiostream.isStatic(this.staticbuffer, 1);
                if (ret != -1) {
                    this.isStatic = true;
                    return;
                }
                this.isStatic = false;
                if (this.extbuffer != null && this.extbuffer.length < len) {
                    this.audiocache.returnBuffer(this.extbuffer);
                    this.extbuffer = null;
                }
                if (this.extbuffer == null) {
                    this.extbuffer = this.audiocache.getBuffer(len);
                }
                if ((ret = this.audiostream.replace(this.extbuffer, 0, len)) == -1) {
                    this.eof_audiostream = true;
                    this.staticbuffer[0] = 0.0;
                    this.isStatic = true;
                    return;
                }
                this.extbuffer_len = len;
                if (ret != len) {
                    Arrays.fill(this.extbuffer, ret, len, 0.0);
                }
            }

            public class ExtendedAudioStream
            implements AudioStream {
                AudioSession session;

                public ExtendedAudioStream(AudioSession session) {
                    this.session = session;
                }

                public int mix(double[] buffer, int start, int end) {
                    int len = end - start;
                    len /= this.session.getChannels();
                    int wp = ((ExtendedStreamReader)ExtendedStreamReader.this).FilterStreamInstance.this.writepos / ((ExtendedStreamReader)ExtendedStreamReader.this).FilterStreamInstance.this.wsession.getChannels();
                    int channels = this.session.getChannels();
                    if (ExtendedStreamReader.this.isStatic) {
                        double staticval = ExtendedStreamReader.this.staticbuffer[0];
                        int i = start;
                        while (i < end) {
                            int n = i++;
                            buffer[n] = buffer[n] + staticval;
                        }
                        return end - start;
                    }
                    int ext_len = ExtendedStreamReader.this.extbuffer_len;
                    int c = 0;
                    while (c < channels) {
                        int pos = c;
                        int epos = wp;
                        int i = 0;
                        while (i < len) {
                            int n = pos;
                            buffer[n] = buffer[n] + ExtendedStreamReader.this.extbuffer[epos];
                            pos += channels;
                            if (++epos >= ext_len) {
                                epos = ext_len - 1;
                            }
                            ++i;
                        }
                        ++c;
                    }
                    return end - start;
                }

                public int replace(double[] buffer, int start, int end) {
                    int len = end - start;
                    len /= this.session.getChannels();
                    int wp = ((ExtendedStreamReader)ExtendedStreamReader.this).FilterStreamInstance.this.writepos / ((ExtendedStreamReader)ExtendedStreamReader.this).FilterStreamInstance.this.wsession.getChannels();
                    int channels = this.session.getChannels();
                    if (ExtendedStreamReader.this.isStatic) {
                        double staticval = ExtendedStreamReader.this.staticbuffer[0];
                        int i = start;
                        while (i < end) {
                            buffer[i] = staticval;
                            ++i;
                        }
                        return end - start;
                    }
                    int ext_len = ExtendedStreamReader.this.extbuffer_len;
                    int c = 0;
                    while (c < channels) {
                        int pos = start + c;
                        int epos = wp;
                        int i = 0;
                        while (i < len) {
                            buffer[pos] = ExtendedStreamReader.this.extbuffer[epos];
                            pos += channels;
                            if (++epos >= ext_len) {
                                epos = ext_len - 1;
                            }
                            ++i;
                        }
                        ++c;
                    }
                    return end - start;
                }

                public int isStatic(double[] buffer, int len) {
                    if (!ExtendedStreamReader.this.isStatic) {
                        return -1;
                    }
                    buffer[0] = ExtendedStreamReader.this.staticbuffer[0];
                    return len;
                }

                public int skip(int len) {
                    return len;
                }

                public void close() {
                }
            }
        }

        class RegisterdVoice {
            Variable voice;
            int exclusiveClass = 0;
            LinkedList voicereusing = new LinkedList();
            ListPartListener listlistener = new ListPartListener(this){
                final /* synthetic */ RegisterdVoice this$2;
                {
                    this.this$2 = registerdVoice;
                }

                public void objectAdded(ListPart source, Object object) {
                    this.this$2.clear();
                }

                public void objectRemoved(ListPart source, Object object) {
                    this.this$2.clear();
                }

                public void objectsAdded(ListPart source, List objects) {
                    this.this$2.clear();
                }

                public void objectsRemoved(ListPart source, List objects) {
                    this.this$2.clear();
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RegisterdVoice(VoiceRecord voice) {
                Unit.getInstance(voice.voice).addListener(this.listlistener);
                LinkedList linkedList = this.voicereusing;
                synchronized (linkedList) {
                    FilterStreamInstance.this.registeredvoices.put(voice, this);
                }
                this.voice = voice.voice;
                this.exclusiveClass = voice.exclusiveClass;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SynthesizerVoice getVoice() {
                LinkedList linkedList = this.voicereusing;
                synchronized (linkedList) {
                    if (this.voicereusing.size() == 0) {
                        return null;
                    }
                    return (SynthesizerVoice)this.voicereusing.remove(0);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void returnVoice(SynthesizerVoice synvoice) {
                LinkedList linkedList = this.voicereusing;
                synchronized (linkedList) {
                    if (this.voicereusing.size() > 8) {
                        synvoice.close();
                        return;
                    }
                    this.voicereusing.add(synvoice);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clear() {
                LinkedList linkedList = this.voicereusing;
                synchronized (linkedList) {
                    for (Object element : this.voicereusing) {
                        if (!(element instanceof AudioClosable)) continue;
                        ((AudioClosable)element).close();
                    }
                    this.voicereusing.clear();
                }
            }

            public void close() {
                Unit.getInstance(this.voice).removeListener(this.listlistener);
                this.clear();
            }
        }
    }
}

