/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.Arrays;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.BeatToTimeMapper;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioRenderPitchBendInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable defaultvalue;

    public void calc() {
    }

    public AudioRenderPitchBendInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.defaultvalue = parameters.getParameterWithDefault(1, "default");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream,
    Receiver {
        Sequence iseq;
        long position = 0L;
        Track track;
        MidiEvent midievent = null;
        int trackpos = 0;
        double beatfactor = 1.0 / (double)MidiSequence.DEFAULT_RES;
        BeatToTimeMapper bmap;
        long nexttime = 0L;
        double rate;
        int channels;
        boolean realtime;
        double max_step_size = 1.0;
        int midi_defaultvalue;
        double current_value;
        double target_value;
        MidiSequence midiseq;
        AudioSession session;
        AudioCache audiocache;
        boolean firstbuffer;

        public FilterStreamInstance(AudioSession session) {
            this.midi_defaultvalue = (int)DoublePart.asDouble(AudioRenderPitchBendInstance.this.defaultvalue);
            this.current_value = this.midi_defaultvalue;
            this.target_value = this.midi_defaultvalue;
            this.midiseq = null;
            this.firstbuffer = true;
            this.audiocache = session.getAudioCache();
            this.session = session;
            this.bmap = session.getBeatToTimeMap();
            this.rate = session.getRate();
            this.channels = session.getChannels();
            this.realtime = session.isRealTime();
            this.max_step_size = 200000.0 / ((double)this.channels * this.rate);
            if (this.realtime) {
                this.midiseq = MidiSequence.getInstance(AudioRenderPitchBendInstance.this.input);
                this.midiseq.addReceiver(this);
            } else {
                this.iseq = MidiSequence.asSequence(AudioRenderPitchBendInstance.this.input);
                this.track = this.iseq.getTracks()[0];
                if (this.track.size() != 0) {
                    this.midievent = this.track.get(0);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime < 0L) {
                        this.nexttime = 0L;
                    }
                }
                this.trackpos = 0;
            }
        }

        public void processMidiMessage(MidiMessage mmsg) {
            if (mmsg instanceof ShortMessage) {
                ShortMessage smmsg = (ShortMessage)mmsg;
                if (smmsg.getCommand() == 224) {
                    int pitchvalue = smmsg.getData1() + smmsg.getData2() * 128;
                    this.target_value = pitchvalue;
                } else if (smmsg.getCommand() == 176 && smmsg.getData1() == 121) {
                    this.target_value = this.midi_defaultvalue;
                }
            }
        }

        public void processSkip(int len) {
            double step_value;
            int ix = 0;
            double cur = this.current_value;
            double tar = this.target_value;
            if (this.firstbuffer) {
                this.firstbuffer = false;
                cur = tar;
            }
            if (cur > tar) {
                step_value = -this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) < tar) {
                        cur = tar;
                        break;
                    }
                    if (++ix != len) continue;
                    this.current_value = cur;
                    return;
                }
            }
            if (cur < tar) {
                step_value = this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) > tar) {
                        cur = tar;
                        break;
                    }
                    if (++ix != len) continue;
                    this.current_value = cur;
                    return;
                }
            }
            this.current_value = cur;
        }

        public void processAudio(double[] buffer, int start, int end) {
            double step_value;
            int ix = start;
            double cur = this.current_value;
            double tar = this.target_value;
            if (this.firstbuffer) {
                this.firstbuffer = false;
                cur = tar;
            }
            if (cur > tar) {
                step_value = -this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) < tar) {
                        cur = tar;
                        break;
                    }
                    int n = ix++;
                    buffer[n] = buffer[n] + cur;
                    if (ix < end) continue;
                    this.current_value = cur;
                    return;
                }
            }
            if (cur < tar) {
                step_value = this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) > tar) {
                        cur = tar;
                        break;
                    }
                    int n = ix++;
                    buffer[n] = buffer[n] + cur;
                    if (ix < end) continue;
                    this.current_value = cur;
                    return;
                }
            }
            this.current_value = cur;
            Arrays.fill(buffer, ix, end, this.current_value);
        }

        public int skip(int len) {
            if (this.realtime) {
                this.processSkip(len);
                return len;
            }
            long endposition = this.position + (long)len;
            int writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                MidiMessage mmsg = this.midievent.getMessage();
                this.processMidiMessage(mmsg);
                long deltatime = this.nexttime - this.position;
                if (deltatime != 0L) {
                    this.processSkip((int)deltatime);
                }
                this.position = this.nexttime;
                writepos = (int)((long)writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            long deltatime = endposition - this.position;
            if (deltatime != 0L) {
                this.processSkip((int)deltatime);
            }
            this.position = endposition;
            return len;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.realtime) {
                this.processAudio(buffer, start, end);
                return end - start;
            }
            long endposition = this.position + (long)end - (long)start;
            int writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                MidiMessage mmsg = this.midievent.getMessage();
                this.processMidiMessage(mmsg);
                long deltatime = this.nexttime - this.position;
                if (deltatime != 0L) {
                    this.processAudio(buffer, writepos, (int)((long)writepos + deltatime));
                }
                this.position = this.nexttime;
                writepos = (int)((long)writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            long deltatime = endposition - this.position;
            if (deltatime != 0L) {
                this.processAudio(buffer, writepos, (int)((long)writepos + deltatime));
            }
            this.position = endposition;
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            if (this.current_value != this.target_value) {
                return -1;
            }
            buffer[0] = this.current_value;
            if (!this.realtime) {
                if (this.midievent == null) {
                    return len;
                }
                long endposition = this.position + (long)len;
                if (this.nexttime <= endposition && this.midievent != null) {
                    return -1;
                }
                this.position = endposition;
            }
            return len;
        }

        public void close() {
            if (this.midiseq != null) {
                this.midiseq.removeReceiver(this);
            }
        }

        public void send(MidiMessage arg0, long arg1) {
            this.processMidiMessage(arg0);
        }
    }
}

