/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.Arrays;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import rasmus.interpreter.Variable;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.BeatToTimeMapper;
import rasmus.interpreter.sampled.midi.AudioRenderPitch;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioRenderPitchInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioRenderPitchInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream,
    Receiver {
        Sequence iseq;
        long position = 0L;
        Track track;
        MidiEvent midievent = null;
        int trackpos = 0;
        double beatfactor = 1.0 / (double)MidiSequence.DEFAULT_RES;
        BeatToTimeMapper bmap;
        long nexttime = 0L;
        double rate;
        int channels;
        boolean realtime;
        double max_step_size = 1.0;
        double target_value;
        double current_value = this.target_value = 1.0;
        MidiSequence midiseq = null;
        AudioSession session;
        AudioCache audiocache;
        int RPN_STATUS = 16383;
        double pitch = 1.0;
        double coarse_tune = 1.0;
        double fine_tune = 1.0;
        double modulation = 0.0;
        int pitchsens = 200;
        boolean firstbuffer = true;
        double rate_factor;
        double vibration_clock = 0.0;
        double modulation_depth = 0.08333333333333333;

        public FilterStreamInstance(AudioSession session) {
            this.audiocache = session.getAudioCache();
            this.session = session;
            this.bmap = session.getBeatToTimeMap();
            this.rate = session.getRate();
            this.channels = session.getChannels();
            this.realtime = session.isRealTime();
            this.rate_factor = (double)(AudioRenderPitch.sinbuffer_len * 7) / this.rate;
            this.max_step_size = 2000.0 / ((double)this.channels * this.rate);
            if (this.realtime) {
                this.midiseq = MidiSequence.getInstance(AudioRenderPitchInstance.this.input);
                this.midiseq.addReceiver(this);
            } else {
                this.iseq = MidiSequence.asSequence(AudioRenderPitchInstance.this.input);
                this.track = this.iseq.getTracks()[0];
                if (this.track.size() != 0) {
                    this.midievent = this.track.get(0);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime < 0L) {
                        this.nexttime = 0L;
                    }
                }
                this.trackpos = 0;
            }
        }

        public void calcPitchValue() {
            this.target_value = this.pitch * this.coarse_tune * this.fine_tune;
        }

        public void processMidiMessage(MidiMessage mmsg) {
            if (mmsg instanceof ShortMessage) {
                ShortMessage smmsg = (ShortMessage)mmsg;
                if (smmsg.getCommand() == 176) {
                    int control = smmsg.getData1();
                    if (control == 1) {
                        this.modulation = (double)smmsg.getData2() / 127.0;
                        return;
                    }
                    if (control == 76) {
                        this.rate_factor = Math.pow(2.0, (double)(smmsg.getData2() - 64) / 120.0) * (double)AudioRenderPitch.sinbuffer_len * 7.0 / this.rate;
                    }
                    if (control == 77) {
                        this.modulation_depth = 100.0 * Math.pow(4.0, (double)(smmsg.getData2() - 64) / 64.0) / 1200.0;
                    }
                    if (control == 101) {
                        this.RPN_STATUS = smmsg.getData2() * 128 + this.RPN_STATUS % 128;
                        return;
                    }
                    if (control == 100) {
                        this.RPN_STATUS = this.RPN_STATUS - this.RPN_STATUS % 128 + smmsg.getData2();
                        return;
                    }
                    if (control == 6 || control == 38) {
                        if (this.RPN_STATUS == 0) {
                            if (control == 6) {
                                this.pitchsens = this.pitchsens % 100 + smmsg.getData2() * 100;
                                return;
                            }
                            if (control == 38) {
                                this.pitchsens = this.pitchsens - this.pitchsens % 100 + smmsg.getData2();
                                return;
                            }
                        }
                        if (this.RPN_STATUS == 1 && control == 6) {
                            this.fine_tune = Math.pow(2.0, 8.333333333333334E-4 * (double)(smmsg.getData2() - 64));
                            this.calcPitchValue();
                            return;
                        }
                        if (this.RPN_STATUS == 2 && control == 6) {
                            this.coarse_tune = Math.pow(2.0, 0.08333333333333333 * (double)(smmsg.getData2() - 64));
                            this.calcPitchValue();
                            return;
                        }
                    }
                    if (control == 121) {
                        this.RPN_STATUS = 16383;
                        this.pitch = 1.0;
                        this.coarse_tune = 1.0;
                        this.fine_tune = 1.0;
                        this.modulation = 0.0;
                        this.pitchsens = 200;
                        this.calcPitchValue();
                        return;
                    }
                }
                if (smmsg.getCommand() == 224) {
                    int pitchvalue = smmsg.getData1() + smmsg.getData2() * 128;
                    this.pitch = Math.pow(2.0, (double)this.pitchsens / 1200.0 * ((double)pitchvalue - 8192.0) / 8192.0);
                    this.calcPitchValue();
                    return;
                }
            }
        }

        public void processSkip(int len) {
            double step_value;
            int ix = 0;
            double cur = this.current_value;
            double tar = this.target_value;
            if (this.firstbuffer) {
                this.firstbuffer = false;
                cur = tar;
            }
            if (cur > tar) {
                step_value = -this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) < tar) {
                        cur = tar;
                        break;
                    }
                    if (++ix != len) continue;
                    this.current_value = cur;
                    return;
                }
            }
            if (cur < tar) {
                step_value = this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) > tar) {
                        cur = tar;
                        break;
                    }
                    if (++ix != len) continue;
                    this.current_value = cur;
                    return;
                }
            }
            this.current_value = cur;
        }

        public void processAudio(double[] buffer, int start, int end) {
            if (this.modulation != 0.0) {
                double sinbuffer_len = AudioRenderPitch.sinbuffer_len;
                double[] sinbuffer = AudioRenderPitch.sinbuffer;
                double[] pbuffer = this.session.getAudioCache().getBuffer(end);
                double modulation_depth = this.modulation_depth;
                double vibration_clock = this.vibration_clock;
                this.processAudio2(pbuffer, start, end);
                int i = start;
                while (i < end) {
                    double li = vibration_clock % 1.0;
                    int ii = (int)vibration_clock;
                    double vibvalue = sinbuffer[ii] * (1.0 - li) + sinbuffer[ii] * li;
                    int n = i;
                    buffer[n] = buffer[n] + pbuffer[i] * Math.pow(2.0, vibvalue * this.modulation * modulation_depth);
                    vibration_clock = (vibration_clock + this.rate_factor) % sinbuffer_len;
                    ++i;
                }
                this.vibration_clock = vibration_clock;
                this.session.getAudioCache().returnBuffer(pbuffer);
            } else {
                this.processAudio2(buffer, start, end);
            }
        }

        public void processAudio2(double[] buffer, int start, int end) {
            double step_value;
            int ix = start;
            double cur = this.current_value;
            double tar = this.target_value;
            if (this.firstbuffer) {
                this.firstbuffer = false;
                cur = tar;
            }
            if (cur > tar) {
                step_value = -this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) < tar) {
                        cur = tar;
                        break;
                    }
                    int n = ix++;
                    buffer[n] = buffer[n] + cur;
                    if (ix < end) continue;
                    this.current_value = cur;
                    return;
                }
            }
            if (cur < tar) {
                step_value = this.max_step_size;
                while (cur != tar) {
                    if ((cur += step_value) > tar) {
                        cur = tar;
                        break;
                    }
                    int n = ix++;
                    buffer[n] = buffer[n] + cur;
                    if (ix < end) continue;
                    this.current_value = cur;
                    return;
                }
            }
            this.current_value = cur;
            Arrays.fill(buffer, ix, end, this.current_value);
        }

        public int skip(int len) {
            if (this.realtime) {
                this.processSkip(len);
                return len;
            }
            long endposition = this.position + (long)len;
            int writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                MidiMessage mmsg = this.midievent.getMessage();
                this.processMidiMessage(mmsg);
                long deltatime = this.nexttime - this.position;
                if (deltatime != 0L) {
                    this.processSkip((int)deltatime);
                }
                this.position = this.nexttime;
                writepos = (int)((long)writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            long deltatime = endposition - this.position;
            if (deltatime != 0L) {
                this.processSkip((int)deltatime);
            }
            this.position = endposition;
            return len;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.realtime) {
                this.processAudio(buffer, start, end);
                return end - start;
            }
            long endposition = this.position + (long)end - (long)start;
            int writepos = 0;
            while (this.nexttime <= endposition && this.midievent != null) {
                MidiMessage mmsg = this.midievent.getMessage();
                this.processMidiMessage(mmsg);
                long deltatime = this.nexttime - this.position;
                if (deltatime != 0L) {
                    this.processAudio(buffer, writepos, (int)((long)writepos + deltatime));
                }
                this.position = this.nexttime;
                writepos = (int)((long)writepos + deltatime);
                ++this.trackpos;
                if (this.trackpos < this.track.size()) {
                    this.midievent = this.track.get(this.trackpos);
                    this.nexttime = AudioEvents.TimeToStreamTime(this.bmap.getTime((double)this.midievent.getTick() * this.beatfactor), this.rate, this.channels);
                    if (this.nexttime >= 0L) continue;
                    this.nexttime = 0L;
                    continue;
                }
                this.midievent = null;
            }
            long deltatime = endposition - this.position;
            if (deltatime != 0L) {
                this.processAudio(buffer, writepos, (int)((long)writepos + deltatime));
            }
            this.position = endposition;
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            if (Math.abs(this.modulation) > 1.0E-9) {
                return -1;
            }
            if (Math.abs(this.current_value - this.target_value) > 1.0E-9) {
                return -1;
            }
            buffer[0] = this.current_value;
            if (!this.realtime) {
                if (this.midievent == null) {
                    return len;
                }
                long endposition = this.position + (long)len;
                if (this.nexttime <= endposition && this.midievent != null) {
                    return -1;
                }
                this.position = endposition;
            }
            return len;
        }

        public void close() {
            if (this.midiseq != null) {
                this.midiseq.removeReceiver(this);
            }
        }

        public void send(MidiMessage arg0, long arg1) {
            this.processMidiMessage(arg0);
        }
    }
}

