/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.math.AudioOperator;
import rasmus.interpreter.sampled.midi.AudioRenderGain;
import rasmus.interpreter.sampled.midi.AudioRenderNotes;
import rasmus.interpreter.sampled.midi.AudioRenderPitch;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class AudioSynthesizerInstance
implements UnitInstancePart {
    UnitInstancePart rendernotes;
    UnitInstancePart renderpitch;
    UnitInstancePart rendergain;
    UnitInstancePart gain;

    public AudioSynthesizerInstance(Parameters parameters) {
        Parameters imap = parameters.clone();
        Parameters pmap = new Parameters(parameters.getNameSpace());
        Variable poutput = new Variable();
        pmap.setParameter("output", poutput);
        imap.setParameter("pitch", poutput);
        pmap.setParameter("input", parameters.getParameter("input"));
        this.renderpitch = new AudioRenderPitch().newInstance(pmap);
        Parameters vmap = new Parameters(parameters.getNameSpace());
        Variable voutput = new Variable();
        vmap.setParameter("output", voutput);
        vmap.setParameter("input", parameters.getParameterWithDefault("input"));
        this.rendergain = new AudioRenderGain().newInstance(vmap);
        Parameters gmap = new Parameters(parameters.getNameSpace());
        Variable ginput = new Variable();
        gmap.setParameter("output", parameters.getParameterWithDefault("output"));
        gmap.setParameter("input", ginput);
        gmap.setParameter("input2", voutput);
        this.gain = new AudioOperator(0).newInstance(gmap);
        imap.setParameter("output", ginput);
        this.rendernotes = new AudioRenderNotes().newInstance(imap);
    }

    public void close() {
        this.rendernotes.close();
        this.renderpitch.close();
        this.rendergain.close();
        this.gain.close();
    }
}

