/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.midi;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioClosable;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.AudioVoice;
import rasmus.interpreter.sampled.AudioVoiceManager;
import rasmus.interpreter.sampled.midi.AudioRenderNotes;
import rasmus.interpreter.sampled.midi.AudioRenderNotesInstance;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitInstance;

class SynthesizerVoice
implements AudioClosable,
AudioVoice {
    int i_note = 0;
    Variable v_note = new Variable();
    Variable v_velocity = new Variable();
    Variable v_active;
    Variable t_note = null;
    Variable t_velocity = null;
    Variable voice;
    AudioSession session;
    AudioVoiceManager voicemanager = null;
    boolean isActive = true;
    long processId = 0L;
    List group = null;
    long ontime = -1L;
    long offtime = -1L;
    UnitInstance voci = null;
    Variable voiceo = new Variable();
    public Object registerdvoice;
    NameSpace namespace;
    AudioStreamable activeStreamable = new AudioStreamable(){

        public AudioStream openStream(AudioSession session) {
            return new AudioStream(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public int mix(double[] buffer, int start, int end) {
                    if (!1.access$0(this.this$1).isActive) {
                        return -1;
                    }
                    int i = start;
                    while (i < end) {
                        int n = i++;
                        buffer[n] = buffer[n] + 1.0;
                    }
                    return end - start;
                }

                public int replace(double[] buffer, int start, int end) {
                    if (!1.access$0(this.this$1).isActive) {
                        return -1;
                    }
                    Arrays.fill(buffer, start, end, 1.0);
                    return end - start;
                }

                public int isStatic(double[] buffer, int len) {
                    if (!1.access$0(this.this$1).isActive) {
                        return -1;
                    }
                    buffer[0] = 1.0;
                    return len;
                }

                public int skip(int len) {
                    if (!1.access$0(this.this$1).isActive) {
                        return -1;
                    }
                    return len;
                }

                public void close() {
                }
            };
        }

        static /* synthetic */ SynthesizerVoice access$0(1 var0) {
            return var0.SynthesizerVoice.this;
        }
    };
    AudioStream voicestream = null;
    boolean softKillActive = false;
    double softKill_vol;
    double softKill_vol_step;
    static /* synthetic */ Class class$0;

    public long getOnTime() {
        return this.ontime;
    }

    public long getOffTime() {
        return this.offtime;
    }

    public void setActive(boolean value) {
        if (this.voicemanager != null && !value) {
            this.offtime = this.voicemanager.getTime();
        }
        this.isActive = value;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setNote(int note) {
        this.i_note = note;
        if (this.t_note != null) {
            this.v_note.remove(this.t_note);
        }
        this.t_note = DoublePart.asVariable(note);
        this.v_note.add(this.t_note);
    }

    public void setVelocity(double velocity) {
        if (this.t_velocity != null) {
            this.v_velocity.remove(this.t_velocity);
        }
        this.t_velocity = DoublePart.asVariable(velocity);
        this.v_velocity.add(this.t_velocity);
    }

    public SynthesizerVoice(NameSpace namespace, Variable voice, Map ext_input_map, Map o_ext_input_map) {
        this.v_active = AudioEvents.asVariable(new AudioEvent(0.0, this.activeStreamable));
        this.voice = voice;
        this.namespace = namespace;
        Parameters params = new Parameters(namespace);
        params.setParameter("output", this.voiceo);
        params.setParameter("note", this.v_note);
        params.setParameter("velocity", this.v_velocity);
        params.setParameter("active", this.v_active);
        params.setParameter("gate", this.v_active);
        for (String key : ext_input_map.keySet()) {
            Variable obj = ((AudioRenderNotesInstance.FilterStreamInstance.ExtendedStreamReader)ext_input_map.get((Object)key)).variable;
            params.setParameter(key, obj);
        }
        for (String key : o_ext_input_map.keySet()) {
            if (ext_input_map.get(key) != null) continue;
            params.setParameter(key, (Variable)o_ext_input_map.get(key));
        }
        this.voci = Unit.getInstance(voice).newInstance(params);
        this.voci.setUpdateable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream getStream() {
        if (this.voicestream != null) {
            return this.voicestream;
        }
        this.namespace.commit();
        Class<AudioRenderNotes> clazz = AudioRenderNotes.class;
        synchronized (AudioRenderNotes.class) {
            ++AudioRenderNotes.activevoices;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            AudioSession voicesession = this.session.newSession();
            voicesession.setRealTime(false);
            AudioEvents audioevents = AudioEvents.getInstance(this.voiceo);
            if (audioevents.track.size() == 1) {
                AudioEvent aevent = (AudioEvent)audioevents.track.get(0);
                if (aevent.start == 0.0) {
                    this.voicestream = aevent.streamable.openStream(voicesession);
                    return this.voicestream;
                }
            }
            this.voicestream = AudioEvents.openStream(this.voiceo, voicesession);
            return this.voicestream;
        }
    }

    public void softKill() {
        if (this.softKillActive) {
            return;
        }
        this.softKillActive = true;
        this.softKill_vol = 1.0;
        this.softKill_vol_step = 1.0 / (0.005 * this.session.getRate());
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        if (this.voicemanager != null) {
            this.voicemanager.removeVoice(this);
            this.voicemanager = null;
        }
    }

    public void stopNow() {
        if (this.group != null) {
            this.softKill_vol_step = 1.0 / (0.005 * this.session.getRate());
            for (SynthesizerVoice voice : this.group) {
                if (voice.softKillActive) continue;
                voice.softKillActive = true;
                voice.softKill_vol = 1.0;
                voice.softKill_vol_step = this.softKill_vol_step;
                voice.group = null;
                if (voice.voicemanager == null) continue;
                voice.voicemanager.removeVoice(voice);
                voice.voicemanager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset() {
        if (this.voicestream == null) return;
        this.group = null;
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        if (this.voicemanager != null) {
            this.voicemanager.removeVoice(this);
            this.voicemanager = null;
        }
        Class<AudioRenderNotes> clazz = AudioRenderNotes.class;
        synchronized (AudioRenderNotes.class) {
            --AudioRenderNotes.activevoices;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.voicestream.close();
            this.voicestream = null;
            this.softKillActive = false;
            return;
        }
    }

    public int mix(double[] buffer, int start, int end) {
        if (this.softKillActive) {
            int channels = this.session.getChannels();
            double evol = this.softKill_vol;
            if (evol == 0.0) {
                return -1;
            }
            double estep = this.softKill_vol_step;
            double[] abuffer = this.session.getAudioCache().getBuffer(end);
            Arrays.fill(abuffer, 0.0);
            int ret = this.getStream().mix(abuffer, start, end);
            int c = 0;
            while (c < channels) {
                evol = this.softKill_vol;
                int i = start + c;
                while (i < end) {
                    if ((evol -= estep) < 0.0) {
                        evol = 0.0;
                        break;
                    }
                    int n = i;
                    buffer[n] = buffer[n] + evol * abuffer[i];
                    i += channels;
                }
                ++c;
            }
            this.session.getAudioCache().returnBuffer(abuffer);
            this.softKill_vol = evol;
            return ret;
        }
        int ret = this.getStream().mix(buffer, start, end);
        return ret;
    }

    public int skip(int len) {
        return this.getStream().skip(len);
    }

    public void close() {
        this.reset();
        if (this.voci != null) {
            this.voci.close();
        }
    }
}

