/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.ArrayList;
import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioChannelGainInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable[] channels;

    public void calc() {
    }

    public AudioChannelGainInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        ArrayList<Variable> vars = new ArrayList<Variable>();
        int ii = 1;
        Variable var = parameters.getParameter(ii);
        while (var != null) {
            vars.add(var);
            var = parameters.getParameter(++ii);
        }
        this.channels = new Variable[vars.size()];
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i] = (Variable)vars.get(i);
            ++i;
        }
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        double[] ff;
        AudioStream inputstream;
        AudioStream[] inputstreams;
        boolean[] inputstreams_eof;
        int totalchannels;
        int chs;
        AudioCache audiocache;

        public FilterStreamInstance(AudioSession session) {
            this.ff = new double[AudioChannelGainInstance.this.channels.length];
            this.audiocache = session.getAudioCache();
            this.totalchannels = this.chs = session.getChannels();
            if (this.totalchannels > AudioChannelGainInstance.this.channels.length) {
                this.totalchannels = AudioChannelGainInstance.this.channels.length;
            }
            this.ff = new double[this.totalchannels];
            this.inputstreams = new AudioStream[this.totalchannels];
            this.inputstreams_eof = new boolean[this.totalchannels];
            int i = 0;
            while (i < this.totalchannels) {
                if (AudioEvents.getInstance((Variable)AudioChannelGainInstance.this.channels[i]).track.size() == 0) {
                    this.inputstreams_eof[i] = true;
                    this.inputstreams[i] = null;
                } else {
                    this.inputstreams_eof[i] = false;
                    this.inputstreams[i] = AudioEvents.openStream(AudioChannelGainInstance.this.channels[i], session.getMonoSession());
                }
                this.ff[i] = DoublePart.asDouble(AudioChannelGainInstance.this.channels[i]);
                ++i;
            }
            this.inputstream = AudioEvents.openStream(AudioChannelGainInstance.this.input, session);
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            int clen = len / this.chs;
            int c = 0;
            while (c < this.totalchannels) {
                int retc;
                if (!this.inputstreams_eof[c] && (retc = this.inputstreams[c].skip(clen)) == -1) {
                    this.inputstreams_eof[c] = true;
                }
                ++c;
            }
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.inputstream.replace(stockbuffer, start, end);
            int cstart = start / this.chs;
            int cend = end / this.chs;
            double[] stockbufferc = this.audiocache.getBuffer(cend);
            int c = 0;
            while (c < this.totalchannels) {
                if (!this.inputstreams_eof[c]) {
                    int retc = this.inputstreams[c].replace(stockbufferc, cstart, cend);
                    if (retc == -1) {
                        this.inputstreams_eof[c] = true;
                    } else {
                        double fff = this.ff[c];
                        Arrays.fill(stockbufferc, cstart + retc, cend, fff);
                        int ix = cstart;
                        int endret = start + ret;
                        int i = start + c;
                        while (i < endret) {
                            int n = i;
                            buffer[n] = buffer[n] + stockbufferc[ix] * stockbuffer[i];
                            ++ix;
                            i += this.chs;
                        }
                    }
                }
                if (this.inputstreams_eof[c]) {
                    double fff = this.ff[c];
                    int endret = start + ret;
                    int i = start + c;
                    while (i < endret) {
                        int n = i;
                        buffer[n] = buffer[n] + fff * stockbuffer[i];
                        i += this.chs;
                    }
                }
                ++c;
            }
            this.audiocache.returnBuffer(stockbufferc);
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret = this.inputstream.replace(buffer, start, end);
            int cstart = start / this.chs;
            int cend = end / this.chs;
            double[] stockbufferc = this.audiocache.getBuffer(cend);
            int c = 0;
            while (c < this.totalchannels) {
                if (!this.inputstreams_eof[c]) {
                    int retc = this.inputstreams[c].replace(stockbufferc, cstart, cend);
                    if (retc == -1) {
                        this.inputstreams_eof[c] = true;
                    } else {
                        double fff = this.ff[c];
                        Arrays.fill(stockbufferc, cstart + retc, cend, fff);
                        int ix = cstart;
                        int endret = start + ret;
                        int i = start + c;
                        while (i < endret) {
                            int n = i;
                            buffer[n] = buffer[n] * stockbufferc[ix];
                            ++ix;
                            i += this.chs;
                        }
                    }
                }
                if (this.inputstreams_eof[c]) {
                    double fff = this.ff[c];
                    int endret = start + ret;
                    int i = start + c;
                    while (i < endret) {
                        int n = i;
                        buffer[n] = buffer[n] * fff;
                        i += this.chs;
                    }
                }
                ++c;
            }
            this.audiocache.returnBuffer(stockbufferc);
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            int i = 0;
            while (i < this.inputstreams.length) {
                if (this.inputstreams[i] != null) {
                    this.inputstreams[i].close();
                }
                ++i;
            }
            this.inputstream.close();
        }
    }
}

