/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioDelayInstance
extends UnitInstanceAdapter {
    public Variable output;
    public Variable input;
    Variable transpose;
    double floatpos = 0.0;
    Variable answer = null;
    AudioEvents audioevents;
    public Map pevents = new HashMap();
    RListListenerAndRecv eventslistener = new RListListenerAndRecv();

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.pevents.clear();
        }
    }

    public AudioEvent processEvent(AudioEvent midievent) {
        AudioEvent newevent = new AudioEvent(midievent.start + this.floatpos, midievent.streamable);
        return newevent;
    }

    public void calc() {
        this.floatpos = DoublePart.asDouble(this.transpose);
        this.clear();
        this.answer = new Variable();
        this.audioevents = AudioEvents.getInstance(this.answer);
        List events = AudioEvents.getInstance(this.input).getObjects();
        for (AudioEvent element : events) {
            AudioEvent pelement = this.processEvent(element);
            if (pelement == null) continue;
            this.pevents.put(element, pelement);
            this.audioevents.addObject(pelement);
        }
        this.output.add(this.answer);
    }

    public ListPartListener getEventsListener() {
        return this.eventslistener;
    }

    public AudioDelayInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.transpose = parameters.getParameterWithDefault(1, "pos");
        this.input = parameters.getParameterWithDefault(2, "input");
        DoublePart.getInstance(this.transpose).addListener(this);
        AudioEvents.getInstance(this.input).addListener(this.getEventsListener());
        this.calc();
    }

    public void close() {
        DoublePart.getInstance(this.transpose).removeListener(this);
        AudioEvents.getInstance(this.input).removeListener(this.getEventsListener());
        this.clear();
    }

    class RListListenerAndRecv
    implements ListPartListener {
        RListListenerAndRecv() {
        }

        public void objectAdded(ListPart source, Object object) {
            AudioEvent element = (AudioEvent)object;
            AudioEvent pelement = AudioDelayInstance.this.processEvent(element);
            if (pelement != null) {
                AudioDelayInstance.this.pevents.put(element, pelement);
                AudioDelayInstance.this.audioevents.addObject(pelement);
            }
        }

        public void objectRemoved(ListPart source, Object object) {
            AudioEvents audioevents = AudioEvents.getInstance(AudioDelayInstance.this.answer);
            Object pelement = AudioDelayInstance.this.pevents.get(object);
            if (pelement != null) {
                audioevents.removeObject(pelement);
            }
        }

        public void objectsAdded(ListPart source, List objects) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                this.objectAdded(source, iterator.next());
            }
        }

        public void objectsRemoved(ListPart source, List objects) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                this.objectRemoved(source, iterator.next());
            }
        }

        public void close() {
        }
    }
}

