/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioDiffInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();

    public void calc() {
    }

    public AudioDiffInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault(1, "input");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioStream inputstream;
        double[] stockbuffer = null;
        double[] chbuff;
        int channels;

        public FilterStreamInstance(AudioSession session) {
            this.channels = session.getChannels();
            this.chbuff = new double[this.channels];
            Arrays.fill(this.chbuff, 0.0);
            this.inputstream = AudioEvents.openStream(AudioDiffInstance.this.input, session);
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[buffer.length];
            } else if (this.stockbuffer.length < buffer.length) {
                this.stockbuffer = new double[buffer.length];
            }
            int ret = this.inputstream.replace(this.stockbuffer, start, end);
            end = start + ret;
            int l_channels = this.channels;
            int c = 0;
            while (c < this.channels) {
                double l = this.chbuff[c];
                int i = start + c;
                while (i < end) {
                    double v = this.stockbuffer[i];
                    int n = i;
                    buffer[n] = buffer[n] + (l - v);
                    l = v;
                    i += l_channels;
                }
                this.chbuff[c] = l;
                ++c;
            }
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

