/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioDownMixInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable channelcount;

    public void calc() {
    }

    public AudioDownMixInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.channelcount = parameters.getParameterWithDefault(1, "channels");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioStream inputstream;
        double[] stockbuffer = null;
        int chs;
        int readchannels;

        public FilterStreamInstance(AudioSession session) {
            this.chs = session.getChannels();
            this.readchannels = (int)DoublePart.asDouble(AudioDownMixInstance.this.channelcount);
            if (this.readchannels == 0) {
                this.readchannels = 1;
            }
            this.inputstream = AudioEvents.openStream(AudioDownMixInstance.this.input, session.newSession(session.getRate(), this.readchannels));
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(this.readchannels * (len / this.chs));
            if (ret == -1) {
                return -1;
            }
            return len;
        }

        public int mix(double[] buffer, int start, int end) {
            int cstart = this.readchannels * (start / this.chs);
            int cend = this.readchannels * (end / this.chs);
            if (this.stockbuffer == null) {
                this.stockbuffer = new double[this.readchannels * (buffer.length / this.chs)];
            } else if (this.stockbuffer.length < this.readchannels * (buffer.length / this.chs)) {
                this.stockbuffer = new double[this.readchannels * (buffer.length / this.chs)];
            }
            int ret = this.inputstream.replace(this.stockbuffer, cstart, cend);
            if (ret != -1) {
                int c = 0;
                while (c < this.readchannels) {
                    int ix = start;
                    int retend = cstart + ret;
                    int i = cstart + c;
                    while (i < retend) {
                        int n = ix;
                        buffer[n] = buffer[n] + this.stockbuffer[i];
                        ix += this.chs;
                        i += this.readchannels;
                    }
                    ++c;
                }
            }
            if (ret == -1) {
                return -1;
            }
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

