/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.FFT;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioIFFTInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable buffersize = new Variable();

    public void calc() {
    }

    public AudioIFFTInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.buffersize = parameters.getParameterWithDefault(1, "buffersize");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioStream inputstream;
        AudioSession session;
        double[] stockbuffer = null;
        int buffersize_i;
        int fftrover = 0;
        double[] fftbuffer;
        FFT fft;
        boolean inputstream_eof = false;

        public FilterStreamInstance(AudioSession session) {
            this.session = session;
            this.buffersize_i = (int)DoublePart.asDouble(AudioIFFTInstance.this.buffersize);
            this.fftbuffer = session.getAudioCache().getBuffer(this.buffersize_i * 2);
            this.fft = new FFT(this.buffersize_i);
            this.inputstream = AudioEvents.openStream(AudioIFFTInstance.this.input, session.newSession(session.getRate(), 2));
            this.processFFT();
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public void processFFT() {
            if (this.inputstream_eof) {
                Arrays.fill(this.fftbuffer, 0, this.buffersize_i * 2, 0.0);
                return;
            }
            double[] buffer = this.session.getAudioCache().getBuffer(4096);
            int i = 0;
            while (i < this.buffersize_i * 2) {
                int ret;
                int start = i;
                int end = i + 4096;
                if (end > this.buffersize_i * 2) {
                    end = this.buffersize_i * 2;
                }
                if ((ret = this.inputstream.replace(buffer, 0, end - start)) == -1) {
                    Arrays.fill(this.fftbuffer, start, this.buffersize_i * 2, 0.0);
                    this.inputstream_eof = true;
                    break;
                }
                int k = start;
                int j = 0;
                while (j < ret) {
                    this.fftbuffer[k] = buffer[j];
                    ++j;
                    ++k;
                }
                Arrays.fill(this.fftbuffer, start + ret, end, 0.0);
                i += 4096;
            }
            this.session.getAudioCache().returnBuffer(buffer);
            this.fft.calc(this.fftbuffer, 1);
        }

        public int mix(double[] buffer, int start, int end) {
            if (this.inputstream_eof) {
                return -1;
            }
            int rover = this.fftrover;
            int buffersize_i = this.buffersize_i;
            int buffersize_i2 = buffersize_i * 2;
            double[] fftbuffer = this.fftbuffer;
            int i = start;
            while (i < end) {
                int n = i++;
                buffer[n] = buffer[n] + fftbuffer[rover];
                rover = (rover + 2) % buffersize_i2;
            }
            this.fftrover = rover;
            return end - start;
        }

        public int replace(double[] buffer, int start, int end) {
            if (this.inputstream_eof) {
                return -1;
            }
            int rover = this.fftrover;
            int buffersize_i = this.buffersize_i;
            int buffersize_i2 = buffersize_i * 2;
            double[] fftbuffer = this.fftbuffer;
            int i = start;
            while (i < end) {
                buffer[i] = fftbuffer[rover];
                rover = (rover + 2) % buffersize_i2;
                ++i;
            }
            this.fftrover = rover;
            return end - start;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
            this.session.getAudioCache().returnBuffer(this.fftbuffer);
        }
    }
}

