/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.PitchShift;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioPitchBendInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable pitch;
    Variable fpitch;
    Variable fftFrameSize;
    Variable osamp;

    public void calc() {
    }

    public AudioPitchBendInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.pitch = parameters.getParameterWithDefault(1, "pitch");
        this.fpitch = parameters.getParameter(2, "format");
        if (this.fpitch == null) {
            this.fpitch = this.pitch;
        }
        this.fftFrameSize = parameters.getParameterWithDefault(3, "fftFrameSize");
        this.osamp = parameters.getParameterWithDefault(4, "osamp");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(AudioEvents.openStream(this.input, session), session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream inputstream;
        PitchShift[] pitchshift;
        int channels;
        AudioCache audiocache;
        AudioSession session;
        boolean inputstream2_eof = false;
        AudioFallBackStream inputstream2;
        boolean inputstream3_eof = false;
        AudioFallBackStream inputstream3;

        public FilterStreamInstance(AudioStream inputstream, AudioSession session) {
            this.session = session;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            int i_fftFrameSize = (int)DoublePart.asDouble(AudioPitchBendInstance.this.fftFrameSize);
            int i_osamp = (int)DoublePart.asDouble(AudioPitchBendInstance.this.osamp);
            if (i_fftFrameSize == 0) {
                i_fftFrameSize = 2048;
            }
            if (i_osamp == 0) {
                i_osamp = 4;
            }
            this.pitchshift = new PitchShift[this.channels];
            int i = 0;
            while (i < this.channels) {
                this.pitchshift[i] = new PitchShift(i_fftFrameSize, i_osamp, session.getRate());
                ++i;
            }
            this.inputstream = new AudioFallBackStream(inputstream);
            if (AudioEvents.getInstance((Variable)AudioPitchBendInstance.this.pitch).track.size() == 0) {
                this.inputstream2_eof = true;
            } else {
                this.inputstream2 = new AudioFallBackStream(AudioEvents.openStream(AudioPitchBendInstance.this.pitch, session.getMonoSession()));
            }
            if (AudioEvents.getInstance((Variable)AudioPitchBendInstance.this.fpitch).track.size() == 0) {
                this.inputstream3_eof = true;
            } else {
                this.inputstream3 = new AudioFallBackStream(AudioEvents.openStream(AudioPitchBendInstance.this.fpitch, session.getMonoSession()));
            }
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(stockbuffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            int i = start;
            while (i < start + cret) {
                int n = i;
                buffer[n] = buffer[n] + stockbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int cret;
            int ret2;
            double[] stockbuffer2 = null;
            double[] stockbuffer3 = null;
            int ret = this.inputstream.replace(buffer, start, end);
            int cstart = start / this.channels;
            int cend = end / this.channels;
            double d_pitch = DoublePart.asDouble(AudioPitchBendInstance.this.pitch);
            double d_fpitch = DoublePart.asDouble(AudioPitchBendInstance.this.fpitch);
            if (!this.inputstream2_eof) {
                stockbuffer2 = new double[1];
                if (this.inputstream2.isStatic(stockbuffer2, cend - cstart) == -1) {
                    stockbuffer2 = this.audiocache.getBuffer(cend);
                    ret2 = this.inputstream2.replace(stockbuffer2, cstart, cend);
                    if (ret2 == -1) {
                        this.inputstream2_eof = true;
                        this.audiocache.returnBuffer(stockbuffer2);
                        stockbuffer2 = null;
                    } else {
                        Arrays.fill(stockbuffer2, cstart + ret2, cend, DoublePart.asDouble(AudioPitchBendInstance.this.pitch));
                    }
                } else {
                    d_pitch = stockbuffer2[0];
                    stockbuffer2 = null;
                }
            }
            if (!this.inputstream3_eof) {
                stockbuffer3 = new double[1];
                if (this.inputstream3.isStatic(stockbuffer3, cend - cstart) == -1) {
                    stockbuffer3 = this.audiocache.getBuffer(cend);
                    ret2 = this.inputstream3.replace(stockbuffer3, cstart, cend);
                    if (ret2 == -1) {
                        this.inputstream3_eof = true;
                        this.audiocache.returnBuffer(stockbuffer3);
                        stockbuffer3 = null;
                    } else {
                        Arrays.fill(stockbuffer3, cstart + ret2, cend, DoublePart.asDouble(AudioPitchBendInstance.this.fpitch));
                    }
                } else {
                    d_fpitch = stockbuffer3[0];
                    stockbuffer3 = null;
                }
            }
            if ((cret = ret) == -1) {
                cret = 0;
            }
            Arrays.fill(buffer, start + cret, end, 0.0);
            int i = 0;
            while (i < this.channels) {
                this.pitchshift[i].smbPitchShift(d_fpitch, stockbuffer3, d_pitch, stockbuffer2, cstart, start + i, end, this.channels, buffer, buffer);
                ++i;
            }
            if (stockbuffer2 != null) {
                this.audiocache.returnBuffer(stockbuffer2);
            }
            if (stockbuffer3 != null) {
                this.audiocache.returnBuffer(stockbuffer3);
            }
            if (ret == -1) {
                i = start;
                while (i < end) {
                    if (buffer[i] > 1.0E-10) {
                        return end - start;
                    }
                    ++i;
                }
                return -1;
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
            if (this.inputstream2 != null) {
                this.inputstream2.close();
            }
            if (this.inputstream3 != null) {
                this.inputstream3.close();
            }
        }
    }
}

