/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.FFT;
import rasmus.interpreter.sampled.util.PitchShift;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioTimeStretchInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable stretch;
    Variable fftFrameSize;
    Variable osamp;

    public void calc() {
    }

    public AudioTimeStretchInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.stretch = parameters.getParameterWithDefault(1, "amount");
        this.fftFrameSize = parameters.getParameterWithDefault(2, "fftFrameSize");
        this.osamp = parameters.getParameterWithDefault(3, "osamp");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(AudioEvents.openStream(this.input, session.newSession()), session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream inputstream;
        PitchShift[] pitchshift;
        int channels;
        AudioCache audiocache;
        AudioSession session;
        FFT fft;
        int i_fftFrameSize;
        int i_osamp;
        int i_stepSize;
        boolean is_eof = false;
        double[] window;
        double[] readbuffer;
        double[] outputbuffer;
        double[][] fftbuffer1;
        double[][] fftbuffer2;
        double[][] fftbufferT;
        double[][] fftbufferPhaseReal;
        double[][] fftbufferPhaseImag;
        double readpos = 0.0;
        int filterreadpos = 0;
        boolean inputstream2_eof = false;
        AudioFallBackStream inputstream2;
        double d_stretch = 1.0;
        boolean firsttime = false;
        boolean firstone = true;

        public FilterStreamInstance(AudioStream inputstream, AudioSession session) {
            this.session = session;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            this.d_stretch = DoublePart.asDouble(AudioTimeStretchInstance.this.stretch);
            this.i_fftFrameSize = (int)DoublePart.asDouble(AudioTimeStretchInstance.this.fftFrameSize);
            this.i_osamp = (int)DoublePart.asDouble(AudioTimeStretchInstance.this.osamp);
            if (this.i_fftFrameSize == 0) {
                this.i_fftFrameSize = 2048;
            }
            if (this.i_osamp == 0) {
                this.i_osamp = 4;
            }
            this.i_stepSize = this.i_fftFrameSize / this.i_osamp;
            this.fft = new FFT(this.i_fftFrameSize);
            this.window = this.fft.wHanning();
            this.inputstream = new AudioFallBackStream(inputstream);
            if (AudioEvents.getInstance((Variable)AudioTimeStretchInstance.this.stretch).track.size() == 0) {
                this.inputstream2_eof = true;
            } else {
                this.inputstream2 = new AudioFallBackStream(AudioEvents.openStream(AudioTimeStretchInstance.this.stretch, session.getMonoSession()));
            }
            this.readbuffer = new double[this.i_fftFrameSize * this.channels];
            this.outputbuffer = new double[this.i_fftFrameSize * this.channels];
            this.fftbuffer1 = new double[this.channels][this.i_fftFrameSize];
            this.fftbuffer2 = new double[this.channels][this.i_fftFrameSize];
            this.fftbufferT = new double[this.channels][this.i_fftFrameSize];
            this.fftbufferPhaseReal = new double[this.channels][this.i_fftFrameSize];
            this.fftbufferPhaseImag = new double[this.channels][this.i_fftFrameSize];
            int c = 0;
            while (c < this.channels) {
                Arrays.fill(this.fftbufferPhaseReal[c], 1.0);
                ++c;
            }
            c = 0;
            while (c < this.channels) {
                Arrays.fill(this.fftbufferPhaseImag[c], 0.0);
                ++c;
            }
        }

        public void readFFTBuffer(double[][] fftbuffer) {
            int ret;
            if (this.is_eof) {
                int c = 0;
                while (c < this.channels) {
                    Arrays.fill(fftbuffer[c], 0.0);
                    ++c;
                }
                return;
            }
            double[] stockbuffer = this.readbuffer;
            if (this.firstone) {
                ret = this.inputstream.replace(stockbuffer, 0, this.i_fftFrameSize * this.channels);
                if (ret != -1) {
                    int i = ret;
                    while (i < this.i_fftFrameSize * this.channels) {
                        stockbuffer[i] = 0.0;
                        ++i;
                    }
                }
                this.firstone = false;
            } else {
                int c_stepsize = this.i_stepSize * this.channels;
                int i = 0;
                while (i < (this.i_fftFrameSize - this.i_stepSize) * this.channels) {
                    stockbuffer[i] = stockbuffer[i + c_stepsize];
                    ++i;
                }
                ret = this.inputstream.replace(stockbuffer, (this.i_fftFrameSize - this.i_stepSize) * this.channels, this.i_fftFrameSize * this.channels);
                if (ret != -1 && ret != this.i_stepSize * this.channels) {
                    int offset = (this.i_fftFrameSize - this.i_stepSize) * this.channels;
                    int i2 = offset + ret;
                    while (i2 < this.i_fftFrameSize * this.channels) {
                        stockbuffer[i2] = 0.0;
                        ++i2;
                    }
                }
            }
            if (ret == -1) {
                int c = 0;
                while (c < this.channels) {
                    Arrays.fill(fftbuffer[c], 0.0);
                    ++c;
                }
                this.is_eof = true;
                return;
            }
            int channels = this.channels;
            int c = 0;
            while (c < channels) {
                double[] cfftbuffer = fftbuffer[c];
                int j = 0;
                while (j < this.i_fftFrameSize) {
                    cfftbuffer[j] = stockbuffer[j * channels + c] * this.window[j];
                    ++j;
                }
                this.fft.calcReal(cfftbuffer, -1);
                ++c;
            }
        }

        public void skipFFTBuffer() {
            int ret;
            if (this.is_eof) {
                return;
            }
            double[] stockbuffer = this.readbuffer;
            if (this.firstone) {
                ret = this.inputstream.replace(stockbuffer, 0, this.i_fftFrameSize * this.channels);
                if (ret != -1) {
                    int i = ret;
                    while (i < this.i_fftFrameSize * this.channels) {
                        stockbuffer[i] = 0.0;
                        ++i;
                    }
                }
                this.firstone = false;
            } else {
                int c_stepsize = this.i_stepSize * this.channels;
                int i = 0;
                while (i < (this.i_fftFrameSize - this.i_stepSize) * this.channels) {
                    stockbuffer[i] = stockbuffer[i + c_stepsize];
                    ++i;
                }
                ret = this.inputstream.replace(stockbuffer, (this.i_fftFrameSize - this.i_stepSize) * this.channels, this.i_fftFrameSize * this.channels);
                if (ret != -1 && ret != this.i_stepSize * this.channels) {
                    int offset = (this.i_fftFrameSize - this.i_stepSize) * this.channels;
                    int i2 = offset + ret;
                    while (i2 < this.i_fftFrameSize * this.channels) {
                        stockbuffer[i2] = 0.0;
                        ++i2;
                    }
                }
            }
            if (ret == -1) {
                this.is_eof = true;
                return;
            }
        }

        public void readInterpoledBuffer(double[][] fftbuffer) {
            while (this.readpos >= 3.0) {
                this.skipFFTBuffer();
                this.readpos -= 1.0;
            }
            while (this.readpos >= 1.0) {
                double[][] tmp = this.fftbuffer1;
                this.fftbuffer1 = this.fftbuffer2;
                this.fftbuffer2 = tmp;
                this.readFFTBuffer(this.fftbuffer2);
                this.readpos -= 1.0;
            }
            if (this.d_stretch == 0.0) {
                this.d_stretch = 1.0;
            }
            double r = 1.0 / this.d_stretch;
            this.readpos += r;
            int c = 0;
            while (c < this.channels) {
                double[] cfftbuffer = fftbuffer[c];
                double[] cfftbuffer1 = this.fftbuffer1[c];
                double[] cfftbuffer2 = this.fftbuffer2[c];
                double[] cPhaseReal = this.fftbufferPhaseReal[c];
                double[] cPhaseImag = this.fftbufferPhaseImag[c];
                int j = 0;
                while (j < this.i_fftFrameSize) {
                    double phase2_imag;
                    double phase2_real;
                    double phase1_imag;
                    double phase1_real;
                    double real1 = cfftbuffer1[j];
                    double imag1 = cfftbuffer1[j + 1];
                    double real2 = cfftbuffer2[j];
                    double imag2 = cfftbuffer2[j + 1];
                    double phase_real = cPhaseReal[j];
                    double phase_imag = cPhaseImag[j];
                    double magn1 = Math.sqrt(real1 * real1 + imag1 * imag1);
                    double magn2 = Math.sqrt(real2 * real2 + imag2 * imag2);
                    double out_magn = magn1 * (1.0 - this.readpos) + magn2 * this.readpos;
                    cfftbuffer[j] = phase_real * out_magn;
                    cfftbuffer[j + 1] = phase_imag * out_magn;
                    if (magn1 < 1.0E-7) {
                        phase1_real = 1.0;
                        phase1_imag = 0.0;
                    } else {
                        double imagn1 = 1.0 / magn1;
                        phase1_real = real1 * imagn1;
                        phase1_imag = imag1 * imagn1;
                    }
                    if (magn2 < 1.0E-7) {
                        phase2_real = 1.0;
                        phase2_imag = 0.0;
                    } else {
                        double imagn2 = 1.0 / magn2;
                        phase2_real = real2 * imagn2;
                        phase2_imag = imag2 * imagn2;
                    }
                    double phaseAdv_real = phase2_real * phase1_real + phase1_imag * phase2_imag;
                    double phaseAdv_imag = phase2_imag * phase1_real - phase1_imag * phase2_real;
                    cPhaseReal[j] = phase_real * phaseAdv_real - phaseAdv_imag * phase_imag;
                    cPhaseImag[j] = phase_imag * phaseAdv_real + phaseAdv_imag * phase_real;
                    j += 2;
                }
                ++c;
            }
        }

        public void readIFFT() {
            double[] stockbuffer = this.outputbuffer;
            int i = 0;
            while (i < (this.i_fftFrameSize - this.i_stepSize) * this.channels) {
                stockbuffer[i] = stockbuffer[i + this.i_stepSize * this.channels];
                ++i;
            }
            i = (this.i_fftFrameSize - this.i_stepSize) * this.channels;
            while (i < this.i_fftFrameSize * this.channels) {
                stockbuffer[i] = 0.0;
                ++i;
            }
            this.readInterpoledBuffer(this.fftbufferT);
            int channels = this.channels;
            double scale = 1.0 / (double)this.i_fftFrameSize * (8.0 / (3.0 * (double)this.i_osamp));
            int c = 0;
            while (c < channels) {
                double[] cfftbuffer = this.fftbufferT[c];
                this.fft.calcReal(cfftbuffer, 1);
                int k = c;
                int j = 0;
                while (j < this.i_fftFrameSize) {
                    int n = k;
                    stockbuffer[n] = stockbuffer[n] + cfftbuffer[j] * this.window[j] * scale;
                    k += channels;
                    ++j;
                }
                ++c;
            }
        }

        public int replace(double[] buffer, int start, int end) {
            double[] stockbuffer2 = null;
            this.d_stretch = DoublePart.asDouble(AudioTimeStretchInstance.this.stretch);
            if (!this.inputstream2_eof) {
                stockbuffer2 = new double[1];
                int cend = end / this.channels;
                int cstart = start / this.channels;
                if (this.inputstream2.isStatic(stockbuffer2, cend - cstart) == -1) {
                    stockbuffer2 = this.audiocache.getBuffer(cend);
                    int ret2 = this.inputstream2.replace(stockbuffer2, cstart, cend);
                    if (ret2 == -1) {
                        this.inputstream2_eof = true;
                        this.audiocache.returnBuffer(stockbuffer2);
                        stockbuffer2 = null;
                    } else {
                        Arrays.fill(stockbuffer2, cstart + ret2, cend, DoublePart.asDouble(AudioTimeStretchInstance.this.stretch));
                        this.d_stretch = stockbuffer2[0];
                    }
                } else {
                    this.d_stretch = stockbuffer2[0];
                    stockbuffer2 = null;
                }
            }
            if (this.firsttime) {
                this.readFFTBuffer(this.fftbuffer1);
                this.readFFTBuffer(this.fftbuffer2);
                this.readIFFT();
                this.firsttime = false;
            }
            int fx = this.filterreadpos;
            int c_stepsize = this.i_stepSize * this.channels;
            int i = start;
            while (i < end) {
                buffer[i] = this.outputbuffer[fx];
                if (++fx == c_stepsize) {
                    fx = 0;
                    this.readIFFT();
                }
                ++i;
            }
            this.filterreadpos = fx;
            if (this.is_eof) {
                return -1;
            }
            return end - start;
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(stockbuffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            int i = start;
            while (i < start + cret) {
                int n = i;
                buffer[n] = buffer[n] + stockbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

