/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.modifiers;

import java.util.Arrays;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.util.Vocoder;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class AudioVocoderInstance
extends UnitInstanceAdapter
implements AudioStreamable {
    public Variable output;
    public Variable input;
    Variable answer = new Variable();
    Variable modulator;
    Variable fftFrameSize;
    Variable vocoderSize;
    Variable osamp;

    public void calc() {
    }

    public AudioVocoderInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.modulator = parameters.getParameterWithDefault(1, "modulator");
        this.vocoderSize = parameters.getParameterWithDefault(2, "vocoderSize");
        this.fftFrameSize = parameters.getParameterWithDefault(3, "fftFrameSize");
        this.osamp = parameters.getParameterWithDefault(4, "osamp");
        this.answer = AudioEvents.asVariable(new AudioEvent(0.0, this));
        this.output.add(this.answer);
    }

    public void close() {
        this.output.remove(this.answer);
    }

    public AudioStream openStream(AudioSession session) {
        return new FilterStreamInstance(AudioEvents.openStream(this.input, session), session);
    }

    class FilterStreamInstance
    implements AudioStream {
        AudioFallBackStream inputstream;
        Vocoder[] vocoder;
        int channels;
        AudioCache audiocache;
        AudioSession session;
        boolean inputstream2_eof = false;
        AudioFallBackStream inputstream2;

        public FilterStreamInstance(AudioStream inputstream, AudioSession session) {
            int i_vocoderSize;
            this.session = session;
            this.audiocache = session.getAudioCache();
            this.channels = session.getChannels();
            int i_fftFrameSize = (int)DoublePart.asDouble(AudioVocoderInstance.this.fftFrameSize);
            int i_osamp = (int)DoublePart.asDouble(AudioVocoderInstance.this.osamp);
            if (i_fftFrameSize == 0) {
                i_fftFrameSize = 4096;
            }
            if (i_osamp == 0) {
                i_osamp = 4;
            }
            if ((i_vocoderSize = (int)DoublePart.asDouble(AudioVocoderInstance.this.vocoderSize)) == 0) {
                i_vocoderSize = 750;
            }
            this.vocoder = new Vocoder[this.channels];
            int i = 0;
            while (i < this.channels) {
                this.vocoder[i] = new Vocoder(i_fftFrameSize, i_osamp, session.getRate(), i_vocoderSize);
                ++i;
            }
            this.inputstream = new AudioFallBackStream(inputstream);
            if (AudioEvents.getInstance((Variable)AudioVocoderInstance.this.modulator).track.size() == 0) {
                this.inputstream2_eof = true;
            } else {
                this.inputstream2 = new AudioFallBackStream(AudioEvents.openStream(AudioVocoderInstance.this.modulator, session));
            }
        }

        public int mix(double[] buffer, int start, int end) {
            double[] stockbuffer = this.audiocache.getBuffer(end);
            int ret = this.replace(stockbuffer, start, end);
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            int i = start;
            while (i < start + cret) {
                int n = i;
                buffer[n] = buffer[n] + stockbuffer[i];
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer);
            return ret;
        }

        public int skip(int len) {
            int ret = this.inputstream.skip(len);
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            double[] stockbuffer2 = this.audiocache.getBuffer(end);
            int ret = this.inputstream.replace(buffer, start, end);
            if (!this.inputstream2_eof) {
                int ret2 = this.inputstream2.replace(stockbuffer2, start, end);
                if (ret2 == -1) {
                    this.inputstream2_eof = true;
                    Arrays.fill(stockbuffer2, 0.0);
                } else {
                    Arrays.fill(stockbuffer2, start + ret2, end, DoublePart.asDouble(AudioVocoderInstance.this.modulator));
                }
            } else {
                Arrays.fill(stockbuffer2, 0.0);
            }
            int cret = ret;
            if (cret == -1) {
                cret = 0;
            }
            Arrays.fill(buffer, start + cret, end, 0.0);
            int i = 0;
            while (i < this.channels) {
                this.vocoder[i].process(start + i, end, this.channels, buffer, stockbuffer2, buffer);
                ++i;
            }
            this.audiocache.returnBuffer(stockbuffer2);
            if (ret == -1) {
                i = start;
                while (i < end) {
                    if (buffer[i] > 1.0E-10) {
                        return end - start;
                    }
                    ++i;
                }
                return -1;
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            return -1;
        }

        public void close() {
            this.inputstream.close();
        }
    }
}

