/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import rasmus.interpreter.sampled.AudioStream;

public class AudioInputStreamConverter
extends InputStream {
    AudioStream stream;
    int sampleSizeInBits;
    int sampleSizeInBytes;
    boolean signed;
    boolean bigEndian;
    double[] buffer = null;

    public AudioInputStreamConverter(AudioStream stream, int sampleSizeInBits, boolean signed, boolean bigEndian) {
        this.stream = stream;
        this.sampleSizeInBits = sampleSizeInBits;
        this.signed = signed;
        this.bigEndian = bigEndian;
        this.sampleSizeInBytes = sampleSizeInBits / 8;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        block24: {
            int dlen;
            block25: {
                block27: {
                    block26: {
                        block23: {
                            dlen = len / this.sampleSizeInBytes;
                            if (this.buffer == null || this.buffer.length < len) {
                                this.buffer = new double[dlen];
                            }
                            if ((ret = this.stream.isStatic(this.buffer, dlen)) != -1) {
                                double val = this.buffer[0];
                                Arrays.fill(this.buffer, 0, dlen, val);
                            } else {
                                ret = this.stream.replace(this.buffer, 0, dlen);
                                if (ret == -1) {
                                    return -1;
                                }
                            }
                            int k = 0;
                            while (k < dlen) {
                                double fvalue = this.buffer[k];
                                if (fvalue > 1.0) {
                                    this.buffer[k] = 1.0;
                                } else if (fvalue < -1.0) {
                                    this.buffer[k] = -1.0;
                                }
                                ++k;
                            }
                            int z = off;
                            if (this.sampleSizeInBytes != 1) break block23;
                            if (this.signed) {
                                int k2 = 0;
                                while (k2 < dlen) {
                                    double fvalue = this.buffer[k2];
                                    int valueL = (int)(fvalue * 128.0);
                                    b[z] = (byte)valueL;
                                    ++z;
                                    ++k2;
                                }
                            } else {
                                int k3 = 0;
                                while (k3 < dlen) {
                                    double fvalue = this.buffer[k3];
                                    int valueL = (int)(fvalue * 128.0);
                                    b[z] = (byte)(valueL & 0xFF);
                                    ++z;
                                    ++k3;
                                }
                            }
                            break block24;
                        }
                        if (!this.bigEndian) break block25;
                        if (this.sampleSizeInBytes != 2) break block26;
                        int k = 0;
                        while (k < dlen) {
                            double fvalue = this.buffer[k];
                            int valueL = (int)(fvalue * 32768.0);
                            b[z + 1] = (byte)valueL;
                            b[z] = (byte)(valueL >>> 8);
                            z += 2;
                            ++k;
                        }
                        break block24;
                    }
                    if (this.sampleSizeInBytes != 3) break block27;
                    int k = 0;
                    while (k < dlen) {
                        double fvalue = this.buffer[k];
                        int valueL = (int)(fvalue * 8388608.0);
                        b[z + 2] = (byte)valueL;
                        b[z + 1] = (byte)(valueL >>> 8);
                        b[z] = (byte)(valueL >>> 16);
                        z += 3;
                        ++k;
                    }
                    break block24;
                }
                if (this.sampleSizeInBytes != 4) break block24;
                int k = 0;
                while (k < dlen) {
                    double fvalue = this.buffer[k];
                    int valueL = (int)(fvalue * 2.147483648E9);
                    b[z + 2] = (byte)valueL;
                    b[z + 1] = (byte)(valueL >>> 8);
                    b[z] = (byte)(valueL >>> 16);
                    z += 3;
                    ++k;
                }
                break block24;
            }
            if (this.sampleSizeInBytes == 2) {
                int k = 0;
                while (k < dlen) {
                    double fvalue = this.buffer[k];
                    int valueL = (int)(fvalue * 32768.0);
                    b[z] = (byte)valueL;
                    b[z + 1] = (byte)(valueL >>> 8);
                    z += 2;
                    ++k;
                }
            } else if (this.sampleSizeInBytes == 3) {
                int k = 0;
                while (k < dlen) {
                    double fvalue = this.buffer[k];
                    int valueL = (int)(fvalue * 8388608.0);
                    b[z] = (byte)valueL;
                    b[z + 1] = (byte)(valueL >>> 8);
                    b[z + 2] = (byte)(valueL >>> 16);
                    z += 3;
                    ++k;
                }
            } else if (this.sampleSizeInBytes == 4) {
                int k = 0;
                while (k < dlen) {
                    double fvalue = this.buffer[k];
                    int valueL = (int)(fvalue * 2.147483648E9);
                    b[z] = (byte)valueL;
                    b[z + 1] = (byte)(valueL >>> 8);
                    b[z + 2] = (byte)(valueL >>> 16);
                    b[z + 3] = (byte)(valueL >>> 24);
                    z += 4;
                    ++k;
                }
            }
        }
        return ret * this.sampleSizeInBytes;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long ret = this.stream.skip((int)(n / (long)this.sampleSizeInBytes));
        if (ret == -1L) {
            return -1L;
        }
        return ret * (long)this.sampleSizeInBytes;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int ret = this.read(b);
        if (ret == -1) {
            return -1;
        }
        return b[0];
    }
}

