/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.AudioCache;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.util.WaveUtils;

public class AudioStreamConverter
implements AudioStream {
    AudioSession session = null;
    AudioSession sourcesession = null;
    AudioSession convertsession = null;
    AudioStream sourcestream = null;
    AudioCache audiocache = null;
    AudioStream currenttargetstream = null;

    public AudioStreamConverter(AudioSession session) {
        this.session = session;
        this.audiocache = session.getAudioCache();
    }

    private void setSourceSession(AudioSession targetsession) {
        if (this.sourcesession != targetsession) {
            this.sourcesession = targetsession;
            if (targetsession == null) {
                this.convertsession = null;
                return;
            }
            this.convertsession = this.session.newSession(targetsession.getRate(), targetsession.getChannels());
        }
    }

    private void setSourceStream(AudioStream targetstream) {
        if (targetstream != this.currenttargetstream) {
            if (targetstream == null) {
                this.currenttargetstream = null;
                this.sourcestream = null;
                return;
            }
            this.currenttargetstream = targetstream;
            this.sourcestream = this.sourcesession.getRate() != this.session.getRate() ? new WaveUtils.ResampleStream(targetstream, this.session.getRate() / this.sourcesession.getRate(), this.sourcesession.getChannels()) : targetstream;
        }
    }

    public void setSource(AudioSession targetsession, AudioStream targetstream) {
        this.setSourceSession(targetsession);
        this.setSourceStream(targetstream);
    }

    public AudioSession getSession() {
        return this.convertsession;
    }

    private int convertToSource(int pos) {
        if (pos == -1) {
            return -1;
        }
        pos /= this.session.getChannels();
        return pos *= this.sourcesession.getChannels();
    }

    private int convertFromSource(int pos) {
        if (pos == -1) {
            return -1;
        }
        pos /= this.sourcesession.getChannels();
        return pos *= this.session.getChannels();
    }

    private boolean isConvertNeeded() {
        return this.sourcesession.getChannels() != this.session.getChannels();
    }

    public int mix(double[] buffer, int start, int end) {
        if (!this.isConvertNeeded()) {
            return this.sourcestream.mix(buffer, start, end);
        }
        int len = end - start;
        int clen = this.convertToSource(len);
        double[] readbuffer = this.audiocache.getBuffer(clen);
        int cret = this.sourcestream.replace(readbuffer, 0, clen);
        if (cret == -1) {
            return -1;
        }
        if (cret != clen) {
            Arrays.fill(readbuffer, cret, clen, 0.0);
        }
        int session_channels = this.session.getChannels();
        int sourcesession_channels = this.sourcesession.getChannels();
        if (session_channels == 1) {
            int c = 0;
            while (c < sourcesession_channels) {
                int j = c;
                int i = start;
                while (i < end) {
                    int n = i++;
                    buffer[n] = buffer[n] + readbuffer[j];
                    j += sourcesession_channels;
                }
                ++c;
            }
            this.audiocache.returnBuffer(readbuffer);
            return len;
        }
        int c = 0;
        while (c < session_channels) {
            int j = c;
            if (j >= sourcesession_channels) {
                j = sourcesession_channels - 1;
            }
            int i = start + c;
            while (i < end) {
                int n = i;
                buffer[n] = buffer[n] + readbuffer[j];
                j += sourcesession_channels;
                i += session_channels;
            }
            ++c;
        }
        this.audiocache.returnBuffer(readbuffer);
        return len;
    }

    public int replace(double[] buffer, int start, int end) {
        if (!this.isConvertNeeded()) {
            return this.sourcestream.replace(buffer, start, end);
        }
        Arrays.fill(buffer, start, end, 0.0);
        return this.mix(buffer, start, end);
    }

    public int isStatic(double[] buffer, int len) {
        if (!this.isConvertNeeded()) {
            return this.sourcestream.isStatic(buffer, len);
        }
        return this.convertFromSource(this.sourcestream.isStatic(buffer, this.convertToSource(len)));
    }

    public int skip(int len) {
        if (!this.isConvertNeeded()) {
            return this.sourcestream.skip(len);
        }
        return this.convertFromSource(this.sourcestream.skip(this.convertToSource(len)));
    }

    public void close() {
        this.sourcestream.close();
    }
}

