/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;
import rasmus.interpreter.sampled.util.FFT;

public class FFTConvolution {
    FFT fft;
    int convFrameSize;
    int convFrameSize2;
    int fftFrameSize;
    int fftFrameSize2;
    double fftGain;
    double[][] convBuffers;
    double[][] smplBuffers;
    int smplBufferPos = 0;
    int convBufferCount;
    double[] inputBuffer;
    double[] outputBuffer;
    double[] outputBuffer2;
    int bufferPos = 0;

    public FFTConvolution(double[] convolutionbuffer, int fftFrameSize) {
        this.fft = new FFT(fftFrameSize);
        this.fftFrameSize = fftFrameSize;
        this.fftFrameSize2 = fftFrameSize * 2;
        this.convFrameSize = fftFrameSize / 2;
        this.convFrameSize2 = fftFrameSize;
        this.fftGain = 2.0 / (double)fftFrameSize;
        this.inputBuffer = new double[fftFrameSize];
        this.outputBuffer = new double[fftFrameSize];
        this.outputBuffer2 = new double[fftFrameSize];
        this.convBufferCount = convolutionbuffer.length / this.convFrameSize;
        if (convolutionbuffer.length % this.convFrameSize != 0) {
            ++this.convBufferCount;
        }
        this.convBuffers = new double[this.convBufferCount][];
        this.smplBuffers = new double[this.convBufferCount][];
        int pos = 0;
        int i = 0;
        while (i < this.convBufferCount) {
            double[] convBuffer = new double[fftFrameSize];
            this.smplBuffers[i] = new double[fftFrameSize];
            this.convBuffers[i] = convBuffer;
            int end = pos + this.convFrameSize;
            if (end > convolutionbuffer.length) {
                end = convolutionbuffer.length;
            }
            int p = 0;
            int j = pos;
            while (j < end) {
                convBuffer[p] = convolutionbuffer[j];
                ++p;
                ++j;
            }
            this.fft.calcReal(convBuffer, -1);
            pos = end;
            ++i;
        }
    }

    public void process(int start, int end, int interlace, double[] indata, double[] outdata) {
        int convFrameSize = this.convFrameSize;
        int bufferPos = this.bufferPos;
        int i = start;
        while (i < end) {
            this.inputBuffer[bufferPos] = indata[i];
            outdata[i] = this.outputBuffer[bufferPos] + this.outputBuffer2[bufferPos + convFrameSize];
            if (++bufferPos == convFrameSize) {
                double[] bak = this.outputBuffer2;
                this.outputBuffer2 = this.outputBuffer;
                this.outputBuffer = this.inputBuffer;
                this.inputBuffer = bak;
                Arrays.fill(this.inputBuffer, 0.0);
                this.process(this.outputBuffer);
                bufferPos = 0;
            }
            i += interlace;
        }
        this.bufferPos = bufferPos;
    }

    public void process(double[] buffer) {
        double fftGain = this.fftGain;
        int sp = this.smplBufferPos;
        this.fft.calcReal(buffer, -1);
        double[] smplBuffer = this.smplBuffers[sp];
        int i = 0;
        while (i < this.fftFrameSize) {
            smplBuffer[i] = buffer[i] * fftGain;
            ++i;
        }
        Arrays.fill(buffer, 0.0);
        i = 0;
        while (i < this.convBufferCount) {
            double[] sampleBuff = this.smplBuffers[sp];
            double[] convBuff = this.convBuffers[i];
            int j = 0;
            while (j < this.fftFrameSize) {
                double s_r = sampleBuff[j];
                double s_i = sampleBuff[j + 1];
                double c_r = convBuff[j];
                double c_i = convBuff[j + 1];
                int n = j;
                buffer[n] = buffer[n] + (s_r * c_r - s_i * c_i);
                int n2 = j + 1;
                buffer[n2] = buffer[n2] + (s_r * c_i + c_r * s_i);
                j += 2;
            }
            if (--sp == -1) {
                sp = this.convBufferCount - 1;
            }
            ++i;
        }
        this.fft.calcReal(buffer, 1);
        ++this.smplBufferPos;
        this.smplBufferPos %= this.convBufferCount;
    }
}

