/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;

public class LogDFT {
    private double[] log_aa = null;
    private double[] log_ptable = null;
    int fftFrameSize;

    public LogDFT(int fftFrameSize) {
        this.fftFrameSize = fftFrameSize;
        this.log_aa = new double[fftFrameSize];
        int partials = fftFrameSize / 2;
        int p = 0;
        this.log_ptable = new double[2 * fftFrameSize * partials];
        int i = 0;
        while (i < fftFrameSize) {
            int h = 0;
            while (h < partials) {
                double dpartials = partials;
                double hfs = (double)(fftFrameSize / 2) * Math.pow(32.0, (dpartials - 1.0 - (double)h) / (dpartials - 1.0));
                double pd = Math.PI / hfs;
                double im = (double)i - hfs;
                double th = pd * (double)(h + 1) * im;
                double window = -0.5 * Math.cos(Math.PI * 2 * (double)i / (double)fftFrameSize) + 0.5;
                this.log_ptable[p++] = window * Math.cos(th);
                this.log_ptable[p++] = window * Math.sin(th);
                ++h;
            }
            ++i;
        }
    }

    public final void calcLOGDFT(double[] data) {
        int framesize = this.fftFrameSize;
        Arrays.fill(this.log_aa, 0.0);
        int i = 0;
        int p = 0;
        while (i < framesize) {
            double w = data[i * 2];
            int h = 0;
            while (h < framesize) {
                int n = h++;
                this.log_aa[n] = this.log_aa[n] + w * this.log_ptable[p++];
            }
            ++i;
        }
        int h = 0;
        while (h < this.fftFrameSize) {
            data[h] = this.log_aa[h];
            ++h;
        }
    }
}

