/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled.util;

import java.util.Arrays;

public class PitchShiftOrg {
    public static final double M_PI = Math.PI;
    public static final int MAX_FRAME_LENGTH = 8192;
    private double[] gInFIFO = new double[8192];
    private double[] gOutFIFO = new double[8192];
    private double[] gFFTworksp = new double[16384];
    private double[] gLastPhase = new double[4097];
    private double[] gSumPhase = new double[4097];
    private double[] gOutputAccum = new double[16384];
    private double[] gAnaFreq = new double[8192];
    private double[] gAnaMagn = new double[8192];
    private double[] gSynFreq = new double[8192];
    private double[] gSynMagn = new double[8192];
    private int gRover = -1;
    int fftFrameSize;
    int osamp;
    double sampleRate;
    int fftFrameSize2;
    double[] window_table;

    public PitchShiftOrg(int fftFrameSize, int osamp, double sampleRate) {
        Arrays.fill(this.gInFIFO, 0.0);
        Arrays.fill(this.gOutFIFO, 0.0);
        Arrays.fill(this.gFFTworksp, 0.0);
        Arrays.fill(this.gLastPhase, 0.0);
        Arrays.fill(this.gSumPhase, 0.0);
        Arrays.fill(this.gOutputAccum, 0.0);
        Arrays.fill(this.gAnaFreq, 0.0);
        Arrays.fill(this.gAnaMagn, 0.0);
        this.fftFrameSize = fftFrameSize;
        this.osamp = osamp;
        this.sampleRate = sampleRate;
        this.fftFrameSize2 = fftFrameSize / 2;
        this.window_table = new double[fftFrameSize];
        int k = 0;
        while (k < fftFrameSize) {
            this.window_table[k] = -0.5 * Math.cos(Math.PI * 2 * (double)k / (double)fftFrameSize) + 0.5;
            ++k;
        }
    }

    public void smbPitchShift(double pitchShift, double[] pitchtable, int p_start, int start, int end, int interlace, double[] indata, double[] outdata) {
        int stepSize = this.fftFrameSize / this.osamp;
        double freqPerBin = this.sampleRate / (double)this.fftFrameSize;
        double expct = Math.PI * 2 * (double)stepSize / (double)this.fftFrameSize;
        int inFifoLatency = this.fftFrameSize - stepSize;
        if (this.gRover == -1) {
            this.gRover = inFifoLatency;
        }
        int pi = p_start;
        int i = start;
        while (i < end) {
            this.gInFIFO[this.gRover] = indata[i];
            outdata[i] = this.gOutFIFO[this.gRover - inFifoLatency];
            ++this.gRover;
            ++pi;
            if (this.gRover >= this.fftFrameSize) {
                double tmp;
                double phase;
                double magn;
                double window;
                this.gRover = inFifoLatency;
                if (pitchtable != null) {
                    pitchShift = pitchtable[pi];
                }
                int k = 0;
                while (k < this.fftFrameSize) {
                    window = this.window_table[k];
                    this.gFFTworksp[2 * k] = this.gInFIFO[k] * window;
                    this.gFFTworksp[2 * k + 1] = 0.0;
                    ++k;
                }
                this.smbFft(this.gFFTworksp, this.fftFrameSize, -1);
                k = 0;
                while (k <= this.fftFrameSize2) {
                    double real = this.gFFTworksp[2 * k];
                    double imag = this.gFFTworksp[2 * k + 1];
                    magn = 2.0 * Math.sqrt(real * real + imag * imag);
                    phase = Math.atan2(imag, real);
                    tmp = phase - this.gLastPhase[k];
                    this.gLastPhase[k] = phase;
                    int qpd = (int)((tmp -= (double)k * expct) / Math.PI);
                    qpd = qpd >= 0 ? (qpd += qpd & 1) : (qpd -= qpd & 1);
                    tmp -= Math.PI * (double)qpd;
                    tmp = (double)this.osamp * tmp / (Math.PI * 2);
                    tmp = (double)k * freqPerBin + tmp * freqPerBin;
                    this.gAnaMagn[k] = magn;
                    this.gAnaFreq[k] = tmp;
                    ++k;
                }
                Arrays.fill(this.gSynMagn, 0.0);
                Arrays.fill(this.gSynFreq, 0.0);
                k = 0;
                while (k <= this.fftFrameSize2) {
                    int index = (int)((double)k / pitchShift);
                    if (index <= this.fftFrameSize2) {
                        int n = k;
                        this.gSynMagn[n] = this.gSynMagn[n] + this.gAnaMagn[index];
                        this.gSynFreq[k] = this.gAnaFreq[index] * pitchShift;
                    }
                    ++k;
                }
                k = 0;
                while (k <= this.fftFrameSize2) {
                    magn = this.gSynMagn[k];
                    tmp = this.gSynFreq[k];
                    tmp -= (double)k * freqPerBin;
                    tmp /= freqPerBin;
                    tmp = Math.PI * 2 * tmp / (double)this.osamp;
                    int n = k;
                    this.gSumPhase[n] = this.gSumPhase[n] + (tmp += (double)k * expct);
                    phase = this.gSumPhase[k];
                    this.gFFTworksp[2 * k] = magn * Math.cos(phase);
                    this.gFFTworksp[2 * k + 1] = magn * Math.sin(phase);
                    ++k;
                }
                k = this.fftFrameSize + 2;
                while (k < 2 * this.fftFrameSize) {
                    this.gFFTworksp[k] = 0.0;
                    ++k;
                }
                this.smbFft(this.gFFTworksp, this.fftFrameSize, 1);
                k = 0;
                while (k < this.fftFrameSize) {
                    window = -0.5 * Math.cos(Math.PI * 2 * (double)k / (double)this.fftFrameSize) + 0.5;
                    int n = k;
                    this.gOutputAccum[n] = this.gOutputAccum[n] + 2.0 * window * this.gFFTworksp[2 * k] / (double)(this.fftFrameSize2 * this.osamp);
                    ++k;
                }
                k = 0;
                while (k < stepSize) {
                    this.gOutFIFO[k] = this.gOutputAccum[k];
                    ++k;
                }
                int shift_len = this.gOutputAccum.length / 2;
                int j = 0;
                while (j < shift_len) {
                    this.gOutputAccum[j] = this.gOutputAccum[j + stepSize];
                    ++j;
                }
                k = 0;
                while (k < inFifoLatency) {
                    this.gInFIFO[k] = this.gInFIFO[k + stepSize];
                    ++k;
                }
            }
            i += interlace;
        }
    }

    public void smbFft(double[] fftBuffer, int fftFrameSize, int sign) {
        int j;
        int i = 2;
        while (i < 2 * fftFrameSize - 2) {
            int bitm = 2;
            j = 0;
            while (bitm < 2 * fftFrameSize) {
                if ((i & bitm) != 0) {
                    ++j;
                }
                j <<= 1;
                bitm <<= 1;
            }
            if (i < j) {
                int p1 = i;
                int p2 = j;
                double temp = fftBuffer[p1];
                fftBuffer[p1++] = fftBuffer[p2];
                fftBuffer[p2++] = temp;
                temp = fftBuffer[p1];
                fftBuffer[p1] = fftBuffer[p2];
                fftBuffer[p2] = temp;
            }
            i += 2;
        }
        int k_len = (int)(Math.log(fftFrameSize) / Math.log(2.0));
        int k = 0;
        int le = 2;
        while (k < k_len) {
            int le2 = (le <<= 1) >> 1;
            double ur = 1.0;
            double ui = 0.0;
            double arg = Math.PI / (double)(le2 >> 1);
            double wr = Math.cos(arg);
            double wi = (double)sign * Math.sin(arg);
            j = 0;
            while (j < le2) {
                double tr;
                int p1r = j;
                int p1i = p1r + 1;
                int p2r = p1r + le2;
                int p2i = p2r + 1;
                i = j;
                while (i < 2 * fftFrameSize) {
                    tr = fftBuffer[p2r] * ur - fftBuffer[p2i] * ui;
                    double ti = fftBuffer[p2r] * ui + fftBuffer[p2i] * ur;
                    fftBuffer[p2r] = fftBuffer[p1r] - tr;
                    fftBuffer[p2i] = fftBuffer[p1i] - ti;
                    int n = p1r;
                    fftBuffer[n] = fftBuffer[n] + tr;
                    int n2 = p1i;
                    fftBuffer[n2] = fftBuffer[n2] + ti;
                    p1r += le;
                    p1i += le;
                    p2r += le;
                    p2i += le;
                    i += le;
                }
                tr = ur * wr - ui * wi;
                ui = ur * wi + ui * wr;
                ur = tr;
                j += 2;
            }
            ++k;
        }
    }
}

