/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sf2;

import java.io.File;
import org.w3c.dom.Element;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.io.Resource;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sf2.SF2SoundFont;
import rasmus.interpreter.sf2.SF2SoundFontManager;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class SF2SampleInstance
extends UnitInstanceAdapter {
    Variable sample;
    Variable filename;
    Variable output;
    Variable answer = null;
    Interpreter interpreter = null;
    Resource resource = null;
    NameSpace namespace;
    ResourceManager manager;

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
        if (this.interpreter != null) {
            this.interpreter.close();
            this.interpreter = null;
        }
    }

    public void calc() {
        this.clear();
        String filename = ObjectsPart.toString(this.filename);
        int sampleid = (int)DoublePart.asDouble(this.sample);
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = this.manager.getResource(filename);
        if (this.resource == null) {
            return;
        }
        File file = this.resource.getFile();
        filename = file.getPath();
        SF2SoundFont sf2soundfontinfo = SF2SoundFontManager.getSF2SoundFont(filename);
        Element sampleinfo = sf2soundfontinfo.getSample(sampleid);
        if (sampleinfo == null) {
            return;
        }
        long offset = Long.parseLong(sampleinfo.getAttribute("offset"));
        long length = Long.parseLong(sampleinfo.getAttribute("datalength"));
        this.interpreter = new Interpreter();
        this.interpreter.setAutoCommit(false);
        this.interpreter.add("filename", ObjectsPart.asVariable(filename));
        this.interpreter.add("offset", DoublePart.asVariable(offset));
        this.interpreter.add("length", DoublePart.asVariable(length));
        try {
            this.answer = this.interpreter.eval("Sample(filename, offset, length)");
        }
        catch (ScriptParserException e) {
            e.printStackTrace();
        }
        this.output.add(this.answer);
    }

    public SF2SampleInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.manager = ResourceManager.getInstance(this.namespace);
        this.output = parameters.getParameterWithDefault("output");
        this.filename = parameters.getParameterWithDefault(1, "filename");
        this.sample = parameters.getParameterWithDefault(2, "sample");
        DoublePart.getInstance(this.sample).addListener(this);
        ObjectsPart.getInstance(this.filename).addListener(this);
        this.calc();
    }

    public void close() {
        this.clear();
        if (this.resource != null) {
            this.resource.close();
            this.resource = null;
        }
        DoublePart.getInstance(this.sample).removeListener(this);
        ObjectsPart.getInstance(this.filename).removeListener(this);
    }
}

