/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JMenu;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.ui.GroupMenuListener;
import rasmus.interpreter.ui.InterpreterGroupMenuitem;
import rasmus.interpreter.ui.RegisterConstant;
import rasmus.interpreter.ui.RegisterFunction;
import rasmus.interpreter.ui.RegisterGroup;
import rasmus.interpreter.ui.RegisterUnit;

public class GroupMenus
extends JMenu
implements ListPartListener,
Commitable {
    private static final long serialVersionUID = 1L;
    ObjectsPart group;
    GroupMenuListener listener;
    NameSpace namespace;
    Object[] objects;
    double longestname = 0.0;
    String longestnametxt = null;
    static BufferedImage dummy_image = new BufferedImage(32, 32, 1);

    public GroupMenus(NameSpace namespace, GroupMenuListener listener) {
        super("Insert");
        this.namespace = namespace;
        this.listener = listener;
        this.group = ObjectsPart.getInstance(namespace.get("groups"));
        this.commit();
        this.group.addListener(this);
    }

    public GroupMenus(NameSpace namespace, RegisterGroup.Record record, GroupMenuListener listener) {
        super(record.description);
        this.namespace = namespace;
        this.listener = listener;
        this.group = ObjectsPart.getInstance(record.childs);
        this.commit();
        this.group.addListener(this);
    }

    public void close() {
        this.group.removeListener(this);
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof GroupMenus) {
                ((GroupMenus)comps[i]).close();
            }
            ++i;
        }
        this.removeAll();
    }

    public void objectAdded(ListPart source, Object object) {
        this.namespace.addToCommitStack(this);
    }

    public void objectRemoved(ListPart source, Object object) {
        this.namespace.addToCommitStack(this);
    }

    public void objectsAdded(ListPart source, List objects) {
        this.namespace.addToCommitStack(this);
    }

    public void objectsRemoved(ListPart source, List objects) {
        this.namespace.addToCommitStack(this);
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof GroupMenus) {
                ((GroupMenus)comps[i]).close();
            }
            ++i;
        }
        this.removeAll();
        this.objects = this.group.getObjects().toArray();
        Arrays.sort(this.objects, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = "";
                String s2 = "";
                if (o1 instanceof RegisterGroup.Record) {
                    s1 = "1" + ((RegisterGroup.Record)o1).description;
                }
                if (o2 instanceof RegisterGroup.Record) {
                    s2 = "1" + ((RegisterGroup.Record)o2).description;
                }
                if (o1 instanceof RegisterUnit.Record) {
                    s1 = ((RegisterUnit.Record)o1).unit instanceof RegisterConstant ? "2" + ((RegisterUnit.Record)o1).name : "3" + ((RegisterUnit.Record)o1).name;
                }
                if (o2 instanceof RegisterUnit.Record) {
                    s2 = ((RegisterUnit.Record)o2).unit instanceof RegisterConstant ? "2" + ((RegisterUnit.Record)o2).name : "3" + ((RegisterUnit.Record)o2).name;
                }
                s1 = s1.toLowerCase();
                s2 = s2.toLowerCase();
                return s1.compareTo(s2);
            }
        });
        i = 0;
        while (i < this.objects.length) {
            Object object = this.objects[i];
            if (object instanceof RegisterGroup.Record) {
                this.add(new GroupMenus(this.namespace, (RegisterGroup.Record)object, this.listener));
            } else if (object instanceof RegisterUnit.Record) {
                RegisterUnit.Record record = (RegisterUnit.Record)object;
                this.add(new InterpreterGroupMenuitem(this, record, this.listener));
            }
            ++i;
        }
    }

    public String getLongestName() {
        if (this.longestnametxt == null) {
            Graphics g = dummy_image.getGraphics();
            Font ofont = this.getFont().deriveFont(1);
            g.setFont(ofont.deriveFont(1));
            FontMetrics fm = g.getFontMetrics();
            int i = 0;
            while (i < this.objects.length) {
                Object object = this.objects[i];
                if (object instanceof RegisterUnit.Record) {
                    double w;
                    RegisterUnit.Record record = (RegisterUnit.Record)object;
                    String namecaption = record.name;
                    if (record.unit instanceof RegisterConstant) {
                        namecaption = namecaption.toUpperCase();
                    }
                    if (record.unit instanceof RegisterFunction) {
                        namecaption = String.valueOf(namecaption.toLowerCase()) + "()";
                    }
                    if ((w = fm.getStringBounds(namecaption, g).getWidth()) > this.longestname) {
                        this.longestname = w;
                        this.longestnametxt = namecaption;
                    }
                }
                ++i;
            }
        }
        return this.longestnametxt;
    }

    public double getLongestName(Graphics g) {
        if (this.longestname == 0.0) {
            this.getLongestName();
        }
        return this.longestname;
    }
}

