/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import rasmus.interpreter.ui.GroupMenuListener;
import rasmus.interpreter.ui.GroupMenus;
import rasmus.interpreter.ui.RegisterConstant;
import rasmus.interpreter.ui.RegisterFunction;
import rasmus.interpreter.ui.RegisterUnit;

class InterpreterGroupMenuitem
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    String namecaption;
    String description;
    RegisterUnit.Record record;
    GroupMenus parentgroup;
    GroupMenuListener listener;
    Color textcolor = (ColorUIResource)UIManager.getColor("MenuItem.foreground");
    Color textselcolor = (ColorUIResource)UIManager.getColor("MenuItem.selectionForeground");
    Color textfieldcolor = (ColorUIResource)UIManager.getColor("TextField.background");
    Color panelcolor = (ColorUIResource)UIManager.getColor("Panel.background");
    static Font boldfont = null;
    static Font plainfont = null;
    static Rectangle2D armed_empty_space = null;
    Rectangle2D bounds_namecaption = null;
    double longaestnamewidth = 0.0;

    public InterpreterGroupMenuitem(GroupMenus parentgroup, RegisterUnit.Record record, GroupMenuListener listener) {
        this.listener = listener;
        this.parentgroup = parentgroup;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                InterpreterGroupMenuitem.this.listener.actionPerformed(InterpreterGroupMenuitem.this.record);
            }
        });
        this.namecaption = record.name;
        this.description = record.description;
        this.record = record;
        if (record.unit instanceof RegisterConstant) {
            this.namecaption = this.namecaption.toUpperCase();
        }
        if (record.unit instanceof RegisterFunction) {
            this.namecaption = String.valueOf(this.namecaption.toLowerCase()) + "()";
        }
        this.setText(String.valueOf(parentgroup.getLongestName()) + " - " + record.description + "  ");
    }

    public void paint(Graphics g) {
        String text = this.getText();
        this.setText("");
        super.paint(g);
        Font ofont = g.getFont();
        if (boldfont == null) {
            boldfont = ofont.deriveFont(1);
        }
        g.setFont(boldfont);
        if (this.longaestnamewidth == 0.0) {
            this.longaestnamewidth = this.parentgroup.getLongestName(g);
        }
        if (!this.isArmed()) {
            if (armed_empty_space == null) {
                armed_empty_space = g.getFontMetrics().getStringBounds(" ", g);
            }
            Rectangle2D sr = armed_empty_space;
            Color color = g.getColor();
            g.setColor(this.panelcolor);
            g.fillRect(0, 0, 5 + (int)(this.longaestnamewidth + sr.getWidth()), this.getHeight());
            g.setColor(this.textfieldcolor);
            g.fillRect(5 + (int)(this.longaestnamewidth + sr.getWidth()), 0, this.getWidth(), this.getHeight());
            g.setColor(color);
        }
        if (this.isArmed()) {
            g.setColor(this.textselcolor);
        } else {
            g.setColor(this.textcolor);
        }
        if (this.bounds_namecaption == null) {
            this.bounds_namecaption = g.getFontMetrics().getStringBounds(this.namecaption, g);
        }
        Rectangle2D r = this.bounds_namecaption;
        g.drawString(this.namecaption, 5, (int)r.getHeight());
        if (plainfont == null) {
            plainfont = ofont.deriveFont(0);
        }
        g.setFont(plainfont);
        g.drawString("   " + this.description, 5 + (int)this.longaestnamewidth, (int)r.getHeight());
        g.setFont(ofont);
        this.setText(text);
    }
}

