/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ui;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoableEdit;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.parser.ScriptTokenParser;

public class RSyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 1L;
    Element root;
    SimpleAttributeSet style_normal = new SimpleAttributeSet();
    SimpleAttributeSet style_parameter = new SimpleAttributeSet();
    SimpleAttributeSet style_string = new SimpleAttributeSet();
    SimpleAttributeSet style_number = new SimpleAttributeSet();
    SimpleAttributeSet style_comment = new SimpleAttributeSet();
    SimpleAttributeSet style_symbol = new SimpleAttributeSet();
    SimpleAttributeSet style_keyword = new SimpleAttributeSet();
    SimpleAttributeSet style_keyword_variable = new SimpleAttributeSet();
    boolean doupdate = true;
    ArrayList undoablelisteners = new ArrayList();
    private UndoableEditListener uel = new UndoableEditListener(){

        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit edit = e.getEdit();
            if (edit instanceof AbstractDocument.DefaultDocumentEvent && ((AbstractDocument.DefaultDocumentEvent)edit).getType() == DocumentEvent.EventType.CHANGE) {
                return;
            }
            for (UndoableEditListener listener : RSyntaxDocument.this.undoablelisteners) {
                listener.undoableEditHappened(e);
            }
        }
    };
    ScriptTokenParser parser;
    boolean ishandlingremove = false;

    public void setText(String text) {
        try {
            this.remove(0, this.getLength());
            this.insertString(0, text, this.style_normal);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public int[] extractFunctionCall(int offs) throws BadLocationException {
        int i;
        int doclen = this.getLength();
        int[] pair = this.extractNormalToken(offs);
        if (pair == null) {
            return null;
        }
        int status = 0;
        for (i = pair[0] + pair[1]; i < doclen; ++i) {
            char cc = this.getText(i, 1).charAt(0);
            status = ScriptTokenParser.parseStatus(cc, status);
            if (status == 0) {
                if (cc == '(') break;
                if (cc == ' ') continue;
                return null;
            }
            if (!ScriptTokenParser.isStringStatus(status)) continue;
            return null;
        }
        int clevel = 0;
        while (i < doclen) {
            char cc = this.getText(i, 1).charAt(0);
            status = ScriptTokenParser.parseStatus(cc, status);
            if (status == 0) {
                if (cc == '(') {
                    ++clevel;
                } else if (cc == ')' && --clevel == 0) break;
            }
            ++i;
        }
        pair[1] = i - pair[0] + 1;
        return pair;
    }

    public int[] extractNormalToken(int offs) throws BadLocationException {
        int status = this.parseStatus(offs);
        if (status != 0) {
            return null;
        }
        char c = this.getText(offs, 1).charAt(0);
        if ("=+-<>/!*^&(),{};".indexOf(c) != -1) {
            return null;
        }
        int doclen = this.getLength();
        if (ScriptTokenParser.isVariableOrNumberLetter(c)) {
            char cc;
            int begin = offs;
            int end = offs;
            int o = begin;
            while (--o >= 0 && ScriptTokenParser.isVariableOrNumberLetter(cc = this.getText(o, 1).charAt(0))) {
                begin = o;
            }
            o = end;
            while (++o < doclen && ScriptTokenParser.isVariableOrNumberLetter(cc = this.getText(o, 1).charAt(0))) {
                end = o;
            }
            int slen = end + 1 - begin;
            int[] pair = new int[]{begin, slen};
            return pair;
        }
        return null;
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoablelisteners.add(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoablelisteners.remove(listener);
    }

    public RSyntaxDocument(NameSpace namespace) {
        this.root = this.getDefaultRootElement();
        this.parser = new ScriptTokenParser(namespace);
        super.addUndoableEditListener(this.uel);
        StyleConstants.setForeground(this.style_normal, Color.BLACK);
        StyleConstants.setForeground(this.style_parameter, Color.GRAY);
        StyleConstants.setForeground(this.style_string, Color.BLUE);
        StyleConstants.setForeground(this.style_number, Color.RED);
        StyleConstants.setForeground(this.style_symbol, Color.BLUE.darker());
        StyleConstants.setForeground(this.style_comment, Color.GREEN.darker());
        StyleConstants.setItalic(this.style_comment, true);
        StyleConstants.setForeground(this.style_keyword, Color.MAGENTA.darker());
        StyleConstants.setBold(this.style_keyword, true);
        StyleConstants.setForeground(this.style_keyword_variable, Color.MAGENTA.darker());
    }

    protected void fireInsertUpdate(DocumentEvent evt) {
        super.fireInsertUpdate(evt);
        if (!this.doupdate) {
            return;
        }
        try {
            int offs = evt.getOffset();
            int len = evt.getLength();
            String str = this.getText(offs, len);
            int status = this.parseStatus(offs);
            this.applyHighlighting(offs, str.length());
            int newstatus = ScriptTokenParser.parseStatus(str, status);
            if (newstatus != status) {
                int nextoffs = this.findNextSameStatus(offs += str.length(), newstatus, status);
                this.applyHighlighting(offs, nextoffs - offs + 1);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void fireRemoveUpdate(DocumentEvent evt) {
        super.fireRemoveUpdate(evt);
        if (!this.doupdate) {
            return;
        }
        if (!this.ishandlingremove) {
            try {
                this.applyHighlighting(0, this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        String removedcontent = this.getText(offs, len);
        this.ishandlingremove = true;
        super.remove(offs, len);
        this.ishandlingremove = false;
        int status = this.parseStatus(offs);
        this.applyHighlighting(offs, 0);
        int oldstatus = ScriptTokenParser.parseStatus(removedcontent, status);
        if (oldstatus != status) {
            int nextoffs = this.findNextSameStatus(offs, oldstatus, status);
            this.applyHighlighting(offs, nextoffs - offs + 1);
        }
    }

    public int applyHighlighting(int offs, int len) throws BadLocationException {
        int doclen = this.getLength();
        if ((offs -= 10) < 0) {
            offs = 0;
        }
        if ((len += 20) >= doclen - offs) {
            len = doclen - offs;
        }
        this.setCharacterAttributes(offs, len, this.style_normal, true);
        String text = this.getText(offs, len);
        int status = this.parseStatus(offs);
        int i = 0;
        while (i < text.length()) {
            int starti;
            char c = text.charAt(i);
            int beforestatus = status;
            if (ScriptTokenParser.isStringStatus(status = ScriptTokenParser.parseStatus(c, status)) || ScriptTokenParser.isStringStatus(beforestatus)) {
                starti = i++;
                while (i < text.length()) {
                    beforestatus = status;
                    c = text.charAt(i);
                    status = ScriptTokenParser.parseStatus(c, status);
                    if (!ScriptTokenParser.isStringStatus(status)) {
                        status = beforestatus;
                        --i;
                        break;
                    }
                    ++i;
                }
                this.setCharacterAttributes(offs + starti, i - starti + 1, this.style_string, true);
                if (beforestatus == 3) {
                    this.setCharacterAttributes(offs + starti - 1, i - starti + 2, this.style_string, true);
                }
            } else if (ScriptTokenParser.isCommentStatus(status) || ScriptTokenParser.isCommentStatus(beforestatus)) {
                starti = i - 1;
                ++i;
                while (i < text.length()) {
                    beforestatus = status;
                    c = text.charAt(i);
                    status = ScriptTokenParser.parseStatus(c, status);
                    if (!ScriptTokenParser.isCommentStatus(status)) {
                        status = beforestatus;
                        --i;
                        break;
                    }
                    ++i;
                }
                this.setCharacterAttributes(offs + starti, i - starti + 1, this.style_comment, true);
            } else if ("=+-<>/!*^&(),{};".indexOf(c) != -1) {
                this.setCharacterAttributes(offs + i, 1, this.style_symbol, true);
            } else if (ScriptTokenParser.isVariableOrNumberLetter(c)) {
                char cc;
                int begin = offs + i;
                int end = offs + i;
                int o = begin;
                while (--o >= 0 && ScriptTokenParser.isVariableOrNumberLetter(cc = this.getText(o, 1).charAt(0))) {
                    begin = o;
                }
                o = end;
                while (++o < doclen && ScriptTokenParser.isVariableOrNumberLetter(cc = this.getText(o, 1).charAt(0))) {
                    end = o;
                    ++i;
                }
                int slen = end + 1 - begin;
                this.processToken(begin, slen);
            }
            ++i;
        }
        return status;
    }

    public char getCharAfterString(int offs) throws BadLocationException {
        int doclen = this.getLength();
        int o = offs;
        while (++o < doclen) {
            char cc = this.getText(o, 1).charAt(0);
            if (cc == ' ') continue;
            return cc;
        }
        return ' ';
    }

    public void processToken(int offs, int len) throws BadLocationException {
        String stext = this.getText(offs, len);
        if (ScriptTokenParser.isNumber(stext)) {
            this.setCharacterAttributes(offs, len, this.style_number, true);
            return;
        }
        char cs = this.getCharAfterString(offs + len - 1);
        if (cs == '(') {
            if (this.parser.isFunction(stext)) {
                this.setCharacterAttributes(offs, len, this.style_keyword, true);
                return;
            }
        } else {
            if (cs == '=') {
                this.setCharacterAttributes(offs, len, this.style_parameter, true);
                return;
            }
            if (this.parser.isRegisteredVariable(stext.toLowerCase())) {
                this.setCharacterAttributes(offs, len, this.style_keyword_variable, true);
                return;
            }
        }
        this.setCharacterAttributes(offs, len, this.style_normal, true);
    }

    public int findNextSameStatus(int offs, int statusA, int statusB) throws BadLocationException {
        int len = this.getLength() - offs;
        while (statusA != statusB) {
            if (len < 20) {
                return this.getLength();
            }
            statusA = ScriptTokenParser.parseStatus(this.getText(offs, 20), statusA);
            statusB = ScriptTokenParser.parseStatus(this.getText(offs, 20), statusB);
            len -= 20;
            offs += 20;
        }
        return offs;
    }

    public int parseStatus(int offs) throws BadLocationException {
        return ScriptTokenParser.parseStatus(this.getText(0, offs), 0);
    }
}

