/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ui;

import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstanceAdapter;
import rasmus.interpreter.unit.UnitInstancePart;

public class RegisterUnit
implements UnitFactory {
    public UnitInstancePart newInstance(Parameters parameters) {
        return new UnitInstance(parameters);
    }

    public class Record {
        public RegisterUnit unit;
        public String description;
        public String name;

        public Record() {
            this.unit = RegisterUnit.this;
        }
    }

    public class UnitInstance
    extends UnitInstanceAdapter {
        Variable output;
        Variable answer = null;
        Variable name;
        Variable description;

        public UnitInstance(Parameters parameters) {
            this.output = parameters.getParameterWithDefault("output");
            this.name = parameters.getParameterWithDefault(1, "name");
            this.description = parameters.getParameterWithDefault(2, "description");
            this.calc();
            ObjectsPart.getInstance(this.description).addListener(this);
            ObjectsPart.getInstance(this.name).addListener(this);
        }

        public void close() {
            if (this.answer != null) {
                this.output.remove(this.answer);
                this.answer = null;
            }
            ObjectsPart.getInstance(this.description).removeListener(this);
            ObjectsPart.getInstance(this.name).removeListener(this);
        }

        public void calc() {
            if (this.answer != null) {
                this.output.remove(this.answer);
                this.answer = null;
            }
            Record record = new Record();
            record.name = ObjectsPart.toString(this.name);
            record.description = ObjectsPart.toString(this.description);
            this.answer = ObjectsPart.asVariable(record);
            this.output.add(this.answer);
        }
    }
}

